/* Copyright 2006-2007 (c) Takefumi MIYOSHI All rights reserved. */

package net.wasamon.wallet.binutils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;


public class AssemblerDriver {

	private Parser parser;
	
	public ObjectData data;
	
	public AssemblerDriver(Parser parser){
		this.parser = parser;
		this.data = new ObjectData(new TextRegion(), new DataRegion()); 
	}

	public int doParse(Reader r) throws IOException, AssemblerException {
		int status = 0;

		int count = 0;
		String line = "";
		BufferedReader reader = new BufferedReader(r);
		while ((line = reader.readLine()) != null) {
			count++;
			try {
				parseLine(line);
			} catch (AssemblerException e) {
				throw new AssemblerException(e.getMessage() + " at " + line);
			}
		}
		return status;
	}

	public int doParse(String[] str) throws IOException, AssemblerException {
		int status = 0;
		int count = 0;
		for(int i = 0; i < str.length; i++){
			count++;
			try {
				parseLine(str[i]);
			} catch (AssemblerException e) {
				throw new AssemblerException(e.getMessage() + " at " + str[i]);
			}
		}
		return status;
	}

	private Section currentSection;

	private void parseLine(String str) throws AssemblerException {
		str = str.trim();
		if (str.equals("")) {
		}else if(parser.isComment(str)){
		} else if (parser.isSection(str)) {
			currentSection = data.getSection(parser.getSectionName(str));
		} else if (parser.isLabel(str)) {
			currentSection.addLabel(parser.getLabelStr(str));
		} else if (parser.isAssemblerCommand(str)) {
			if(currentSection != null){
				currentSection.execCommand(parser, str);
			}
		} else {
			currentSection.addData(parser, str);
		}
	}

	private void outputData(OutputStream out) throws IOException{
		PrintWriter writer = new PrintWriter(out);
		writer.println("<assembler>");
		data.writeAsXML(writer);
		writer.println("</assembler>");
		writer.flush();
	}
	
	public void go(InputStream in, OutputStream out) throws AssemblerException, IOException{
		doParse(new InputStreamReader(in));
		outputData(out);
		out.flush();
		out.close();
	}

	
}
