/* Copyright 2006-2007 (c) Takefumi MIYOSHI All rights reserved. */

package net.wasamon.wallet;

import java.util.ArrayList;

public class WalletOptionSpec {

	private int outputType = outputTypeBin;

	public final static int outputTypeAsm = 1;

	public final static int outputTypeLIR = 2;

	public final static int outputTypeHIR = 3;

	public final static int outputTypeSnapShot = 4;

	public final static int outputTypeBin = 6;
	
	private String[] filename;
	
	private String outFileName;
	
	public String[] getFileName(){
		return filename;
	}
	public void setFileName(String[] filename){
		this.filename = filename;
	}

	private String processor;
	public String getProcessor(){
		return processor;
	}
	public void setProcessor(String arg){
		this.processor = arg;
	}

	public void setOutputFileName(String filename, String ext){
		int idx = filename.lastIndexOf('.');
		if(idx > 0){
			outFileName = filename.substring(0, idx) + "." + ext;
		}else{
			outFileName = filename + "." + ext;
		}
	}
	public String getOutputFileName(){
		return outFileName;
	}

	public void setOutputType(int value){
		outputType = value;
	}
	
	public int getOutputType(){
		return outputType;
	}
	
	
	private boolean checkNoAlign;
	public void setCheckNoAlign(boolean flag){
		checkNoAlign = flag;
	}
	public boolean isCheckNoAlign(){
		return checkNoAlign;
	}

	public String[] getCoinsArgs() {
		ArrayList args = new ArrayList();
		if (filename == null || filename.length == 0) {
			return new String[] {};
		}
		args.add("-b");
		args.add(processor);
		switch (outputType) {
		case outputTypeAsm:
			args.add("-S");
			break;
		case outputTypeLIR:
			args.add("-coins:suffixoption=out-newlir");
			args.add("-S");
			break;
		case outputTypeSnapShot:
			args.add("-coins:snapshot");
			args.add("-S");
			break;
		case outputTypeHIR:
			args.add("-coins:dumphir=t1");
			args.add("-S");
			break;
		case outputTypeBin:
			args.add("-o");
			args.add(getOutputFileName());
			break;
		}
		if (checkNoAlign) {
			args.add("-coins:no-align");
		}
		for(int i = 0; i < filename.length; i++){
			args.add(filename[i]);
		}
		return (String[])(args.toArray(new String[args.size()]));
	}
}
