#define CHARACTER_DISPLAY (0x0a000000)

char chartbl[] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

int display_index;
int put_char(char d){
  *((char*)CHARACTER_DISPLAY+display_index) = d;
  display_index++;
}

void put_hex_digit(char a){
  put_char(chartbl[(a >> 4) & 0x0f]);
  put_char(chartbl[a & 0x0f]);
}

void put_short_hexstr(short a){
  put_char(chartbl[(a >> 12) & 0x0f]);
  put_char(chartbl[(a >> 8)  & 0x0f]);
  put_char(chartbl[(a >> 4) & 0x0f]);
  put_char(chartbl[a & 0x0f]);
}

void put_int_hexstr(int a){
  put_char(chartbl[(a >> 28) & 0x0f]);
  put_char(chartbl[(a >> 24) & 0x0f]);
  put_char(chartbl[(a >> 20) & 0x0f]);
  put_char(chartbl[(a >> 16) & 0x0f]);
  put_char(chartbl[(a >> 12) & 0x0f]);
  put_char(chartbl[(a >> 8)  & 0x0f]);
  put_char(chartbl[(a >> 4) & 0x0f]);
  put_char(chartbl[a & 0x0f]);
}

int main(){
  display_index = 0;
  put_hex_digit(0xab);
  put_hex_digit(0x34);
  put_int_hexstr(0x12345678);
  put_int_hexstr(0xabcd);
  put_char('\n');
  put_char('t');
  put_char('e');
  put_char('s');
  put_char('t');
}
