#define DISPLAY_ADDR (0x09000000)
#define DISPLAY_WIDTH 160
#define DISPLAY_HEIGHT 120

struct color{
  char red;
  char blue;
  char green;
};

int hton_int(int a){
  int v = 0;
  v += ((a >> 24)&0x000000ff) <<  0;
  v += ((a >> 16)&0x000000ff) <<  8;
  v += ((a >>  8)&0x000000ff) << 16;
  v += ((a >>  0)&0x000000ff) << 24;
  return v;
}

short hton_short(short a){
  short v = 0;
  v += ((a >> 8)&0x00ff) << 0;
  v += ((a >> 0)&0x00ff) << 8;
  return v;
}

int fill_rect(unsigned char* dest, int x0, int y0, int width, int height, struct color* c)
{
  int i, j, line, xpos;
  for(i = 0; i < height; i++){
	line = i * DISPLAY_WIDTH;
	for(j = 0; j < width; j++){
	  xpos = (line + j) * 3;
	  *(dest + xpos)   = c->red;
	  *(dest + xpos + 1) = c->green;
	  *(dest + xpos + 2) = c->blue;
	}
  }
}

int draw_line(unsigned char* dest, int x0, int y0, int x1, int y1, struct color* c)
{
}

int main()
{
  unsigned char * dest;
  struct color c;
  dest = (unsigned char*)DISPLAY_ADDR;
  c.red = 255;
  c.blue = 128;
  c.green = 128;
  fill_rect(dest, 10, 10, 20, 20, &c);
}
