--
-- ͂ꂽASCIIR[h
-- L[XLCfbNXɑ΂L[XLf[^ԂW[
--
-- Written by TOZAWA
-- 
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;
library work;

entity kb_ascii2key is
  port (
    -- ͂ASCIIR[h
    pData   : in  std_logic_vector(7 downto 0);
    -- L[{[hƂI/F
    pIndex  : in  std_logic_vector(17 downto 0); -- L[{[h^L[XLAhX
    pOutput : out std_logic_vector(7 downto 0); -- L[{[hɗ^L[XLf[^
    -- 
    pClk    : in  std_logic;
    pReset  : in  std_logic
    );
end kb_ascii2key;

architecture RTL of kb_ascii2key is

begin

  process(pClk, pReset)
  begin
    if pReset = '1' then
      pOutput <= (others => '1');
    elsif pClk'event and pClk = '1' then

      case pData is
        --when "00000000" => --NUL
        --when "00000001" => --SOH
        --when "00000010" => --STX
        --when "00000011" => --ETX
        --when "00000100" => --EOT
        --when "00000101" => --ENQ
        --when "00000110" => --ACK
        --when "00000111" => --BEL
        when "00001000" => --BS
          if pIndex(0) = '0' then
            pOutput <= "11111011";
          else
            pOutput <= "11111111";
          end if;
          --when "00001001" => --HT
          --when "00001010" => --NL
          --when "00001011" => --VT
          --when "00001100" => --NP
        when "00001101" => --CR
          if pIndex(0) = '0' then
            pOutput <= "11101111";
          else
            pOutput <= "11111111";
          end if;
          --when "00001110" => --SO
          --when "00001111" => --SI
          --when "00010000" => --DLE
          --when "00010001" => --DC1
          --when "00010010" => --DC2
          --when "00010011" => --DC3
          --when "00010100" => --DC4
          --when "00010101" => --NAK
          --when "00010110" => --SYN
          --when "00010111" => --ETB
          --when "00011000" => --CAN
          --when "00011001" => --EM
          --when "00011010" => --SUB
        when "00011011" => --ESC
          if pIndex(6) = '0' then
            pOutput <= "10111111";
          else
            pOutput <= "11111111";
          end if;
          --when "00011100" => --FS
          --when "00011101" => --GS
          --when "00011110" => --RS
          --when "00011111" => --US
        when "00100000" => --' '
          if pIndex(17) = '0' then
            pOutput <= "10111111";
          else
            pOutput <= "11111111";
          end if;
        when "00100001" => --'!'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(6) = '0' then
            pOutput <= "11111101";
          else
            pOutput <= "11111111";
          end if;
        when "00100010" => --'"'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(7) = '0' then
            pOutput <= "11111101";
          else
            pOutput <= "11111111";
          end if;
        when "00100011" => --'#'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(1) = '0' then
            pOutput <= "11111101";
          else
            pOutput <= "11111111";
          end if;
        when "00100100" => --'$'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(5) = '0' then
            pOutput <= "11111101";
          else
            pOutput <= "11111111";
          end if;
        when "00100101" => --'%'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(5) = '0' then
            pOutput <= "11111110";
          else
            pOutput <= "11111111";
          end if;
        when "00100110" => --'&'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(4) = '0' then
            pOutput <= "11111110";
          else
            pOutput <= "11111111";
          end if;
        when "00100111" => --'''
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(4) = '0' then
            pOutput <= "11111101";
          else
            pOutput <= "11111111";
          end if;
        when "00101000" => --'('
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(3) = '0' then
            pOutput <= "11111101";
          else
            pOutput <= "11111111";
          end if;
        when "00101001" => --')'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(9) = '0' then
            pOutput <= "11111101";
          else
            pOutput <= "11111111";
          end if;
        when "00101010" => --'*'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(2) = '0' then
            pOutput <= "10111111";
          else
            pOutput <= "11111111";
          end if;
        when "00101011" => --'+'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(2) = '0' then
            pOutput <= "11011111";
          else
            pOutput <= "11111111";
          end if;
        when "00101100" => --','
          if pIndex(3) = '0' then
            pOutput <= "11101111";
          else
            pOutput <= "11111111";
          end if;
        when "00101101" => --'-'
          if pIndex(2) = '0' then
            pOutput <= "11111110";
          else
            pOutput <= "11111111";
          end if;
        when "00101110" => --'.'
          if pIndex(9) = '0' then
            pOutput <= "11101111";
          else
            pOutput <= "11111111";
          end if;
        when "00101111" => --'/'
          if pIndex(2) = '0' then
            pOutput <= "01111111";
          else
            pOutput <= "11111111";
          end if;
        when "00110000" => --'0'
          if pIndex(2) = '0' then
            pOutput <= "11111101";
          else
            pOutput <= "11111111";
          end if;
        when "00110001" => --'1'
          if pIndex(6) = '0' then
            pOutput <= "11111101";
          else
            pOutput <= "11111111";
          end if;
        when "00110010" => --'2'
          if pIndex(7) = '0' then
            pOutput <= "11111101";
          else
            pOutput <= "11111111";
          end if;
        when "00110011" => --'3'
          if pIndex(1) = '0' then
            pOutput <= "11111101";
          else
            pOutput <= "11111111";
          end if;
        when "00110100" => --'4'
          if pIndex(5) = '0' then
            pOutput <= "11111110";
          else
            pOutput <= "11111111";
          end if;
        when "00110101" => --'5'
          if pIndex(5) = '0' then
            pOutput <= "11111110";
          else
            pOutput <= "11111111";
          end if;
        when "00110110" => --'6'
          if pIndex(4) = '0' then
            pOutput <= "11111110";
          else
            pOutput <= "11111111";
          end if;
        when "00110111" => --'7'
          if pIndex(4) = '0' then
            pOutput <= "11111101";
          else
            pOutput <= "11111111";
          end if;
        when "00111000" => --'8'
          if pIndex(3) = '0' then
            pOutput <= "11111101";
          else
            pOutput <= "11111111";
          end if;
        when "00111001" => --'9'
          if pIndex(9) = '0' then
            pOutput <= "11111101";
          else
            pOutput <= "11111111";
          end if;
        when "00111010" => --':'
          if pIndex(2) = '0' then
            pOutput <= "10111111";
          else
            pOutput <= "11111111";
          end if;
        when "00111011" => --';'
          if pIndex(2) = '0' then
            pOutput <= "11011111";
          else
            pOutput <= "11111111";
          end if;
        when "00111100" => --'<'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(3) = '0' then
            pOutput <= "11101111";
          else
            pOutput <= "11111111";
          end if;
        when "00111101" => --'='
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(2) = '0' then
            pOutput <= "11111110";
          else
            pOutput <= "11111111";
          end if;
        when "00111110" => --'>'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(9) = '0' then
            pOutput <= "11101111";
          else
            pOutput <= "11111111";
          end if;
        when "00111111" => --'?'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(2) = '0' then
            pOutput <= "01111111";
          else
            pOutput <= "11111111";
          end if;
        when "01000000" => --'@'
          if pIndex(2) = '0' then
            pOutput <= "11111011";
          else
            pOutput <= "11111111";
          end if;
        when "01000001" => --'A'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(6) = '0' then
            pOutput <= "11011111";
          else
            pOutput <= "11111111";
          end if;
        when "01000010" => --'B'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(5) = '0' then
            pOutput <= "01111111";
          else
            pOutput <= "11111111";
          end if;
        when "01000011" => --'C'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(1) = '0' then
            pOutput <= "11101111";
          else
            pOutput <= "11111111";
          end if;
        when "01000100" => --'D'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(1) = '0' then
            pOutput <= "11101111";
          else
            pOutput <= "11111111";
          end if;
        when "01000101" => --'E'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(1) = '0' then
            pOutput <= "11110111";
          else
            pOutput <= "11111111";
          end if;
        when "01000110" => --'F'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(5) = '0' then
            pOutput <= "11011111";
          else
            pOutput <= "11111111";
          end if;
        when "01000111" => --'G'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(5) = '0' then
            pOutput <= "10111111";
          else
            pOutput <= "11111111";
          end if;
        when "01001000" => --'H'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(4) = '0' then
            pOutput <= "10111111";
          else
            pOutput <= "11111111";
          end if;
        when "01001001" => --'I'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(3) = '0' then
            pOutput <= "11110111";
          else
            pOutput <= "11111111";
          end if;
        when "01001010" => --'J'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(4) = '0' then
            pOutput <= "11011111";
          else
            pOutput <= "11111111";
          end if;
        when "01001011" => --'K'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(3) = '0' then
            pOutput <= "11011111";
          else
            pOutput <= "11111111";
          end if;
        when "01001100" => --'L'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(9) = '0' then
            pOutput <= "11011111";
          else
            pOutput <= "11111111";
          end if;
        when "01001101" => --'M'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(4) = '0' then
            pOutput <= "11101111";
          else
            pOutput <= "11111111";
          end if;
        when "01001110" => --'N'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(4) = '0' then
            pOutput <= "01111111";
          else
            pOutput <= "11111111";
          end if;
        when "01001111" => --'O'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(9) = '0' then
            pOutput <= "11110111";
          else
            pOutput <= "11111111";
          end if;
        when "01010000" => --'P'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(2) = '0' then
            pOutput <= "11110111";
          else
            pOutput <= "11111111";
          end if;
        when "01010001" => --'Q'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(6) = '0' then
            pOutput <= "11110111";
          else
            pOutput <= "11111111";
          end if;
        when "01010010" => --'R'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(5) = '0' then
            pOutput <= "11110111";
          else
            pOutput <= "11111111";
          end if;
        when "01010011" => --'S'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(7) = '0' then
            pOutput <= "11110111";
          else
            pOutput <= "11111111";
          end if;
        when "01010100" => --'T'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(5) = '0' then
            pOutput <= "11111011";
          else
            pOutput <= "11111111";
          end if;
        when "01010101" => --'U'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(4) = '0' then
            pOutput <= "11110111";
          else
            pOutput <= "11111111";
          end if;
        when "01010110" => --'V'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(5) = '0' then
            pOutput <= "11101111";
          else
            pOutput <= "11111111";
          end if;
        when "01010111" => --'W'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(7) = '0' then
            pOutput <= "11110111";
          else
            pOutput <= "11111111";
          end if;
        when "01011000" => --'X'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(7) = '0' then
            pOutput <= "11101111";
          else
            pOutput <= "11111111";
          end if;
        when "01011001" => --'Y'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(4) = '0' then
            pOutput <= "11111011";
          else
            pOutput <= "11111111";
          end if;
        when "01011010" => --'Z'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(6) = '0' then
            pOutput <= "11101111";
          else
            pOutput <= "11111111";
          end if;
        when "01011011" => --'['
          if pIndex(3) = '0' then
            pOutput <= "11111011";
          else
            pOutput <= "11111111";
          end if;
        when "01011100" => --'\'
          if pIndex(0) = '0' then
            pOutput <= "11110111";
          else
            pOutput <= "11111111";
          end if;
        when "01011101" => --']'
          if pIndex(2) = '0' then
            pOutput <= "11101111";
          else
            pOutput <= "11111111";
          end if;
        when "01011110" => --'^'
          if pIndex(3) = '0' then
            pOutput <= "11111110";
          else
            pOutput <= "11111111";
          end if;
        when "01011111" => --'_'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(3) = '0' then
            pOutput <= "01111111";
          else
            pOutput <= "11111111";
          end if;
        when "01100000" => --'`'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(2) = '0' then
            pOutput <= "11111011";
          else
            pOutput <= "11111111";
          end if;
        when "01100001" => --'a'
          if pIndex(6) = '0' then
            pOutput <= "11011111";
          else
            pOutput <= "11111111";
          end if;
        when "01100010" => --'b'
          if pIndex(5) = '0' then
            pOutput <= "01111111";
          else
            pOutput <= "11111111";
          end if;
        when "01100011" => --'c'
          if pIndex(1) = '0' then
            pOutput <= "11101111";
          else
            pOutput <= "11111111";
          end if;
        when "01100100" => --'d'
          if pIndex(1) = '0' then
            pOutput <= "11011111";
          else
            pOutput <= "11111111";
          end if;
        when "01100101" => --'e'
          if pIndex(1) = '0' then
            pOutput <= "11110111";
          else
            pOutput <= "11111111";
          end if;
        when "01100110" => --'f'
          if pIndex(5) = '0' then
            pOutput <= "11011111";
          else
            pOutput <= "11111111";
          end if;
        when "01100111" => --'g'
          if pIndex(5) = '0' then
            pOutput <= "10111111";
          else
            pOutput <= "11111111";
          end if;
        when "01101000" => --'h'
          if pIndex(4) = '0' then
            pOutput <= "10111111";
          else
            pOutput <= "11111111";
          end if;
        when "01101001" => --'i'
          if pIndex(3) = '0' then
            pOutput <= "11110111";
          else
            pOutput <= "11111111";
          end if;
        when "01101010" => --'j'
          if pIndex(4) = '0' then
            pOutput <= "11011111";
          else
            pOutput <= "11111111";
          end if;
        when "01101011" => --'k'
          if pIndex(3) = '0' then
            pOutput <= "11011111";
          else
            pOutput <= "11111111";
          end if;
        when "01101100" => --'l'
          if pIndex(9) = '0' then
            pOutput <= "11011111";
          else
            pOutput <= "11111111";
          end if;
        when "01101101" => --'m'
          if pIndex(4) = '0' then
            pOutput <= "11101111";
          else
            pOutput <= "11111111";
          end if;
        when "01101110" => --'n'
          if pIndex(4) = '0' then
            pOutput <= "01111111";
          else
            pOutput <= "11111111";
          end if;
        when "01101111" => --'o'
          if pIndex(9) = '0' then
            pOutput <= "11110111";
          else
            pOutput <= "11111111";
          end if;
        when "01110000" => --'p'
          if pIndex(2) = '0' then
            pOutput <= "11110111";
          else
            pOutput <= "11111111";
          end if;
        when "01110001" => --'q'
          if pIndex(6) = '0' then
            pOutput <= "11110111";
          else
            pOutput <= "11111111";
          end if;
        when "01110010" => --'r'
          if pIndex(5) = '0' then
            pOutput <= "11110111";
          else
            pOutput <= "11111111";
          end if;
        when "01110011" => --'s'
          if pIndex(7) = '0' then
            pOutput <= "11011111";
          else
            pOutput <= "11111111";
          end if;
        when "01110100" => --'t'
          if pIndex(5) = '0' then
            pOutput <= "11111011";
          else
            pOutput <= "11111111";
          end if;
        when "01110101" => --'u'
          if pIndex(4) = '0' then
            pOutput <= "11110111";
          else
            pOutput <= "11111111";
          end if;
        when "01110110" => --'v'
          if pIndex(5) = '0' then
            pOutput <= "11101111";
          else
            pOutput <= "11111111";
          end if;
        when "01110111" => --'w'
          if pIndex(7) = '0' then
            pOutput <= "11110111";
          else
            pOutput <= "11111111";
          end if;
        when "01111000" => --'x'
          if pIndex(7) = '0' then
            pOutput <= "11101111";
          else
            pOutput <= "11111111";
          end if;
        when "01111001" => --'y'
          if pIndex(4) = '0' then
            pOutput <= "11111011";
          else
            pOutput <= "11111111";
          end if;
        when "01111010" => --'z'
          if pIndex(6) = '0' then
            pOutput <= "11101111";
          else
            pOutput <= "11111111";
          end if;
        when "01111011" => --'{'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(3) = '0' then
            pOutput <= "11111011";
          else
            pOutput <= "11111111";
          end if;
        when "01111100" => --'|'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(0) = '0' then
            pOutput <= "11110111";
          else
            pOutput <= "11111111";
          end if;
        when "01111101" => --'}'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(2) = '0' then
            pOutput <= "11101111";
          else
            pOutput <= "11111111";
          end if;
        when "01111110" => --'?'
          if pIndex(8) = '0' then
            pOutput <= "11111011";
          elsif pIndex(3) = '0' then
            pOutput <= "11111110";
          else
            pOutput <= "11111111";
          end if;
        when "01111111" => --DEL
          if pIndex(17) = '0' then
            pOutput <= "11111110";
          else
            pOutput <= "11111111";
          end if;
        when others =>
          pOutput <= "11111111";
      end case;
    end if;
  end process;

end RTL;

