package net.wasamon.mics.processor.rlu;

import java.io.InputStream;
import java.io.OutputStream;

import net.wasamon.mics.Channel;
import net.wasamon.mics.ChannelConnectable;
import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.DataBufferException;
import net.wasamon.mics.MicsCompositeElement;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.memory.RandomAccessMemoryDataPacket;

import org.w3c.dom.Node;

public class ExternalDataInterface extends MicsElement implements DataBuffer, ChannelConnectable{

		private String busID;

		private int addr;
		
		DataBuffer input;
		
		public ExternalDataInterface() {
		}

		/**
		 * エンジン経由ではなく独自に生成する場合のコンストラクタ
		 * @param composite
		 * @param busID
		 * @param addr
		 * @param src
		 */
		ExternalDataInterface(MicsCompositeElement composite, String busID, int addr, DataBuffer src) {
			this.composite = composite;
			this.busID = busID;
			this.addr = addr;
			this.input = src;
		}

		public String[] getConnectedElements() {
			// TODO Auto-generated method stub
			return null;
		}

		public String getDescription(){
			return "TODO";
		}

		public String getImagePath() {
			// TODO Auto-generated method stub
			return null;
		}
		
		private Channel busInstance = null;

		private Channel bus() throws MicsException {
			if (busInstance == null) {
				busInstance = composite.getChannel(busID);
			}
			return busInstance;
		}


		public void initialize(String base, Node node) throws MicsException {
			// TODO Auto-generated method stub
			
		}

		public void reset() {
			// TODO Auto-generated method stub
			
		}

		public void dump(int offset, int len, OutputStream writer)
				throws DataBufferException {
			// TODO Auto-generated method stub
			
		}

		MicsDataPacket buffer;
		
		public void writeback(Channel src, MicsDataPacket data) throws MicsException {
			buffer = data;
		}

		public MicsDataPacket read(MicsDataPacket data) throws DataBufferException{
			try{
				RandomAccessMemoryDataPacket p = (RandomAccessMemoryDataPacket)data;
				switch (p.addr) {
				case 0:
					bus().readRequest(this,	RandomAccessMemoryDataPacket.readPacket(addr, 1, 16));
					return buffer;
				case 2:
					bus().readRequest(this,	RandomAccessMemoryDataPacket.readPacket(addr + 2, 1, 16));
					return buffer;
				case 4:
					bus().readRequest(this,	RandomAccessMemoryDataPacket.readPacket(addr, 1, 16));
					return buffer;
				default:
					throw new DataBufferException("Illegal Address");
				}
			}catch(MicsException e){
				throw new DataBufferException(e);
			}
		}

		public int size() {
			// TODO Auto-generated method stub
			return 0;
		}

		public String toString(int addr, int length) {
			// TODO Auto-generated method stub
			return null;
		}

		public void write(MicsDataPacket data) {
			// TODO Auto-generated method stub
			
		}

		public void write(int offset, InputStream reader)
				throws DataBufferException {
			// TODO Auto-generated method stub
			
		}

		public int getChannelOffset(Channel c) {
			// TODO Auto-generated method stub
			return 0;
		}

}
