package net.wasamon.mics.processor.mips;

import net.wasamon.mics.memory.RandomAccessMemory;

public class VirtualMemory {

    public final static int START_OF_PROTRAM_POINT = 0x00400000;

    private int physicalMemorySize;

    private int entryPoint;

    private int[] mapping;

    public VirtualMemory(ELFHeader elfHeader){
	physicalMemorySize = elfHeader.getPhysicalMemory().size();
	mapping = elfHeader.getMapping();
	entryPoint = elfHeader.getEntryPoint();
    }

    public int getPhysicalAddress(int virtualAddress){
	if(mapping[0] <= virtualAddress && virtualAddress < mapping[mapping.length - 3] + mapping[mapping.length - 1]){
	    return mapping[1] + virtualAddress - mapping[0];
	}

	if(virtualAddress < START_OF_PROTRAM_POINT){
	    return 0xffffffff;
	}

	if(virtualAddress < START_OF_PROTRAM_POINT + physicalMemorySize){
	    return virtualAddress - START_OF_PROTRAM_POINT + 1;
	}
	else{
	    return virtualAddress;
	}

    }
    /*
    public int getPhysicalAddress(int virtualAddress){
	for(int i = 0; i < mapping.length / 3; ++i){
	    if(mapping[i * 3] <= virtualAddress && virtualAddress < mapping[i * 3] + mapping[i * 3 + 2]){
		return mapping[i * 3 + 1] + virtualAddress - mapping[i * 3];
	    }
	}

	//if(mapping[0] <= virtualAddress && virtualAddress < mapping[mapping.length - 3] + mapping[mapping.length - 1]){
	//    return mapping[1] + virtualAddress - mapping[0];
	//}

	if(0 <= virtualAddress && virtualAddress < START_OF_PROTRAM_POINT){
	    return 0xffffffff;
	}

	if((virtualAddress & 0x80000000) == 0x00000000){
	    if(virtualAddress < START_OF_PROTRAM_POINT + physicalMemorySize){
		return virtualAddress - START_OF_PROTRAM_POINT + 1;
	    }
	    else{
		return virtualAddress;
	    }
	}
	else{
	    return 0xffffffff;
	}
    }
    */

    public int getEntryPoint(){
	return entryPoint;
    }
}
