package net.wasamon.mics.processor.mips;

import net.wasamon.mics.memory.RandomAccessMemory;

public class MipsProgramCounter implements MipsRegister{

    private int physicalCounter;

    private int virtualCounter;

    private RandomAccessMemory physicalMemory;

    private VirtualMemory virtualMemory;

    public MipsProgramCounter(RandomAccessMemory physicalMemory, VirtualMemory virtualMemory){
	setMemory(physicalMemory, virtualMemory);
    }

    public MipsProgramCounter(){
	reset();
    }

    public void setMemory(RandomAccessMemory physicalMemory, VirtualMemory virtualMemory){
	this.virtualMemory = virtualMemory;
	this.physicalMemory = physicalMemory;
	reset();
    }

    public int getAsIntValue(){
	return virtualCounter;
    }

    public float getAsFloatValue(){
	return Float.intBitsToFloat(virtualCounter);
    }

    public void reset(){
	if(virtualMemory != null && physicalMemory != null){
	    virtualCounter = virtualMemory.getEntryPoint();
	    physicalCounter = virtualMemory.getPhysicalAddress(virtualCounter);
	}
	else{
	    virtualCounter = 0;
	    physicalCounter = 0;
	}
    }

    public void setAsBits(int bits){
	setVirtualCounter(bits);
    }

    public void setAsBits(float bits){
	setVirtualCounter(Float.floatToIntBits(bits));
    }

    public int getVirtualCounter(){
	return virtualCounter;
    }

    public int getPhysicalCounter(){
	return physicalCounter;
    }

    public void setVirtualCounter(int virtualCounter){
	this.virtualCounter = virtualCounter;
	update();
    }

    public void add(int value){
	virtualCounter += value;
	physicalCounter += value;
    }

    private void update(){
	physicalCounter = virtualMemory.getPhysicalAddress(virtualCounter);
    }

    public String toString(){
	return String.format("%08x", virtualCounter);
    }

}
