package net.wasamon.mics.processor.mips;

public class MipsIntRegister implements MipsRegister {
    int value;

    public MipsIntRegister(){
	value = 0x00000000;
    }

    public int getAsIntValue(){
	return value;
    }

    public float getAsFloatValue(){
	return Float.intBitsToFloat(value);
    }

    public void reset(){
	value = 0x00000000;
    }

    public void setAsBits(int bits){
	value = bits;
    }

    public void setAsBits(float bits){
	value = Float.floatToIntBits(bits);
    }

    public String toString(){
	return String.format("%08x", value);
    }

}
