package net.wasamon.mics.processor.mips;

public class MipsCOP0 {

    public static final int KUSEG_MODE = 0;

    public static final int KSEG0_MODE = 1;

    public static final int KSEG1_MODE = 2;

    public static final int KSEG2_MODE = 3;

    private MipsIntRegister entryHiRegister;

    private MipsIntRegister entryLoRegister;

    private MipsIntRegister indexRegister;

    private MipsIntRegister randomRegister;

    private MipsIntRegister statusRegister;

    private MipsIntRegister contextRegister;

    private MipsIntRegister badVirtualAddressRegister;

    private MipsIntRegister pridRegister;

    private MipsIntRegister causeRegister;

    private MipsIntRegister epcRegister;

    public MipsCOP0() {
	entryHiRegister = new MipsIntRegister();
	entryLoRegister = new MipsIntRegister();
	indexRegister = new MipsIntRegister();
	randomRegister = new MipsIntRegister();
	statusRegister = new MipsIntRegister();
	contextRegister = new MipsIntRegister();
	badVirtualAddressRegister = new MipsIntRegister();
	pridRegister = new MipsIntRegister();
	causeRegister = new MipsIntRegister();
	epcRegister = new MipsIntRegister();
    }

    public int convertToPhysicalAddress(int virtualAddress){
	if((virtualAddress & 0x80000000) == 0x00000000){
	    int vpn = getVPN(virtualAddress);
	    int pid = entry_PID();

	    if(entry_VPN() == vpn && entry_G() == 1 && entry_V() == 1 && entry_D() == 1 && entry_N() == 0){
		return (entry_PFN() << 12) | getOffset(virtualAddress);
	    }
	    else{
		//TLB exception
		return 0xffffffff;
	    }
	}
	else{
	    //address error exception
	    return 0xffffffff;
	}
    }

    public int getVPN(int virtualAddress){
	return (virtualAddress & 0xfffff000) >>> 12;
    }

    private int getOffset(int virtualAddress){
	return (virtualAddress & 0x00000fff);
    }

    private int entry_VPN(){
	return (entryHiRegister.getAsIntValue() & 0xfffff000) >>> 12;
    }

    private int entry_PID(){
	return (entryHiRegister.getAsIntValue() & 0x00000fc0) >>> 6;
    }

    private int entry_PFN(){
	return (entryLoRegister.getAsIntValue() & 0xfffff000) >>> 12;
    }

    private int entry_N(){
	return (entryLoRegister.getAsIntValue() & 0x00000800) >>> 11;
    }

    private int entry_D(){
	return (entryLoRegister.getAsIntValue() & 0x00000400) >>> 10;
    }

    private int entry_V(){
	return (entryLoRegister.getAsIntValue() & 0x00000200) >>> 9;
    }

    private int entry_G(){
	return (entryLoRegister.getAsIntValue() & 0x00000100) >>> 8;
    }

    private int index_P(){
	return (indexRegister.getAsIntValue() & 0x80000000) >>> 31;
    }

    private int index_Index(){
	return (indexRegister.getAsIntValue() & 0x00003f00) >>> 8;
    }

    private int random_Random(){
	return (randomRegister.getAsIntValue() & 0x00003f00) >>> 8;
    }

    private int cause_BD(){
	return (causeRegister.getAsIntValue() & 0x80000000) >>> 31;
    }

    private int cause_CE(){
	return (causeRegister.getAsIntValue() & 0x30000000) >>> 28;
    }

    private int cause_IP(){
	return (causeRegister.getAsIntValue() & 0x0000fc00) >>> 10;
    }

    private int cause_Sw(){
	return (causeRegister.getAsIntValue() & 0x00000300) >>> 8;
    }

    private int cause_ExcCode(){
	return (causeRegister.getAsIntValue() & 0x0000003c) >>> 2;
    }

    private int epc_EPC(){
	return epcRegister.getAsIntValue();
    }

    private int status_CU(){
	return (statusRegister.getAsIntValue() & 0xf0000000) >>> 28;
    }

    private int status_BEV(){
	return (statusRegister.getAsIntValue() & 0x00400000) >>> 22;
    }

    private int status_TS(){
	return (statusRegister.getAsIntValue() & 0x00200000) >>> 21;
    }

    private int status_PE(){
	return (statusRegister.getAsIntValue() & 0x00100000) >>> 20;
    }

    private int status_CM(){
	return (statusRegister.getAsIntValue() & 0x00080000) >>> 19;
    }

    private int status_PZ(){
	return (statusRegister.getAsIntValue() & 0x00040000) >>> 18;
    }

    private int status_SwC(){
	return (statusRegister.getAsIntValue() & 0x00020000) >>> 17;
    }

    private int status_IsC(){
	return (statusRegister.getAsIntValue() & 0x00010000) >>> 16;
    }

    private int status_IntMask(){
	return (statusRegister.getAsIntValue() & 0x0000ff00) >>> 8;
    }

    private int status_KUo(){
	return (statusRegister.getAsIntValue() & 0x00000020) >>> 5;
    }

    private int status_IEo(){
	return (statusRegister.getAsIntValue() & 0x00000010) >>> 4;
    }

    private int status_KUp(){
	return (statusRegister.getAsIntValue() & 0x00000008) >>> 3;
    }

    private int status_IEp(){
	return (statusRegister.getAsIntValue() & 0x00000004) >>> 2;
    }

    private int status_KUc(){
	return (statusRegister.getAsIntValue() & 0x00000002) >>> 1;
    }

    private int status_IEc(){
	return (statusRegister.getAsIntValue() & 0x00000001);
    }

    private int badVirtualAddress_BadVAddr(){
	return badVirtualAddressRegister.getAsIntValue();
    }

    private int context_PTEBase(){
	return (contextRegister.getAsIntValue() & 0xffe00000) >>> 21;
    }

    private int context_BadVPN(){
	return (contextRegister.getAsIntValue() & 0x001ffffc) >>> 2;
    }

    private int prid_Imp(){
	return (pridRegister.getAsIntValue() & 0x0000ff00) >>> 8;
    }

    private int prid_Rev(){
	return (pridRegister.getAsIntValue() & 0x000000ff);
    }
}
