/* 
 *    Copyright 2007 Takefumi MIYOSHI
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

/**
 * プロセッサをシミュレーションする要素のパッケージ
 */
package net.wasamon.mics.processor;

/**
 * レジスタとなるクラスが実装すべきインターフェース
 * @author Takefumi MIYOSHI
 *
 */
public interface Register {
	public int intValue();

	public float floatValue();

	public void reset();

	public void add(int v);

	public Register add(Register r0, Register r1);

	public Register sub(Register r0, Register r1);

	public Register mult(Register r0, Register r1);

	public Register div(Register r0, Register r1);

	public Register mod(Register r0, Register r1);

	public Register shiftL(Register r0, Register r1);

	public Register shiftR(Register r0, Register r1);

	public Register and(Register r0, Register r1);

	public Register or(Register r0, Register r1);

	public void neg(Register r0);

	public boolean eqeq(Register r0);

	public boolean gt(Register r0);

	public void set(byte[] d);

	public void set(Register r);

	public void set(int val);

	public byte[] byteArray(int offset, int len);

	public byte[] byteArray();
}
