/* 
 *    Copyright 2007 Takefumi MIYOSHI
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

/**
 * プロセッサをシミュレーションする要素のパッケージ
 */
package net.wasamon.mics.processor;

import net.wasamon.mjlib.util.DataUtil;

/**
 * 浮動小数点数レジスタクラス
 * @author Takefumi MIYOSHI
 *
 */
public class FloatRegister implements Register {
	float data;

	public FloatRegister() {
		data = 0;
	}

	public float floatValue() {
		return data;
	}

	public int intValue() {
		return (int) data;
	}

	public void reset() {
		data = 0;
	}

	/**
	 * ���W�X�^�̃f�[�^�ⱂ̃��W�X�^�ɃR�s�[����
	 * 
	 * @param r
	 */
	public void set(Register r) {
		// if(r instanceof IntRegister){
		// System.out.println("as float: " + Float.intBitsToFloat(r.intValue()));
		// System.out.println("as int: " + r.intValue());
		// }
		data = r.floatValue();
	}

	/**
	 * int�^�̐����㌃W�X�^�f�[�^�Ƃ��ăZ�b�g����
	 * 
	 * @param v
	 */
	public void set(int v) {
		data = v;
	}

	/**
	 * int�^�̐����㌃W�X�^�f�[�^�Ƃ��ăZ�b�g����
	 * 
	 * @param v
	 */
	public void set(float v) {
		data = v;
	}

	/**
	 * byte�^�̐����㌃W�X�^�f�[�^�Ƃ��ăZ�b�g����D�f�[�^�͕����g�������
	 * 
	 * @param v
	 */
	public void set(byte b) {
		data = (int) b;
	}

	/**
	 * char�^�̐����㌃W�X�^�f�[�^�Ƃ��ăZ�b�g����D�f�[�^�͕����g�������
	 * 
	 * @param v
	 */
	public void set(char v) {
		data = DataUtil.toSiginedInteger(v);
	}

	/**
	 * �^����byte�z��4�o�C�g�̏ꍇ�C
	 * int�ɕϊ����CFloat.intBitsToFloat��g�B�float�̃f�[�^�ɕϊ�����D
	 * �f�[�^��2�o�C�g�̏ꍇ�C
	 * �^�����f�[�^�𕄍��g�����C���̐����Ɠ��������������l�Ƃ��ĕێ�
	 * 
	 * @param d
	 */
	public void set(byte[] d) {
		if (d.length == 2) {
			data = DataUtil.toInteger(d);
		} else {
			data = Float.intBitsToFloat(DataUtil.toInteger(d));
		}
		// System.out.println("set: float value = " + data);
	}

	/**
	 * �^����byte�z���Cint�ɕϊ����CFloat.intBitsToFloat��g�B�float�̃f�[�^�ɕϊ�����
	 * 
	 * @param d
	 */
	public void set(byte[] d, int offset, int len) {
		data = Float.intBitsToFloat(DataUtil.toInteger(d, offset, len));
	}

	public void add(int v) {
		data += v;
	}

	public Register add(Register r0, Register r1) {
		data = r0.floatValue() + r1.floatValue();
		// System.out.println("add: float value:" + data);
		return this;
	}

	public Register mult(Register r0, Register r1) {
		data = r0.floatValue() * r1.floatValue();
		return this;
	}

	public Register div(Register r0, Register r1) {
		data = r0.floatValue() / r1.floatValue();
		return this;
	}

	public Register sub(Register r0, Register r1) {
		data = r0.floatValue() - r1.floatValue();
		return this;
	}

	public void neg(Register r0) {
		data = -r0.floatValue();
	}

	public Register mod(Register r0, Register r1) {
		data = r0.floatValue() % r1.floatValue();
		return this;
	}

	/**
	 * @todo ��O�łӊ����悤�ɂ��悤����
	 */
	public Register shiftL(Register r0, Register r1) {
		return null;
	}

	/**
	 * @todo ��O�łӊ����悤�ɂ��悤����
	 */
	public Register shiftR(Register r0, Register r1) {
		return null;
	}

	/**
	 * @todo ��O�łӊ����悤�ɂ��悤����
	 */
	public Register and(Register r0, Register r1) {
		return null;
	}

	/**
	 * @todo ��O�łӊ����悤�ɂ��悤����
	 */
	public Register or(Register r0, Register r1) {
		return null;
	}

	public boolean eqeq(Register r0) {
		return this.floatValue() == r0.floatValue();
	}

	public boolean gt(Register r0) {
		return this.floatValue() > r0.floatValue();
	}

	/**
	 * ����float�̒l��CFloat.floatToIntBits��g�B�int�^�ɕϊ���byte�z��ɂ���
	 * 
	 * @param d
	 */
	public byte[] byteArray() {
		return DataUtil.toByteArray(Float.floatToIntBits(data));
	}

	public byte[] byteArray(int offset, int len) {
		return DataUtil.subArray(byteArray(), offset, len);
	}

	public String toString() {
		return DataUtil.toBigEndianValueString(byteArray()).substring(2);
	}
}
