/* 
 *    Copyright 2007 Takefumi MIYOSHI
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

/**
 * さまざまなペリフェラルデバイスのシミュレーション要素のパッケージ
 */
package net.wasamon.mics.peripheral;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.JFrame;
import javax.swing.JPanel;

import net.wasamon.mics.Channel;
import net.wasamon.mics.ChannelConnectable;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.MicsViewable;
import net.wasamon.mics.memory.InterruptDataPacket;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;

import org.w3c.dom.Node;

/**
 * 単純なキーボードのシミュレーション要素
 * @author Takefumi MIYOSHi
 *
 */
public class SoftKeyboard extends MicsElement implements Channel, MicsViewable,
		KeyListener {

	private String[] dest;

	private JFrame frame;

	static final int SIZE = 100;

	private SoftKeyboardCanvas keyboard;

	public SoftKeyboard() {
		frame = new JFrame("SoftKeyboard");
		frame.setSize(SIZE, SIZE);
		frame.addKeyListener(this);
		keyboard = new SoftKeyboardCanvas();
		keyboard.addKeyListener(this);
		frame.getContentPane().add(keyboard);
		frame.setVisible(false);
	}

	class SoftKeyboardCanvas extends JPanel {
		Image image;

		public SoftKeyboardCanvas() {
			super();
			setSize(SIZE, SIZE);
			image = getToolkit().getImage(
					getClass().getClassLoader().getResource("pp_keyboard1_8.gif"));
		}

		public void paint(Graphics g) {
			g.drawImage(image, 0, 0, SIZE, SIZE, this);
		}
	}

	public void initialize(String base, Node n) throws MicsException {
		try {
			{
				Node init_var_node = n;
				Node[] init_var__channel_obj = XMLParser.getNamedNodeArray(
						init_var_node, "channel");
				dest = new String[init_var__channel_obj.length];
				for (int i = 0; i < init_var__channel_obj.length; i++) {
					Node init_var__channel_node = init_var__channel_obj[i];
					String init_var__channel_id;
					init_var__channel_id = XMLParser.getAttribute(init_var__channel_node,
							"id").getNodeValue();
					dest[i] = init_var__channel_id;
				}
			}
		} catch (NumberFormatException e) {
			throw new MicsException(
					"configuration syntax error: net.wasamon.mics.processor.SimpleProcessor");
		} catch (XMLParserException e) {
			throw new MicsException(
					"configuration syntax error: net.wasamon.mics.processor.SimpleProcessor");
		}
	}

	public void readRequest(ChannelConnectable src, MicsDataPacket data)
			throws MicsException {
		// TODO Auto-generated method stub

	}

	public void writeRequest(ChannelConnectable src, MicsDataPacket data)
			throws MicsException {
		// TODO Auto-generated method stub

	}

	public String[] getConnectedElements() {
		return dest;
	}

	public String getImagePath() {
		return "pp_keyboard1_8.gif";
	}

	public void show() {
		frame.setVisible(true);
	}

	public void keyPressed(KeyEvent e) {
	}

	public void keyReleased(KeyEvent e) {
		// TODO Auto-generated method stub
	}

	public void keyTyped(KeyEvent e) {
		char c = e.getKeyChar();
		for (int i = 0; i < dest.length; i++) {
			try {
				ChannelConnectable cc = composite.getChannelConnectable(dest[i]);
				cc.writeback(this, new InterruptDataPacket(0, DataUtil.toByteArray(c)));
			} catch (MicsException ex) {

			}
		}
	}
	
	public void reset(){
		
	}


	public String getDescription(){
		return "TODO";
	}
}
