/* 
 *    Copyright 2007 Takefumi MIYOSHI
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

/**
 * さまざまなペリフェラルデバイスのシミュレーション要素のパッケージ
 */
package net.wasamon.mics.peripheral;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.DataBufferException;
import net.wasamon.mics.ExecInfo;
import net.wasamon.mics.ExecutableElement;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.memory.RandomAccessMemory;

import org.w3c.dom.Node;

/**
 * 単純なオーディオデバイスのシミュレーション要素
 * TODO 未実装
 * @author Takefumi MIYOSHI
 * 
 */
public class SimpleAudio extends MicsElement implements DataBuffer,
		ExecutableElement {

	boolean fSoundEnable;
	RandomAccessMemory ram;

	public SimpleAudio() {

	}


	public String getDescription(){
		return "TODO";
	}

	public String getImagePath() {
		return "icons/pk_speaker1_1.png";
	}

	public void dump(int offset, int len, OutputStream writer)
			throws DataBufferException {
		ram.dump(offset, len, writer);
	}

	public MicsDataPacket read(MicsDataPacket data) {
		return ram.read(data);
	}

	public int size() {
		return ram.size();
	}

	public String toString(int addr, int length) {
		return ram.toString(addr, length);
	}

	public void write(MicsDataPacket data) {
		ram.write(data);
	}

	public void write(int offset, InputStream reader) throws DataBufferException {
		ram.write(offset, reader);
	}

	public ExecInfo exec_first() throws MicsException {
		return null;
	}

	public ExecInfo exec_second() throws MicsException {
		return null;
	}

	public void start() {
		ByteArrayInputStream bin = new ByteArrayInputStream(ram.read(0, ram.size()));
		AudioFormat audioFormat = new AudioFormat(44.1f, 16, 2, true, true);
		DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
		// �w�肳�ꂽ�f�[�^���C�����Ɉ�v���郉�C����擾���܂�
		try {
			SourceDataLine line = (SourceDataLine) AudioSystem.getLine(info);
			// �w�肳�ꂽ�I�[�f�B�I�`���Ń��C����J���܂�
			line.open(audioFormat);
			// ���C���ł̃f�[�^��o�͂�\�ɂ��܂�
			line.start();
			while (fSoundEnable) {
				int len = 0;
				byte buf[] = new byte[1024];
				while (len != -1) {
					len = bin.read(buf, 0, 1024);
					if (len >= 0) {
						// �I�[�f�B�I�f�[�^��~�L�T�[�ɏ������݂܂�
						int nBytesWritten = line.write(buf, 0, len);
					}
				}
			}
			// ���C������L���[�ɓ�BĂ���f�[�^��r�o���܂�
			line.drain();
			// ���C������܂�
			line.close();
		} catch (LineUnavailableException e) {

		}
	}

	public void reset() {
		fSoundEnable = false;
	}

	public String[] getConnectedElements() {
		// TODO Auto-generated method stub
		return null;
	}

	public void initialize(String base, Node node) throws MicsException {
		// TODO Auto-generated method stub

	}

}
