package net.wasamon.mics.peripheral;

import net.wasamon.mics.Channel;
import net.wasamon.mics.ChannelConnectable;
import net.wasamon.mics.ExecInfo;
import net.wasamon.mics.ExecutableElement;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.data.ByteVector;
import net.wasamon.mjlib.util.DataUtil;

import org.w3c.dom.Node;

public class Counter8 extends MicsElement implements ExecutableElement, ChannelConnectable{
	
	Channel dest;
	String destName;
	int count = 0;

	@Override
	public String[] getConnectedElements() {
		return new String[]{destName};
	}

	public String getDescription(){
		return "TODO";
	}

	@Override
	public String getImagePath() {
		return null;
	}

	@Override
	public void initialize(String base, Node node) throws MicsException {
		destName = getAttributeAsString(node, "dest");
		reset();
	}
	
	private Channel dest() throws MicsException{
		if(dest == null){
			dest = composite.getChannel(destName);
		}
		return dest;
	}

	public ExecInfo exec_first() throws MicsException {
		MicsDataPacket data = new ByteVector(DataUtil.toByteArray(count), 8);
		count++;
		dest().writeRequest(this, data);
		return new ExecInfo(true, 0);
	}

	public ExecInfo exec_second() throws MicsException {
		return new ExecInfo(true, 0);
	}

	public void reset() {
		count = 0;
	}

	public int getChannelOffset(Channel c) {
		// TODO Auto-generated method stub
		return 0;
	}

	public void writeback(Channel src, MicsDataPacket data) throws MicsException {
		// TODO Auto-generated method stub
		
	}

}
