/* 
 *    Copyright 2007 Takefumi MIYOSHI
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

/**
 * さまざまなペリフェラルデバイスのシミュレーション要素のパッケージ
 */
package net.wasamon.mics.peripheral;

import java.awt.Font;
import java.io.InputStream;
import java.io.OutputStream;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.DataBufferException;
import net.wasamon.mics.ExecInfo;
import net.wasamon.mics.ExecutableElement;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.MicsViewable;
import net.wasamon.mics.memory.RandomAccessMemory;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;

import org.w3c.dom.Node;

/**
 * 文字列を表示可能なキャラクタディスプレイのシミュレーション要素
 * @author Takefumi MIYOSHI
 *
 */
public class CharacterDisplay extends MicsElement implements DataBuffer,
		ExecutableElement, MicsViewable, Runnable {

	private RandomAccessMemory memory;

	private JFrame frame;

	private JTextArea textarea;

	public String getDescription(){
		return "TODO";
	}

	public String getImagePath() {
		return "pp_ekisyodisplay1_1.gif";
	}

	public CharacterDisplay() {
		frame = new JFrame();
		textarea = new JTextArea();
		textarea.setFont(new Font("MonoSpaced", Font.PLAIN, 12));
		textarea.setEditable(false);
		frame.setSize(12 * cols, 4 * 12);
		frame.getContentPane().add(
				new JScrollPane(textarea, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
						JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED));
		frame.setVisible(false);
	}

	private int cols;

	// private int rows;

	private void initialize(int rows, int cols) {
		// this.rows = rows;
		this.cols = cols;
		memory = new RandomAccessMemory(rows * cols);
		reset();
		textarea.setColumns(cols);
		textarea.setRows(rows);
		frame.setTitle(id());
		frame.pack();
		t = new Thread(this);
		t.start();
	}

	Thread t;
	private int refresh_rate = 300;

	/*
	 * generated automatically by MakeInitialize from
	 * inits/character_display16.init
	 */
	public void initialize(String base, Node n) throws MicsException {
		try {
			{
				Node init_var_node = n;
				int init_var_rows;
				init_var_rows = Integer.parseInt(XMLParser.getAttribute(init_var_node,
						"rows").getNodeValue());
				int init_var_cols;
				init_var_cols = Integer.parseInt(XMLParser.getAttribute(init_var_node,
						"cols").getNodeValue());

				initialize(init_var_rows, init_var_cols);
				if (XMLParser.isAttribute(init_var_node, "refresh")) {
					refresh_rate = DataUtil.parseInt(XMLParser.getAttribute(
							init_var_node, "refresh").getNodeValue());
				}

			}
		} catch (NumberFormatException e) {
			throw new MicsException(
					"configuration syntax error: net.wasamon.mics.peripheral.CharacterDisplay");
		} catch (XMLParserException e) {
			throw new MicsException(
					"configuration syntax error: net.wasamon.mics.peripheral.CharacterDisplay");
		}
	}

	public MicsDataPacket read(MicsDataPacket data) {
		return memory.read(data);
	}

	public int size() {
		return memory.size();
	}

	public String toString(int addr, int length) {
		return memory.toString(addr, length);
	}

	public void write(MicsDataPacket data) {
		memory.write(data);
	}

	public void write(int addr, InputStream reader) throws DataBufferException {
		memory.write(addr, reader);
	}

	public void dump(int offset, int len, OutputStream writer)
			throws DataBufferException {
		memory.dump(offset, len, writer);
	}

	public ExecInfo exec_first() throws MicsException {
		// TODO Auto-generated method stub
		return null;
	}

	private void print_memory_data() {
		StringBuffer buf = new StringBuffer();
		byte[] src = memory.read(0, memory.size());
		for (int i = 0; i < src.length; i++) {
			buf.append((char) src[i]);
			if (i % 16 == 15) {
				buf.append("\n");
			}
		}
		textarea.setText(buf.toString());
	}

	public ExecInfo exec_second() throws MicsException {
		// print_memory_data();
		return null;
	}

	/**
	 * ���ׂĂ�X�y�[�X�Ŗ��߂�
	 */
	public void reset() {
		byte[] d = new byte[memory.size()];
		for (int i = 0; i < d.length; i++) {
			d[i] = 0x20;
		}
		memory.write(0, memory.size(), d);
		// char[] mesg = "Hello World".toCharArray();
		// for (int i = 0; i < mesg.length; i++) {
		// memory.write(i, (byte)mesg[i]);
		// }
		// print_memory_data();
	}

	public void show() {
		frame.setVisible(true);
		print_memory_data();
	}

	public String[] getConnectedElements() {
		return null;
	}

	public void run() {
		while (true) {
			try {
				Thread.sleep(refresh_rate);
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			print_memory_data();
		}
	}
}
