/* 
 *    Copyright 2007 Takefumi MIYOSHI
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

/**
 * さまざまなペリフェラルデバイスのシミュレーション要素のパッケージ
 */
package net.wasamon.mics.peripheral;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.io.InputStream;
import java.io.OutputStream;

import javax.swing.JFrame;
import javax.swing.JPanel;

import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.DataBufferException;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.MicsViewable;
import net.wasamon.mics.memory.RandomAccessMemory;
import net.wasamon.mjlib.util.DataUtil;
import net.wasamon.mjlib.xml.XMLParser;
import net.wasamon.mjlib.xml.XMLParserException;

import org.w3c.dom.Node;

/**
 * 単純なビットマップディスプレイのシミュレーション要素
 * @author Takefumi MIYOSHI
 *
 */
public class BitMapDumpDisplay extends MicsElement implements DataBuffer,
		MicsViewable, Runnable {

	private RandomAccessMemory ram;
	private BitMapDumpDisplayCanvas canvas;
	private JFrame frame;
	
	public String getDescription(){
		return "TODO";
	}

	public String[] getConnectedElements() {
		return null;
	}

	public String getImagePath() {
		return "pp_ekisyodisplay1_1.gif";
	}

	class BitMapDumpDisplayCanvas extends JPanel {
		Image buf;
		int width;
		int height;

		public BitMapDumpDisplayCanvas(int width, int height) {
			super();
			this.width = width;
			this.height = height;
			setPreferredSize(new Dimension(width, height));
		}

		public void paintComponent(Graphics g) {
			super.paintComponent(g);
			if (buf == null) {
				buf = createImage(this.width, this.height);
			}
			Graphics gbuf = buf.getGraphics();
			int blue, green, red;
			for (int i = 0; i < height; i++) {
				int line = (height - i - 1) * width;
				for (int j = 0; j < width; j++) {
					int xpos = (line + j) * 3;
					blue = DataUtil.toInteger(ram.read(xpos));
					green = DataUtil.toInteger(ram.read(xpos + 1));
					red = DataUtil.toInteger(ram.read(xpos + 2));
					gbuf.setColor(new Color(red, green, blue));
					gbuf.fillRect(j, i, 1, 1);
				}
			}
			g.drawImage(buf, 0, 0, this);
		}

		public void update(Graphics g) {
			paint(g);
		}

	}

	public void initialize(int width, int height) {
		frame = new JFrame();
		frame.setVisible(false);
		frame.setTitle(id());
		ram = new RandomAccessMemory(width * height * 3);
		canvas = new BitMapDumpDisplayCanvas(width, height);
		frame.getContentPane().add(canvas);
		frame.pack();
		t = new Thread(this);
		t.start();
	}

	Thread t;

	private int refresh_rate = 500;

	/* generated automatically by MakeInitialize from inits/bitmap_display.init */
	public void initialize(String base, Node n) throws MicsException {
		try {
			{
				Node init_var_node = n;
				int init_var_width;
				init_var_width = DataUtil.parseInt(XMLParser.getAttribute(
						init_var_node, "width").getNodeValue());
				int init_var_height;
				init_var_height = DataUtil.parseInt(XMLParser.getAttribute(
						init_var_node, "height").getNodeValue());

				initialize(init_var_width, init_var_height);
				if (XMLParser.isAttribute(init_var_node, "refresh")) {
					refresh_rate = DataUtil.parseInt(XMLParser.getAttribute(
							init_var_node, "refresh").getNodeValue());
				}

			}
		} catch (NumberFormatException e) {
			throw new MicsException(
					"configuration syntax error: net.wasamon.mics.peripheral.CharacterDisplay");
		} catch (XMLParserException e) {
			throw new MicsException(
					"configuration syntax error: net.wasamon.mics.peripheral.CharacterDisplay");
		}
	}

	public MicsDataPacket read(MicsDataPacket data) {
		return ram.read(data);
	}

	public int size() {
		return ram.size();
	}

	public String toString(int addr, int length) {
		return ram.toString(addr, length);
	}

	public void write(MicsDataPacket data) {
		ram.write(data);
		// System.out.println(ram.size());
		// canvas.repaint();
	}

	public void write(int offset, InputStream reader) throws DataBufferException {
		ram.write(offset, reader);

	}

	public void dump(int offset, int len, OutputStream writer)
			throws DataBufferException {
		ram.dump(offset, len, writer);
	}

	public void show() {
		canvas.repaint();
		frame.setVisible(true);
	}

	public void run() {
		while (true) {
			try {
				Thread.sleep(refresh_rate);
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			canvas.repaint();
		}
	}
	
	public void reset(){
		
	}

}
