/* 
 *    Copyright 2007 Takefumi MIYOSHI
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

/**
 * DataBufferやMicsDataPacketなどデータに関するクラスのパッケージ
 */
package net.wasamon.mics.memory;

import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mjlib.util.DataUtil;

/**
 * ランダムアクセス可能な、アドレス、長さ、データから構成されるデータによるMicsDataPacketの実装
 * @author Takefumi MIYOSHI
 *
 */
public class RandomAccessMemoryDataPacket implements MicsDataPacket {

	public int addr;
	public byte[] data;
	public int width;
	public int length;

	public RandomAccessMemoryDataPacket(int addr, int length, int width,
			byte[] data) {
		this.addr = addr;
		this.length = length;
		this.width = width;
		this.data = data;
	}

	public static MicsDataPacket readPacket(int addr, int length, int width) {
		return new RandomAccessMemoryDataPacket(addr, length, width, null);
	}

	public static MicsDataPacket writePacket(int addr, int length, int width,
			byte[] data) {
		return new RandomAccessMemoryDataPacket(addr, length, width, data);
	}

	public String toString() {
		String s = "";
		s += getClass().getName() + ":";
		s += " addr = "
				+ DataUtil.toBigEndianValueString(DataUtil.toByteArray(addr)) + ",";
		s += " width = " + width + ",";
		s += " length = " + length + ",";
		s += "data = [";
		if (data != null) {
			String tmp = "";
			for (int i = 0; i < data.length; i++) {
				tmp += "," + ((int) (data[i]));
			}
			if (tmp.length() > 1) {
				s += tmp.substring(1);
			}
		}
		s += "]";
		return s;
	}

}
