/* 
 *    Copyright 2007 Takefumi MIYOSHI
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

/**
 * DataBufferやMicsDataPacketなどデータに関するクラスのパッケージ
 */
package net.wasamon.mics.memory;

import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mjlib.util.DataUtil;

/**
 * 割り込み処理をたいしょうとしたデータパケットの実装
 * @author Takefumi MIYOSHI
 *
 */
public class InterruptDataPacket implements MicsDataPacket {

	public int addr;
	public byte[] data;

	public InterruptDataPacket(int addr, byte[] data) {
		this.addr = addr;
		this.data = data;
	}

	public String toString() {
		String s = "";
		s += addr + ":";
		s += DataUtil.toBigEndianValueString(data);
		return s;
	}

}
