package net.wasamon.mics.freehdl.ui.wave;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.util.*;

import net.wasamon.mics.freehdl.*;
import net.wasamon.mics.freehdl.data.*;

public abstract class SignalListCanvas extends JPanel implements MouseListener{

  int size;
  int width;

  protected ArrayList<Signal> data;

  public SignalListCanvas(){
    super();
    addMouseListener(this);
    setPreferredSize(new Dimension(100, 1000));
    size = getFontMetrics(getFont()).getHeight();
  }

  public void update(ArrayList<Signal> data){
    this.data = data;
    repaint();
  }

  private void check(Graphics g, int x, int y){
    boolean xFlag, yFlag;
    int w = getPreferredSize().width;
    int h = getPreferredSize().height;
    xFlag = (x < w);
    yFlag = (y < h);
    if(xFlag && yFlag) return;
    setPreferredSize(new Dimension(xFlag ? w : x, yFlag ? h : y));
    revalidate();
  }

  public abstract String getLabel(Signal s);

  private void drawGrid(Graphics g){
    int w = getPreferredSize().width;
    int h = getPreferredSize().height;
    int y = FreeHDLWaveFrame.margin;
    while(y < h){
      g.drawLine(0, y, w, y);
      y += size + FreeHDLWaveFrame.margin;
    }
  }

  public void paintComponent(Graphics g){
    super.paintComponent(g);
    if(data == null) return;
    int y0 = size + FreeHDLWaveFrame.margin;
    for(int i = 0; i < data.size(); i++){
      String str = getLabel(data.get(i));
      g.drawString(str, 0, y0);
      y0 += size + FreeHDLWaveFrame.margin;
      check(g, getFontMetrics(getFont()).stringWidth(str), y0);
    }
    drawGrid(g);
  }

  /**
   * コンポーネント上でマウスボタンをクリック (押してから離す) 
   * したときに呼び出されます。
   */
  public void mouseClicked(MouseEvent e){
  }
  
  /**
   * コンポーネントにマウスが入ると呼び出されます。
   */
  public void mouseEntered(MouseEvent e){
  }
  
  /**
   * コンポーネントからマウスが出ると呼び出されます。
   */
  public void mouseExited(MouseEvent e){
  }
  
  /**
   * コンポーネント上でマウスボタンが押されると呼び出されます。
   */
  public void mousePressed(MouseEvent e){
  }
  
  public void mouseReleased(MouseEvent e){
  }

}
