package net.wasamon.mics.freehdl.ui.wave;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.util.*;

import net.wasamon.mics.freehdl.*;
import net.wasamon.mics.freehdl.data.*;

public class FreeHDLWaveFrame implements ChangeListener{

  FreeHDLProcess process;
  private JFrame frame;
  private JSplitPane pane;
  SignalList list;
  WavePanel wave;
  ArrayList<Signal> data;
  public static final int margin = 10;

  JViewport signalView;

  public FreeHDLWaveFrame(FreeHDLProcess process){
    this.frame = new JFrame("Wave Form");
    this.frame.setSize(640, 480);
    this.frame.setVisible(false);
    this.process = process;
    this.pane = new JSplitPane();
    this.list = new SignalList();
    this.wave = new WavePanel(this);
    this.pane.setDividerLocation(0.3);
    JScrollPane scr = new JScrollPane(list, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
    signalView = scr.getViewport();
    signalView.addChangeListener(this);
    this.pane.setLeftComponent(scr);
    this.pane.setRightComponent(this.wave.pane);
    this.frame.getContentPane().add(this.pane);
  }

  public void reset(){
    data = process.getTopModule().getSignalsAll();
    list.update(data);
    wave.update(data);
    frame.setVisible(true);
  }

  public void update(){
    wave.update(data);
    this.frame.setVisible(true);
  }

  public void setVisible(boolean f){
    this.frame.setVisible(f);
    if(f){
      update();
    }
  }

  public JFrame getComponent(){
    return frame;
  }

  class SignalList extends SignalListCanvas{
    
    public String getLabel(Signal s){
      return s.getLongName();
    }
    
  }

  boolean flag = false;
  public void stateChanged(ChangeEvent e){
    JViewport port = (JViewport)(e.getSource());
    if(flag) return;
    flag = true;
    Point p = port.getViewPosition();
    JViewport port0, port1;
    port0 = port1 = null;
    if(port == signalView){
      port0 = wave.waveView;
      port1 = wave.listView;
    }else if(port == wave.listView){
      port0 = signalView;
      port1 = wave.waveView;
    }else if(port == wave.waveView){
      port0 = signalView;
      port1 = wave.listView;
    }else{
      return;
    }
    port0.setViewPosition(new Point(port0.getViewPosition().x, p.y));
    port1.setViewPosition(new Point(port1.getViewPosition().x, p.y));
    flag = false;
  }


}
