package net.wasamon.mics.freehdl.ui;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;

import net.wasamon.mics.freehdl.*;
import net.wasamon.mics.freehdl.data.*;

public class FreeHDLModuleFrame{

  private JFrame frame;
  private JTree tree;

  private FreeHDLProcess process;

  public FreeHDLModuleFrame(FreeHDLProcess process){
    this.process = process;
    this.frame = new JFrame("Module/Signals");
    this.frame.setSize(240, 320);
    this.tree  = new JTree();
    frame.setVisible(false);
    this.frame.getContentPane().add(this.tree);
  }

  public void setVisible(boolean f){
    frame.setVisible(f);
  }

  public void setModule(){
    Module top = process.getTopModule();
    DefaultMutableTreeNode node = new DefaultMutableTreeNode(top.getName());
    setModule(node, top);
    tree.setModel(new DefaultTreeModel(node));
  }

  // TODO
  public void setModule(DefaultMutableTreeNode node, Module module){
    for(Signal s: module.getSignals()){
      node.add(new DefaultMutableTreeNode(s.getName()));
    }
    for(Module m: module.getModules()){
      DefaultMutableTreeNode n = new DefaultMutableTreeNode(m.getName());
      setModule(n, m);
      node.add(n);
    }
  }
}
