package net.wasamon.mics.freehdl.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

import net.wasamon.mics.freehdl.FreeHDLProcess;
import net.wasamon.mics.freehdl.ui.wave.FreeHDLWaveFrame;


public class FreeHDLGUI{

  public static String version = "v0.1";
  private FreeHDLProcess process;
  
  private FreeHDLController controller;
  FreeHDLModuleFrame moduleFrame;
  FreeHDLWaveFrame waveFrame;

  private static FreeHDLGUI instance = new FreeHDLGUI();
  public static FreeHDLGUI getInstance(){
    return instance;
  }
  private FreeHDLGUI(){
    init();
  }

  private JFrame frame;
  private JMenuBar menubar;

  private void makeGUI(){
    frame = new JFrame("FreeHDL GUI " + version);
    frame.setSize(640, 480);
    frame.setVisible(false);
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    frame.setJMenuBar(menubar = makeMenuBar());
    moduleFrame = new FreeHDLModuleFrame(process);
    waveFrame = new FreeHDLWaveFrame(process);
    moduleFrame.setVisible(false);
  }

  private void openFile(){
    JFileChooser chooser = new JFileChooser();
    int returnVal = chooser.showOpenDialog(frame);
    try{
      if(returnVal == JFileChooser.APPROVE_OPTION){
	File f = chooser.getSelectedFile();
	if(f.exists() == false){
	  throw new Exception(f.getAbsolutePath() + " is not found.");
	}
	process.reset(f.getAbsolutePath());
	controller.setEnabled(true);
      }else{
	throw new Exception("Illegal intenal value");
      }
    }catch(Exception e){
	JOptionPane.showMessageDialog(null,
				      e.getStackTrace(),
				      "alert",
				      JOptionPane.ERROR_MESSAGE); 
    }
     
  }

  private void exit(){
    System.exit(0);
  }

  private JMenuItem makeMenuItem(String label, ActionListener l){
    JMenuItem item = new JMenuItem(label);
    item.addActionListener(l);
    return item;
  }

  private JMenuBar makeMenuBar(){
    JMenuBar bar = new JMenuBar();
    {
      JMenu m = new JMenu("File");
      m.add(makeMenuItem("Open",
			 new ActionListener(){
			   public void actionPerformed(ActionEvent e){
			     openFile();
			   }
			 }));
      m.add(makeMenuItem("Exit",
			 new ActionListener(){
			   public void actionPerformed(ActionEvent e){
			     exit();
			   }
			 }));
      bar.add(m);
    }
    bar.add(controller.getMenu(frame));
    return bar;
  }

  public void setVisible(boolean f){
    frame.setVisible(f);
  }

  public void init(){
    process = new FreeHDLProcess();
    controller = new FreeHDLController(this, process);
//     SwingUtilities.invokeLater(new Runnable(){
// 	public void run(){
// 	  makeGUI();
// 	}
//       });
    makeGUI();
  }

  public static void main(String[] args){
    FreeHDLGUI.getInstance().setVisible(true);
  }

}
