package net.wasamon.mics.freehdl.ui;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

import net.wasamon.mics.freehdl.*;
import net.wasamon.mics.freehdl.data.*;

public class FreeHDLController implements ActionListener{

  private FreeHDLProcess process;

  private JFrame parent;
  private JMenu menu;
  private JMenuItem runItem;
  private JMenuItem stopItem;
  private JMenuItem stepItem;
  private JMenuItem step1000Item;
  private FreeHDLGUI gui;

  public FreeHDLController(FreeHDLGUI gui, FreeHDLProcess process){
    this.gui = gui;
    this.process = process;
  }

  public JMenu getMenu(JFrame parent){
    this.parent = parent;
    if(menu == null){
      initMenu();
    }
    return menu;
  }

  private JMenuItem makeMenuItem(JMenu menu, String label, ActionListener l){
    JMenuItem item = new JMenuItem(label);
    item.addActionListener(l);
    menu.add(item);
    return item;
  }

  private void initMenu(){
    menu = new JMenu("FreeHDL");
    runItem = makeMenuItem(menu, "run", this);
    runItem.setEnabled(false);
    stopItem = makeMenuItem(menu, "stop", this);
    stopItem.setEnabled(false);
    stepItem = makeMenuItem(menu, "step", this);
    stepItem.setEnabled(false);
    step1000Item = makeMenuItem(menu, "step1000", this);
    step1000Item.setEnabled(false);
  }

  public void setEnabled(boolean f){
    if(f){
      runItem.setEnabled(true);
      stopItem.setEnabled(false);
      stepItem.setEnabled(false);
      step1000Item.setEnabled(false);
    }else{
      runItem.setEnabled(false);
      stopItem.setEnabled(false);
      stepItem.setEnabled(false);
      step1000Item.setEnabled(false);
    }
  }

  public void actionPerformed(ActionEvent event){
    Object obj = event.getSource();
    if(!(obj instanceof JMenuItem)) return;
    try{
      if(obj == null){
      }else if(obj == runItem){
	runItem.setEnabled(false);
	stopItem.setEnabled(true);
	stepItem.setEnabled(true);
	step1000Item.setEnabled(true);
	process.run();
	gui.moduleFrame.setModule();
	gui.moduleFrame.setVisible(true);
	gui.waveFrame.reset();
      }else if(obj == stopItem){
	runItem.setEnabled(true);
	stopItem.setEnabled(false);
	stepItem.setEnabled(false);
	step1000Item.setEnabled(false);
	process.stop();
      }else if(obj == stepItem){
	process.step();
	gui.waveFrame.update();
      }else if(obj == step1000Item){
	for(int i = 0; i < 1000; i++){
	  process.step();
	}
	gui.waveFrame.update();
      }
    }catch(IOException e){
      JDialog d = new JDialog(parent, "connection error");
      d.setVisible(true);
    }
  }

}
