package net.wasamon.mics.freehdl.data;

import java.util.*;
import java.io.*;

public class Module extends FreeHDLObject{

  private Module parent;
  private Hashtable<String, Signal> ports;
  private Hashtable<String, Module> modules;

  public Module(Module parent, String longname, String name){
    super(longname, name);
    this.parent = parent;
    ports = new Hashtable<String, Signal>();
    modules = new Hashtable<String, Module>();
  }

  public void add(Signal signal){
    ports.put(signal.getName(), signal);
    signal.setModule(this);
  }

  public Module newModule(String longname, String name){
    Module m = new Module(this, longname, name);
    modules.put(name, m);
    return m;
  }

  public boolean containsModule(String n){
    return modules.containsKey(n);
  }

  public Module getModule(String n){
    return modules.get(n);
  }

  public ArrayList<Signal> getSignalsAll(){
    ArrayList<Signal> list = new ArrayList<Signal>();
    getSignalsAll(list);
    return list;
  }

  public void getSignalsAll(ArrayList<Signal> list){
    for(Signal s: ports.values()){
      list.add(s);
    }
    for(Module m: modules.values()){
      m.getSignalsAll(list);
    }
  }

  public Signal getSignal(String name){
    int index = name.indexOf(':');
    if(index < 0){
      return ports.get(name);
    }else{
      String m = name.substring(0, index);
      String s = name.substring(index+1, name.length());
      return modules.get(m).getSignal(s);
    }
  }
  
  public Collection<Module> getModules(){
    return modules.values();
  }

  public Collection<Signal> getSignals(){
    return ports.values();
  }

  public void dump(PrintStream out){
    dump(out, "");
  }
  public void dump(PrintStream out, String offset){
    out.println(offset + name);
    for(Signal s: ports.values()){
      out.println(offset + "-" + s.getName());
    }
    for(Module m: modules.values()){
      m.dump(out, offset +" ");
    }
  }
  public String dump(){
  	return dump("");
  }
  public String dump(String offset){
  	String str = offset + name + "\n";
  	for(Signal s: ports.values()){
  		str += offset + "-" + s.getName() + "\n";
    }
    for(Module m: modules.values()){
    	str += m.dump(offset +" ");
    }
    return str;
  }
}
