package net.wasamon.mics.freehdl;

import org.w3c.dom.Node;

import net.wasamon.mics.Channel;
import net.wasamon.mics.ChannelConnectable;
import net.wasamon.mics.ExecInfo;
import net.wasamon.mics.ExecutableElement;
import net.wasamon.mics.MicsDataPacket;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsException;
import net.wasamon.mics.data.ByteVector;
import net.wasamon.mjlib.util.DataUtil;

public class KeySim extends MicsElement implements ExecutableElement, ChannelConnectable{

	private Channel index;
	private ByteVector[] data = new ByteVector[18];
	private int count;
	
	@Override
	public String[] getConnectedElements() {
		return new String[]{index.id()};
	}

	@Override
	public String getDescription() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getImagePath() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void initialize(String base, Node node) throws MicsException {
		index = composite.getChannel(getAttributeAsString(node, "index"));
		data[ 0] = new ByteVector(DataUtil.toByteArray("ffffe", 16));
		data[ 1] = new ByteVector(DataUtil.toByteArray("ffffd", 16));
		data[ 2] = new ByteVector(DataUtil.toByteArray("ffffb", 16));
		data[ 3] = new ByteVector(DataUtil.toByteArray("ffff7", 16));
		data[ 4] = new ByteVector(DataUtil.toByteArray("fffef", 16));
		data[ 5] = new ByteVector(DataUtil.toByteArray("fffdf", 16));
		data[ 6] = new ByteVector(DataUtil.toByteArray("fff7f", 16));
		data[ 7] = new ByteVector(DataUtil.toByteArray("ffeff", 16));
		data[ 8] = new ByteVector(DataUtil.toByteArray("ffdff", 16));
		data[ 9] = new ByteVector(DataUtil.toByteArray("ffbff", 16));
		data[10] = new ByteVector(DataUtil.toByteArray("ff7ff", 16));
		data[11] = new ByteVector(DataUtil.toByteArray("fefff", 16));
		data[12] = new ByteVector(DataUtil.toByteArray("fdfff", 16));
		data[13] = new ByteVector(DataUtil.toByteArray("fbfff", 16));
		data[14] = new ByteVector(DataUtil.toByteArray("f7fff", 16));
		data[15] = new ByteVector(DataUtil.toByteArray("effff", 16));
		data[16] = new ByteVector(DataUtil.toByteArray("dffff", 16));
		data[17] = new ByteVector(DataUtil.toByteArray("bffff", 16));
	}

	public ExecInfo exec_first() throws MicsException {
		index.writeRequest(this, data[count]);
		count = (count + 1) & 17;
		return null;
	}

	public ExecInfo exec_second() throws MicsException {
		// TODO Auto-generated method stub
		return null;
	}

	public void reset() {
		// TODO Auto-generated method stub
		
	}

	public int getChannelOffset(Channel c) {
		// TODO Auto-generated method stub
		return 0;
	}

	public void writeback(Channel src, MicsDataPacket data) throws MicsException {
		// TODO Auto-generated method stub
		
	}

}
