package net.wasamon.mics.freehdl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

import net.wasamon.mics.data.ByteVector;

/**
 * FreeHDLが入力信号を読みとるファイルに対する出力を提供する
 */
public class FreeHDLOutputStream{

  private PrintWriter writer;
  private int width;
  String pad;

  /**
   * コンストラクタ
   * @param file FreeHDLが入力データを読み込むファイル
   */
  public FreeHDLOutputStream(File file, int width) throws IOException{
    writer = new PrintWriter(new FileOutputStream(file, false), true);
    this.width = width;
    for(int i = 0; i < width; i++){
    	pad += "0";
    }
  }

  public void write(ByteVector data){
  	String str = pad + data.toBitString();
  	writer.println(str.substring(str.length() - width));
  }



}
