/* 
 *    Copyright 2007 Takefumi MIYOSHI
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package net.wasamon.mjlib.util;

import java.math.BigInteger;

/**
 * 
 * @author Takefumi MIYOSHI
 * 
 */
public class DataUtil {
	
	public static int toInteger(byte[] d){
		return toInteger(d, 0, d.length);
	}
	
	public static int toInteger(byte b){
		return toInteger(new byte[]{b});
	}

	public static int toInteger(byte[] d, int offset, int length){
		int v = 0;
		switch(length){
		case 1:
			v += ((int)d[0+offset] & 0x00ff) << 0;
			break;
		case 2:
			v += ((int)d[0+offset] & 0x00ff) << 8;
			v += ((int)d[1+offset] & 0x00ff) << 0;
			break;
		case 4:
			v += ((int)d[0+offset] & 0x00ff) << 24;
			v += ((int)d[1+offset] & 0x00ff) << 16;
			v += ((int)d[2+offset] & 0x00ff) << 8;
			v += ((int)d[3+offset] & 0x00ff) << 0;
			break;
		}
		return v;
	}

	public static char toChar(byte h, byte l){
		return toChar(new byte[]{h,l}, 0, 2);
	}
	
	public static char toChar(byte[] d, int offset, int length){
		char v = 0;
		if(length == 2){
			v += (char)(((int)d[0+offset]&0x00ff) << 8);
			v += (char)(((int)d[1+offset]&0x00ff) << 0);
		}else{
			v += (char)(((int)d[0+offset]&0x00ff) << 0);
		}
		return v;
	}
	
	public static byte[] toByteArray(char v){
		byte[] d = new byte[2];
		d[0] = (byte)(((v >> 8)& 0x00ff));
		d[1] = (byte)(((v >> 0)& 0x00ff));
		return d;
	}

	public static char toCharL(int a) {
		return (char) a;
	}

	public static char toCharH(int a) {
		return (char) ((a >> 16) & 0x0000ffff);
	}

	public static byte toByteL(char a) {
		return (byte)(a&0x00ff);
	}

	public static byte toByteH(int a) {
		return (byte)((a >> 8) & 0x00ff);
	}

	public static int toInteger(char a, char b) {
		return ((int) (a << 16)) + ((int) b);
	}

	public static String toBigEndianValueString(byte[] data) {
		String s = "0x";
		for (int i = 0; i < data.length; i++) {
			String tmp = "00";
			tmp += Integer.toHexString((int) data[i] & 0x00ff);
			s += tmp.substring(tmp.length()-2, tmp.length());
		}
		return s;
	}

	public static byte[] toByteArray(int v) {
		byte[] d = new byte[4];
		d[0] = (byte)(((v >> 24)& 0xff));
		d[1] = (byte)(((v >> 16)& 0xff));
		d[2] = (byte)(((v >> 8)& 0xff));
		d[3] = (byte)(((v >> 0)& 0xff));
		return d;
	}

	public static byte[] toByteArray(int v, int len) {
		byte[] d = new byte[len];
		for(int i = 0; i < len; i++){
			d[i] = (byte)(((v >> (len-i-1)*8)& 0xff));
		}
		return d;
	}
	
	/**
	 * 文字列をパーズし数値に変換し、byte配列に収める。
	 * @param data
	 * @param radix 基数。16以下
	 * @exception パーズ不可能な文字列が与えられたか、基数に16以上の文字を与えた場合。
	 * @return
	 */
	public static byte[] toByteArray(String data, int radix) throws NumberFormatException{
		if(radix < 0 || radix > 16) throw new NumberFormatException();
		byte b[] = new byte[data.length()/2];
		for(int i = 0; i < b.length; i++){
			b[i] = Byte.parseByte(data.substring(i*2, i*2+1), radix);
			b[i] += Byte.parseByte(data.substring(i*2+1, i*2+2), radix) << 4;
		}
		return b;
	}

	public static int toLSB8(char a) {
		return a & 0x00ff;
	}

	public static int toUSB8(char a) {
		return (a >> 8) & 0x00ff;
	}

	public static int toSiginedInteger(char d) {
		int v = 0;
		if ((d & 0x8000) == 0x8000) {
			v = d - 65536;
		} else {
			v = d;
		}
		return v;
	}

	public static int parseInt(String v) throws NumberFormatException {
		int value = 0;
		if (v.startsWith("0x")) {
			value = (new BigInteger(v.substring(2), 16)).intValue();
		} else {
			value = Integer.parseInt(v);
		}
		return value;
	}
	
	public static byte[] subArray(byte[] d, int offset, int len){
		byte[] d0 = new byte[len];
		for(int i = 0; i < len; i++){
			d0[i] = d[i+offset];
		}
		return d0;
	}


}
