/* 
 *    Copyright 2007 Takefumi MIYOSHI
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package net.wasamon.mjlib.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;

/**
 * シンプルなHTTPクライアントの実装
 *
 * @author Takefumi MIYOSHI
 */
public class SimpleHttpClient{

  public static final String version = "SimpleHttpClient 0.1";
  public static final String author = "Takefumi MIYOSHI (miyoshi@ae.titech.ac.jp)";
  public static final String copyright = "(c) 2003/06/27 All right reserved.";
  
  public static void read(String host, String filepath){
    
    String line;
    int port = 80;
    
    PrintWriter networkOut = null;
    BufferedReader networkIn = null;
    try{
      Socket http = new Socket(host, port);
      networkIn = new BufferedReader(
				     new InputStreamReader(http.getInputStream()));
      networkOut = new PrintWriter(http.getOutputStream());
      
      System.out.println("HTTPサーバ" + host + " に接続...");
      networkOut.print("GET " + filepath + " HTTP/1.1\n");
      networkOut.print("HOST: " + host + "\n");
      networkOut.print("\r\n\r\n");
      networkOut.flush();
      while ((line = networkIn.readLine()) != null) {
	System.out.print(line + "\n");
      }
    }
    catch (IOException e) {
      System.out.println("IOエラー発生");
      System.err.println(e);
    }
    finally {
      try {
	if (networkIn != null)
	  networkIn.close();
	if (networkOut != null)
	  networkOut.close();
      }
      catch (IOException e) {}
    }
  }

  public static void main(String args[]){
    System.out.println(version);
    System.out.println(author);
    System.out.println(copyright);
  }

}

