/* 
 *    Copyright 2007 Takefumi MIYOSHI
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

/**
 * AWTを用いてGUIを実装したパッケージ
 */
package net.wasamon.mics.gui.swing;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.DataBufferException;
import net.wasamon.mics.MicsElement;

public class SwingMemoryLoader implements ActionListener {
	private JFrame frame;

	private JTextField offsetField;

	private JTextField fileField;

	private JButton btnOK;

	private JButton btnCancel;

	private JButton btnFile;

	private DataBuffer memory;

	private static SwingMemoryLoader instance = new SwingMemoryLoader();

	public static SwingMemoryLoader getInstance() {
		return instance;
	}

	private SwingMemoryLoader() {
		frame = new JFrame();
		frame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				frame.setVisible(false);
			}
		});
		{
			JPanel p = new JPanel(new BorderLayout());
			JTextField t = new JTextField("offset");
			offsetField = new JTextField("0", 10);
			t.setEditable(false);
			p.add(t, BorderLayout.WEST);
			p.add(offsetField, BorderLayout.CENTER);
			frame.add(p, BorderLayout.NORTH);
		}
		{
			JPanel p = new JPanel(new BorderLayout());
			fileField = new JTextField(30);
			fileField.setEditable(false);
			btnFile = new JButton("File");
			btnFile.addActionListener(this);
			p.add(fileField, BorderLayout.CENTER);
			p.add(btnFile, BorderLayout.EAST);
			frame.add(p, BorderLayout.CENTER);
		}
		{
			JPanel p = new JPanel();
			btnOK = new JButton("OK");
			btnOK.addActionListener(this);
			p.add(btnOK, BorderLayout.WEST);
			btnCancel = new JButton("Cancel");
			btnCancel.addActionListener(this);
			p.add(btnCancel, BorderLayout.WEST);
			frame.add(p, BorderLayout.SOUTH);
		}
		frame.pack();
		// frame.setResizable(false);
		frame.setVisible(false);
	}

	public void actionPerformed(ActionEvent ev) {
		Object src = ev.getSource();
		if (src == null) {
		} else if (src == btnFile) {
			JFileChooser fd = new JFileChooser();
			int returnVal = fd.showOpenDialog(frame);
	    if(returnVal == JFileChooser.APPROVE_OPTION) {
	    	File f = fd.getSelectedFile();
	    	fileField.setText(f.getAbsolutePath());
	    }
		} else if (src == btnOK) {
			if (fileField.getText().equals("")) {
				System.out.println("File is not selected.");
				return;
			}
			int offset = 0;
			try {
				offset = Integer.parseInt(offsetField.getText());
			} catch (NumberFormatException e) {
				System.out.println("Illegal offset.");
				return;
			}
			try {
				if (memory != null) {
					BufferedInputStream reader = new BufferedInputStream(
							new FileInputStream(new File(fileField.getText())));
					memory.write(offset, reader);
				}
			} catch (DataBufferException e) {
				System.out.println(e.getMessage());
			} catch (FileNotFoundException e) {
				System.out.println(e.getMessage());
			}
			discard();
			System.out.println("write succeeded. src=" + fileField.getText() + ","
					+ " offset=" + offset);
		} else if (src == btnCancel) {
			discard();
		} else {
		}
	}

	public void discard() {
		memory = null;
		frame.setVisible(false);
	}

	public void show(DataBuffer memory) {
		this.memory = memory;
		frame.setTitle("RandomAccessMemory (ID=" + ((MicsElement) memory).id()
				+ ")");
		frame.setVisible(true);
	}

}
