package net.wasamon.mics.gui.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.Hashtable;

import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;

import net.wasamon.mics.DataBuffer;
import net.wasamon.mics.MicsElement;
import net.wasamon.mics.MicsViewable;
import net.wasamon.mics.gui.MicsArchitectureViewer;
import net.wasamon.mjlib.util.DataUtil;

public class SwingArchitectureCanvas extends JPanel implements MouseListener,
		MouseMotionListener, MicsArchitectureViewer.ViwerCanvas, ActionListener{

	private SwingArchitectureViewer frame;

	Hashtable<String, Image> imageTable;

	private JPopupMenu menu;

	private JButton btnLoad;

	private JButton btnView;

	private JTextField fieldAddr;

	private JButton btnPrint;

	Graphics g;

	public SwingArchitectureCanvas(SwingArchitectureViewer frame) {
		super();
		this.frame = frame;
		imageTable = new Hashtable<String, Image>();
		menu = new JPopupMenu();
		menu.add(btnLoad = newJButton("Load", this));
		menu.add(btnView = newJButton("View", this));
		fieldAddr = new JTextField("0", 5);
		fieldAddr.addActionListener(this);
		menu.add(btnPrint = newJButton("Print", this));
		addMouseListener(this);
		addMouseMotionListener(this);
	}

	private JButton newJButton(String label, ActionListener listner) {
		JButton btn = new JButton(label);
		btn.addActionListener(listner);
		return btn;
	}

	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		this.g = g;
		g.setColor(Color.WHITE);
		g.fillRect(0, 0, this.getWidth(), this.getHeight());
		frame.paint();
		revalidate();
	}

	private int selectedOffsetY;
	private int selectedOffsetX;

	public void mouseClicked(MouseEvent arg0) {
		// TODO Auto-generated method stub

	}

	public void mouseEntered(MouseEvent arg0) {
		// TODO Auto-generated method stub

	}

	public void mouseExited(MouseEvent e) {
		// TODO Auto-generated method stub

	}

	private void setEnabledStatus(MicsElement element){
		if (element instanceof DataBuffer) {
			btnLoad.setEnabled(true);
			btnPrint.setEnabled(true);
			fieldAddr.setEnabled(true);
		} else {
			btnLoad.setEnabled(false);
			btnPrint.setEnabled(false);
		}
		if (element instanceof MicsViewable) {
			btnView.setEnabled(true);
		} else {
			btnView.setEnabled(false);
		}
	}
	
	public void mousePressed(MouseEvent e) {
		frame.setSelectedNode(e.getX(), e.getY());
		repaint();
		if (frame.getSelectedNode() != null) {
			selectedOffsetX = frame.getSelectedNode().X - e.getX();
			selectedOffsetY = frame.getSelectedNode().Y - e.getY();
			frame.setSelectedElement(frame.getSelectedNode().element);
			setEnabledStatus(frame.getSelectedNode().element);
		}
		if (e.getButton() == MouseEvent.BUTTON3) {
			Point p = e.getPoint();
			menu.show(this, p.x, p.y);
		}
	}

	public void mouseReleased(MouseEvent e) {
		// selectedNode = null;
	}

	public void mouseDragged(MouseEvent arg0) {
		// TODO Auto-generated method stub
		if (frame.getSelectedNode() != null) {
			frame.getSelectedNode().setPosition(arg0.getX() + selectedOffsetX, arg0.getY()
					+ selectedOffsetY);
			repaint();
			// pane.setScrollPosition(getScrollPostion(arg0.getX(), arg0.getY()));
		} else {
		}
	}

	public void mouseMoved(MouseEvent arg0) {
		// TODO Auto-generated method stub
	}
	
	public void actionPerformed(ActionEvent ev) {
		Object src = ev.getSource();
		if (src == null) {
		} else if (src == btnView) {
			MicsElement element = frame.getSelectedNode().element;
			if (element != null && element instanceof MicsViewable) {
				((MicsViewable) element).show();
			}
		} else if (src == btnLoad) {
			MicsElement element = frame.getSelectedNode().element;
			if (element != null && element instanceof DataBuffer) {
				SwingMemoryLoader.getInstance().show((DataBuffer) element);
			}
		} else if (src == btnPrint) {
			int offset = 0;
			try {
				offset = DataUtil.parseInt(fieldAddr.getText());
			} catch (NumberFormatException e) {
				System.out.println("Illegal address format.");
			}
			System.out.println("Read Memory: " + frame.getSelectedNode().element.id());
			System.out.println("From = " + offset);
			System.out.println(((DataBuffer)(frame.getSelectedNode().element)).toString(offset, 4));
		}
	}

	public void drawImage(String name, int x, int y, int w, int h) {
		if (imageTable.containsKey(name) == false) {
			File f = new File(name);
			Image image;
			if (f.exists()) {
				image = getToolkit().getImage(f.getAbsolutePath());
				System.out.println(f.getAbsolutePath());
			} else {
				image = getToolkit().getImage(
						getClass().getClassLoader().getResource(name));
			}
			imageTable.put(name, image);
		}
		g.drawImage((Image) (imageTable.get(name)), x, y, w, h, this);
	}

	public void drawLine(int x0, int y0, int x1, int y1) {
		g.drawLine(x0, y0, x1, y1);
	}

	public void drawRect(int x, int y, int w, int h) {
		g.drawRect(x, y, w, h);
	}

	public void drawString(String str, int x, int y) {
		g.drawString(str, x, y);
	}

	public void fillRect(int x, int y, int w, int h) {
		g.fillRect(x, y, w, h);
	}

	public int height() {
		return getBounds().height;
	}

	public void setBGColor() {
		g.setColor(Color.gray);
	}

	public void setColorBlack() {
		g.setColor(Color.black);
	}

	public void setColorRed() {
		g.setColor(Color.red);
	}

	public void setFGColor() {
		g.setColor(Color.black);
	}

	public int width() {
		return getBounds().width;
	}
}
