/* 
 *    Copyright 2007 MICS Project
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package net.wasamon.mics.architecturemaker.unit;

import java.util.regex.Pattern;


/**
 * @author Masayuki Morisita
 */
public class ReconfigurableUnit extends HardwareUnit implements DataBuffer,
		ChannelConnectable, ExecutableElement {
	private static String baseID = "rlu";
	private static String defaultImageFile = "icons/unit/rlu.png";

	public ReconfigurableUnit(String id, int x, int y) {
		super(id, "net.wasamon.mics.processor.rlu.ReconfigurableUnit", x, y,
				40, 40, defaultImageFile);
		conditionTable.put("size", Pattern.compile("\\p{Digit}+"));
		setValue("size", "8");
	}

	public String getBaseID() {
		return baseID;
	}

	public void setBaseID(String baseID) {
		this.baseID = baseID;
	}

	public static String getDefaultImageFile() {
		return defaultImageFile;
	}

	public void addInitFile(StringBuilder fileName, StringBuilder offset) {
		childList.add(new InitAttribute(fileName, offset));
	}

	public void addChannel(StringBuilder id, StringBuilder offset) {
		childList.add(new ChannelAttribute(id, offset));
	}

	public String getInformation() {
		return "";
	}

	public void register(HardwareUnit unit) {
		addChannel(unit.getValue("id"), new StringBuilder(String.format("0x%x",
				0)));
	}

	public void remove(HardwareUnit unit) {
		StringBuilder id = unit.getValue("id");
		for (int i = 0; i < childList.size(); ++i) {
			if (id == childList.get(i).getValue("id")) {
				childList.remove(i);
			}
		}
	}

	public boolean isConnectable(HardwareUnit unit) {
		if (!(unit instanceof Channel)) {
			return false;
		}

		return true;
	}

	public HardwareUnit copy() {
		ReconfigurableUnit copy = new ReconfigurableUnit(getID(), appearance.getX(),
				appearance.getY());
		copy.appearance.setSize(appearance.getWidth(), appearance.getHeight());
		copy.appearance.set("image", appearance.get("image"));

		return copy;
	}
}
