/* 
 *    Copyright 2007 MICS Project
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package net.wasamon.mics.architecturemaker.unit;

import java.util.regex.Pattern;


/**
 * @author Masayuki Morisita
 */
public class RandomAccessMemory extends HardwareUnit implements DataBuffer {
	private static String baseID = "mem";
	private static String defaultImageFile = "icons/unit/pp_memory1_1.gif";

	public RandomAccessMemory(String id, int x, int y) {
		super(id, "net.wasamon.mics.memory.RandomAccessMemory", x, y, 40, 40,
				defaultImageFile);
		conditionTable.put("size", Pattern
				.compile("\\p{Digit}+|^0x\\p{XDigit}+"));
		setValue("size", "0x1000");
	}

	public String getBaseID() {
		return baseID;
	}

	public void setBaseID(String baseID) {
		this.baseID = baseID;
	}

	public static String getDefaultImageFile() {
		return defaultImageFile;
	}

	public void addInitFile(StringBuilder fileName, StringBuilder offset) {
		childList.add(new InitAttribute(fileName, offset));
	}

	public String getInformation() {
		return "";
	}

	public void register(HardwareUnit unit) {
	}

	public void remove(HardwareUnit unit) {
	}

	public boolean isConnectable(HardwareUnit unit) {
		if (!(unit instanceof Channel)) {
			return false;
		}

		return true;
	}

	public HardwareUnit copy() {
		RandomAccessMemory copy = new RandomAccessMemory(getID(), appearance.getX(),
				appearance.getY());
		copy.appearance.setSize(appearance.getWidth(), appearance.getHeight());
		copy.appearance.set("image", appearance.get("image"));

		return copy;
	}
}
