/* 
 *    Copyright 2007 MICS Project
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package net.wasamon.mics.architecturemaker.unit;

import java.util.regex.Pattern;


/**
 * @author Masayuki Morisita
 */
public class DirectMemoryAccessController extends HardwareUnit implements
		Channel, ChannelConnectable, ExecutableElement {
	private static String baseID = "dmac";
	private static String defaultImageFile = "icons/unit/square_g.gif";

	public DirectMemoryAccessController(String id, int x, int y) {
		super(id, "net.wasamon.mics.peripheral.DirectMemoryAccessController",
				x, y, 16, 16, defaultImageFile);
		conditionTable.put("width", Pattern.compile("\\p{Digit}+"));
		conditionTable.put("src", Pattern.compile(".{0}&&[^.]"));
		conditionTable.put("dest", Pattern.compile(".{0}&&[^.]"));
		setValue("width", "3");
		setValue("src", "");
		setValue("dest", "");
	}

	public String getBaseID() {
		return baseID;
	}

	public void setBaseID(String baseID) {
		this.baseID = baseID;
	}

	public static String getDefaultImageFile() {
		return defaultImageFile;
	}

	public void addChannel(StringBuilder id, StringBuilder offset) {
	}

	public String getInformation() {
		return "";
	}

	public void register(HardwareUnit unit) {
		HardwareUnit source = getConnectedUnit(getValue("src").toString());
		HardwareUnit destination = getConnectedUnit(getValue("dest").toString());

		if (source == null) {
			if (unit instanceof Channel) {
				setValue("src", unit.getValue("id"));
			}
		} else if (destination == null) {
			if (unit instanceof Channel) {
				setValue("dest", unit.getValue("id"));
			}
		}
	}

	public void remove(HardwareUnit unit) {
		HardwareUnit source = getConnectedUnit(getValue("src").toString());
		HardwareUnit destination = getConnectedUnit(getValue("dest").toString());

		if (source == unit) {
			setValue("src", new StringBuilder(""));
			for (int i = 0; i < connectedUnits.size(); ++i) {
				HardwareUnit connectedUnit = connectedUnits.get(i);
				if (connectedUnit != unit && connectedUnit != destination) {
					register(connectedUnit);
					return;
				}
			}
		} else if (destination == unit) {
			setValue("dest", new StringBuilder(""));
			for (int i = 0; i < connectedUnits.size(); ++i) {
				HardwareUnit connectedUnit = connectedUnits.get(i);
				if (connectedUnit != unit && connectedUnit != source) {
					register(connectedUnit);
					return;
				}
			}
		}
	}

	public boolean isConnectable(HardwareUnit unit) {
		if (!(unit instanceof DataBuffer || unit instanceof Channel || unit instanceof ChannelConnectable)) {
			return false;
		}

		HardwareUnit source = getConnectedUnit(getValue("src").toString());
		HardwareUnit destination = getConnectedUnit(getValue("dest").toString());

		if (unit instanceof Channel && source != null && destination != null) {
			return false;
		}

		return true;
	}

	public HardwareUnit copy() {
		DirectMemoryAccessController copy = new DirectMemoryAccessController(
				getID(), appearance.getX(), appearance.getY());
		copy.appearance.setSize(appearance.getWidth(), appearance.getHeight());
		copy.appearance.set("image", appearance.get("image"));

		return copy;
	}
}
