/* 
 *    Copyright 2007 MICS Project
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package net.wasamon.mics.architecturemaker.unit;

import java.util.regex.Pattern;

/**
 * @author Masayuki Morisita
 */
public class ChannelAttribute extends MicsNode {
	ChannelAttribute(StringBuilder id, StringBuilder offset) {
		tag = "channel";
		indent = "    ";
		conditionTable.put("id", Pattern.compile(".{0}&&[^.]"));
		conditionTable.put("offset", Pattern
				.compile("\\p{Digit}+|^0x\\p{XDigit}+"));
		setValue("id", id);
		setValue("offset", offset);
	}
}
