/* 
 *    Copyright 2007 MICS Project
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package net.wasamon.mics.architecturemaker;

import java.awt.*;
import javax.swing.*;

import net.wasamon.mics.architecturemaker.unit.Mediator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

/**
 * @author Masayuki Morisita
 */
public class ConfigFileEditor extends JTextArea {
	private Mediator mediator;

	private static ConfigFileEditor instance = new ConfigFileEditor();

	private ConfigFileEditor() {
		mediator = Mediator.getInstance();
	}

	public static ConfigFileEditor getInstance() {
		return instance;
	}

	public void convert() {
		ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

		try {
			mediator.printXML(outputStream);
			setText(outputStream.toString());
		} catch (IOException exception) {
			OutputTextArea.getInstance().append(exception.toString());
		}
	}
}
