/*
 * Decompiled with CFR 0.152.
 */
package net.wasamon.jgdb;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

class GdbInfo {
    private static final Pattern patternBreakPoint = Pattern.compile("stopped,reason=\"breakpoint-hit\".*");
    private static final Pattern patternEndStep = Pattern.compile("stopped,reason=\"end-stepping-range\".*");
    private static final Pattern patternExited = Pattern.compile("stopped,reason=\"exited\",exit-code=\"(\\d+)\".*");
    private static final Pattern patternSignal = Pattern.compile("stopped,reason=\"signal-received\",signal-name=\"(\\w+)\".*");
    static final int DONE = 1;
    static final int ERROR = 2;
    static final int RUNNING = 3;
    static final int SIGNAL = 4;
    static final int EXITED = 5;
    private int status;
    private String debugMessage = "";
    private String message = "";
    private String targetMessage = "";
    private String signal = null;
    private String args = "";

    GdbInfo() {
    }

    int getStoppedStatus(String v) {
        Matcher m = patternSignal.matcher(v);
        if (m.matches()) {
            this.signal = m.group(1);
            return 4;
        }
        m = patternExited.matcher(v);
        if (m.matches()) {
            return 5;
        }
        return 1;
    }

    void setStatus(String value) {
        if (value.equals("done")) {
            this.status = 1;
            if (value.length() > "done".length()) {
                this.args = value.substring("done".length());
            }
        } else if (value.startsWith("connected")) {
            this.status = 1;
        } else if (value.startsWith("done")) {
            this.status = 1;
        } else if (value.startsWith("error")) {
            this.status = 2;
        } else if (value.startsWith("running")) {
            this.status = 3;
        } else if (value.startsWith("stopped")) {
            this.status = this.getStoppedStatus(value);
        } else {
            System.out.print("unkonw status: " + value);
        }
    }

    void setStatus(int status) {
        this.status = status;
    }

    int getStatus() {
        return this.status;
    }

    void addMessage(String s) {
        this.message = String.valueOf(this.message) + s + "\n";
    }

    void addTargetMessage(String s) {
        this.targetMessage = String.valueOf(this.targetMessage) + s + "\n";
    }

    void addDebugMessage(String s) {
        this.debugMessage = String.valueOf(this.debugMessage) + s + "\n";
    }

    String getMessage() {
        return this.message;
    }

    String getTargetMessage() {
        return this.targetMessage;
    }

    String getDebugMessage() {
        return this.debugMessage;
    }

    String getArgs() {
        return this.args;
    }

    String getSignal() {
        return this.signal;
    }
}

