/*
 * Decompiled with CFR 0.152.
 */
package coins.util;

import coins.util.IntConst;

public final class IntLive {
    private final IntConst val;
    private static Shift SHIFT_LSH = new Shift(){

        IntConst eval(IntConst c, int n) {
            return c.lsh(n);
        }
    };
    private static Shift SHIFT_RSHU = new Shift(){

        IntConst eval(IntConst c, int n) {
            return c.rshu(n);
        }
    };
    private static Shift SHIFT_RSHS = new Shift(){

        IntConst eval(IntConst c, int n) {
            return c.rshs(n);
        }
    };

    private IntLive(IntConst val) {
        this.val = val;
    }

    public static IntLive valueOf(int size) {
        return new IntLive(IntConst.valueOf(size, 0L).bnot());
    }

    public static IntLive empty(int size) {
        return new IntLive(IntConst.valueOf(size, 0L));
    }

    public static IntLive valueOf(IntConst val) {
        return new IntLive(val);
    }

    public IntLive union(IntLive l) {
        return IntLive.valueOf(this.val.bor(l.val));
    }

    public IntLive intersection(IntLive l) {
        return IntLive.valueOf(this.val.band(l.val));
    }

    public IntLive inheritAdd() {
        return IntLive.valueOf(IntLive.propagateRight(this.val));
    }

    public IntLive inheritAdd(IntConst c) {
        return IntLive.valueOf(IntLive.propagateRight(this.val).band(IntLive.rightmostOne(c).neg()).bor(this.val));
    }

    public IntLive inheritSub0() {
        return this.inheritAdd();
    }

    public IntLive inheritSub1() {
        return this.inheritAdd();
    }

    public IntLive inheritSub0(IntConst c1) {
        return this.inheritAdd(c1.neg());
    }

    public IntLive inheritSub1(IntConst c0) {
        return this.inheritAdd(c0.bnot());
    }

    public IntLive inheritMul() {
        return this.inheritAdd();
    }

    public IntLive inheritMul(IntConst c) {
        if (c.size() != this.val.size()) {
            throw new IllegalArgumentException(this + " " + c);
        }
        if (c.signum() == 0) {
            return IntLive.empty(this.val.size());
        }
        IntConst a = IntLive.rightmostOne(c);
        IntConst v0 = this.val.divu(a);
        if (a.equals(c)) {
            return IntLive.valueOf(v0);
        }
        IntConst b = IntLive.rightmostOne(c.sub(a).divu(a));
        IntConst v = IntLive.propagateRight(v0.divu(b));
        return IntLive.valueOf(v.mul(b).bor(v).bor(v0));
    }

    public IntLive inheritDivu0() {
        return IntLive.valueOf(IntLive.rightmostOne(this.val).neg());
    }

    public IntLive inheritDivu1() {
        return IntLive.valueOf(this.val.size());
    }

    public IntLive inheritDivu0(IntConst c1) {
        if (c1.size() != this.val.size()) {
            throw new IllegalArgumentException(this + " " + c1);
        }
        IntConst a = IntLive.rightmostOne(c1);
        if (a.equals(c1)) {
            return IntLive.valueOf(this.val.mul(a));
        }
        IntConst b = IntConst.valueOf(c1.size(), 0L).bnot().divu(c1);
        if (this.val.band(IntLive.propagateRight(b)).signum() == 0) {
            return IntLive.empty(this.val.size());
        }
        return IntLive.valueOf(a.mul(IntLive.rightmostOne(this.val)).neg());
    }

    public IntLive inheritDivu1(IntConst c0) {
        if (c0.size() != this.val.size()) {
            throw new IllegalArgumentException(this + " " + c0);
        }
        return IntLive.valueOf(this.val.size());
    }

    public IntLive inheritDivs0() {
        return IntLive.allOrEmpty(this.val, this.val.size());
    }

    public IntLive inheritDivs1() {
        return IntLive.valueOf(this.val.size());
    }

    public IntLive inheritDivs0(IntConst c1) {
        IntConst b;
        if (c1.size() != this.val.size()) {
            throw new IllegalArgumentException(this + " " + c1);
        }
        if (c1.signum() == 0) {
            return IntLive.empty(this.val.size());
        }
        if (this.val.signum() == 0) {
            return this;
        }
        IntConst zero = IntConst.valueOf(c1.size(), 0L);
        IntConst one = IntConst.valueOf(c1.size(), 1L);
        IntConst msb = one.lsh(c1.size() - 1);
        IntConst all = zero.bnot();
        if (c1.equals(one)) {
            return this;
        }
        if (c1.equals(all)) {
            return this.inheritNeg();
        }
        IntConst c = c1.signum() >= 0 ? c1 : c1.neg();
        IntConst a = IntLive.rightmostOne(c);
        if (a.equals(c)) {
            IntConst v = IntLive.propagateRight(this.val).mul(a).add(a).sub(one).bor(msb);
            if (c1.signum() < 0 && this.val.band(all.divu(a)).signum() == 0) {
                v = a.equals(msb) ? zero : v.band(a.neg());
            }
            return IntLive.valueOf(v);
        }
        IntConst v = all;
        if (a.equals(one)) {
            if (c1.signum() > 0) {
                v = IntLive.rightmostOne(c.sub(one)).neg();
                IntConst b2 = msb.divu(c);
                if (this.val.band(IntLive.propagateRight(b2)).signum() != 0) {
                    v = v.bor(IntLive.rightmostOne(this.val).neg());
                }
            }
            if (this.val.equals(one) && c.add(msb.mods(c)).equals(one)) {
                v = v.band(msb.bnot());
            }
            return IntLive.valueOf(v);
        }
        if (c1.signum() < 0 && this.val.band(IntLive.propagateRight(b = msb.divu(c))).signum() == 0) {
            v = v.band(a.neg());
        }
        return IntLive.valueOf(v);
    }

    public IntLive inheritDivs1(IntConst c0) {
        return this.inheritDivu1(c0);
    }

    public IntLive inheritModu0() {
        return IntLive.allOrEmpty(this.val, this.val.size());
    }

    public IntLive inheritModu1() {
        return IntLive.valueOf(this.val.size());
    }

    public IntLive inheritModu0(IntConst c1) {
        if (c1.size() != this.val.size()) {
            throw new IllegalArgumentException(this + " " + c1);
        }
        if (c1.signum() == 0) {
            return IntLive.empty(this.val.size());
        }
        IntConst a = IntLive.rightmostOne(c1);
        if (a.equals(c1)) {
            return IntLive.valueOf(this.val.band(a.sub(IntConst.valueOf(a.size(), 1L))));
        }
        IntConst b = IntLive.propagateRight(c1).band(a.neg());
        if (this.val.band(b).signum() == 0) {
            return IntLive.valueOf(a.sub(IntConst.valueOf(a.size(), 1L)).band(this.val));
        }
        return IntLive.valueOf(a.neg().bor(this.val));
    }

    public IntLive inheritModu1(IntConst c0) {
        return this.inheritDivu1(c0);
    }

    public IntLive inheritMods0() {
        return this.inheritModu0();
    }

    public IntLive inheritMods1() {
        return IntLive.valueOf(this.val.size());
    }

    public IntLive inheritMods0(IntConst c1) {
        if (c1.size() != this.val.size()) {
            throw new IllegalArgumentException(this + " " + c1);
        }
        if (c1.signum() == 0) {
            return IntLive.empty(this.val.size());
        }
        IntConst one = IntConst.valueOf(c1.size(), 1L);
        IntConst msb = one.lsh(c1.size() - 1);
        if (c1.signum() < 0) {
            c1 = c1.neg();
        }
        if (c1.equals(one)) {
            return IntLive.empty(c1.size());
        }
        IntConst a = IntLive.rightmostOne(c1);
        if (a.equals(c1)) {
            IntConst v = this.val.band(a.sub(one));
            if (this.val.band(a.neg()).signum() != 0) {
                v = v.bor(a.sub(one)).bor(msb);
            }
            return IntLive.valueOf(v);
        }
        IntConst v = this.val;
        if (this.val.band(a.neg()).signum() != 0) {
            v = v.bor(a.neg());
        }
        if (this.val.equals(one) && a.equals(one) && c1.add(msb.mods(c1)).equals(one)) {
            v = v.band(msb.bnot());
        }
        if (this.val.band(c1.neg()).signum() != 0) {
            v = v.bor(a.sub(one));
        }
        return IntLive.valueOf(v);
    }

    public IntLive inheritMods1(IntConst c0) {
        return this.inheritDivu1(c0);
    }

    public IntLive inheritBand() {
        return this;
    }

    public IntLive inheritBand(IntConst c) {
        return IntLive.valueOf(this.val.band(c));
    }

    public IntLive inheritBor() {
        return this;
    }

    public IntLive inheritBor(IntConst c) {
        return IntLive.valueOf(this.val.band(c.bnot()));
    }

    public IntLive inheritBxor() {
        return this;
    }

    public IntLive inheritBxor(IntConst c) {
        if (c.size() != this.val.size()) {
            throw new IllegalArgumentException(this + " " + c);
        }
        return this;
    }

    public IntLive inheritLsh0() {
        return this.inheritAdd();
    }

    public IntLive inheritLsh1(int t) {
        return IntLive.allOrEmpty(this.val, t);
    }

    public IntLive inheritLsh0(IntConst c1) {
        return IntLive.valueOf(this.val.rshu(c1));
    }

    public IntLive inheritLsh1(IntConst c0, int t) {
        return this.inheritShift1(SHIFT_LSH, c0, t);
    }

    public IntLive inheritRshu0() {
        return IntLive.valueOf(IntLive.rightmostOne(this.val).neg());
    }

    public IntLive inheritRshu1(int t) {
        return IntLive.allOrEmpty(this.val, t);
    }

    public IntLive inheritRshu0(IntConst c1) {
        return IntLive.valueOf(this.val.lsh(c1));
    }

    public IntLive inheritRshu1(IntConst c0, int t) {
        return this.inheritShift1(SHIFT_RSHU, c0, t);
    }

    public IntLive inheritRshs0() {
        return this.inheritRshu0();
    }

    public IntLive inheritRshs1(int t) {
        return IntLive.allOrEmpty(this.val.band(IntLive.msbOnly(t).bnot()), t);
    }

    public IntLive inheritRshs0(IntConst c1) {
        IntConst v = this.val.lsh(c1);
        if (!v.rshu(c1).equals(this.val)) {
            v = v.bor(IntLive.msbOnly(this.val.size()));
        }
        return IntLive.valueOf(v);
    }

    public IntLive inheritRshs1(IntConst c0, int t) {
        return this.inheritShift1(SHIFT_RSHS, c0, t);
    }

    private IntLive inheritShift1(Shift op, IntConst c0, int t) {
        int size = this.val.size();
        int size2 = size << 1;
        if (c0.size() != size) {
            throw new IllegalArgumentException(this + " " + c0);
        }
        int v = 0;
        int s = 0;
        for (int m = 1; s < t && m != 0 && m - Integer.MIN_VALUE < size2 - Integer.MIN_VALUE; m <<= 1, ++s) {
            IntConst a = IntConst.valueOf(size, 0L);
            int n = 0;
            while (n < size) {
                a = a.bor(op.eval(c0, n).bxor(op.eval(c0, n + m)));
                n = (n | m) + 1 & ~m;
            }
            if (a.band(this.val).signum() == 0) continue;
            v |= m;
        }
        return IntLive.valueOf(IntConst.valueOf(s, v).convsx(t));
    }

    public IntLive inheritNeg() {
        return this.inheritAdd();
    }

    public IntLive inheritBnot() {
        return this;
    }

    public IntLive inheritTsteq(int t) {
        return IntLive.allOrEmpty(this.val.band(IntConst.valueOf(this.val.size(), 1L)), t);
    }

    public IntLive inheritTsteq(IntConst c) {
        return IntLive.allOrEmpty(this.val.band(IntConst.valueOf(this.val.size(), 1L)), c.size());
    }

    public IntLive inheritTstne(int t) {
        return this.inheritTsteq(t);
    }

    public IntLive inheritTstne(IntConst c) {
        return this.inheritTsteq(c);
    }

    public IntLive inheritTstltu0(int t) {
        return this.inheritTsteq(t);
    }

    public IntLive inheritTstltu1(int t) {
        return this.inheritTsteq(t);
    }

    public IntLive inheritTstltu0(IntConst c1) {
        if (this.val.band(IntConst.valueOf(this.val.size(), 1L)).signum() == 0) {
            return IntLive.empty(c1.size());
        }
        return IntLive.valueOf(IntLive.rightmostOne(c1).neg());
    }

    public IntLive inheritTstltu1(IntConst c0) {
        if (this.val.band(IntConst.valueOf(this.val.size(), 1L)).signum() == 0) {
            return IntLive.empty(c0.size());
        }
        return IntLive.valueOf(IntLive.rightmostOne(c0.add(IntConst.valueOf(c0.size(), 1L))).neg());
    }

    public IntLive inheritTstgtu0(int t) {
        return this.inheritTsteq(t);
    }

    public IntLive inheritTstgtu1(int t) {
        return this.inheritTsteq(t);
    }

    public IntLive inheritTstgtu0(IntConst c1) {
        return this.inheritTstltu1(c1);
    }

    public IntLive inheritTstgtu1(IntConst c0) {
        return this.inheritTstltu0(c0);
    }

    public IntLive inheritTstleu0(int t) {
        return this.inheritTsteq(t);
    }

    public IntLive inheritTstleu1(int t) {
        return this.inheritTsteq(t);
    }

    public IntLive inheritTstleu0(IntConst c1) {
        return this.inheritTstltu1(c1);
    }

    public IntLive inheritTstleu1(IntConst c0) {
        return this.inheritTstltu0(c0);
    }

    public IntLive inheritTstgeu0(int t) {
        return this.inheritTsteq(t);
    }

    public IntLive inheritTstgeu1(int t) {
        return this.inheritTsteq(t);
    }

    public IntLive inheritTstgeu0(IntConst c1) {
        return this.inheritTstltu0(c1);
    }

    public IntLive inheritTstgeu1(IntConst c0) {
        return this.inheritTstltu1(c0);
    }

    public IntLive inheritTstlts0(int t) {
        return this.inheritTsteq(t);
    }

    public IntLive inheritTstlts1(int t) {
        return this.inheritTsteq(t);
    }

    public IntLive inheritTstlts0(IntConst c1) {
        if (this.val.band(IntConst.valueOf(this.val.size(), 1L)).signum() == 0) {
            return IntLive.empty(c1.size());
        }
        return IntLive.valueOf(IntLive.rightmostOne(c1.add(IntLive.msbOnly(c1.size()))).neg());
    }

    public IntLive inheritTstlts1(IntConst c0) {
        if (this.val.band(IntConst.valueOf(this.val.size(), 1L)).signum() == 0) {
            return IntLive.empty(c0.size());
        }
        return IntLive.valueOf(IntLive.rightmostOne(c0.sub(IntLive.msbOnly(c0.size()).bnot())).neg());
    }

    public IntLive inheritTstgts0(int t) {
        return this.inheritTsteq(t);
    }

    public IntLive inheritTstgts1(int t) {
        return this.inheritTsteq(t);
    }

    public IntLive inheritTstgts0(IntConst c1) {
        return this.inheritTstlts1(c1);
    }

    public IntLive inheritTstgts1(IntConst c0) {
        return this.inheritTstlts0(c0);
    }

    public IntLive inheritTstles0(int t) {
        return this.inheritTsteq(t);
    }

    public IntLive inheritTstles1(int t) {
        return this.inheritTsteq(t);
    }

    public IntLive inheritTstles0(IntConst c1) {
        return this.inheritTstlts1(c1);
    }

    public IntLive inheritTstles1(IntConst c0) {
        return this.inheritTstlts0(c0);
    }

    public IntLive inheritTstges0(int t) {
        return this.inheritTsteq(t);
    }

    public IntLive inheritTstges1(int t) {
        return this.inheritTsteq(t);
    }

    public IntLive inheritTstges0(IntConst c1) {
        return this.inheritTstlts0(c1);
    }

    public IntLive inheritTstges1(IntConst c0) {
        return this.inheritTstlts1(c0);
    }

    public IntLive inheritConvzx(int t) {
        return IntLive.valueOf(this.val.convit(t));
    }

    public IntLive inheritConvsx(int t) {
        IntConst v = this.val.convit(t);
        IntConst a = IntConst.valueOf(this.val.size(), 1L).lsh(t).neg();
        if (this.val.band(a).signum() != 0) {
            v = v.bor(IntLive.msbOnly(t));
        }
        return IntLive.valueOf(v);
    }

    public IntLive inheritConvit(int t) {
        return IntLive.valueOf(this.val.convzx(t));
    }

    public IntLive inheritIfthenelse0(int t) {
        return IntLive.allOrEmpty(this.val, t);
    }

    public IntLive inheritIfthenelse1() {
        return this;
    }

    public IntLive inheritIfthenelse2() {
        return this;
    }

    public IntLive inheritIfthenelse0_1(int t, IntConst c1) {
        return this.inheritIfthenelse0(t);
    }

    public IntLive inheritIfthenelse0_2(int t, IntConst c2) {
        return this.inheritIfthenelse0(t);
    }

    public IntLive inheritIfthenelse1_0(IntConst c0) {
        return c0.signum() != 0 ? this : IntLive.empty(this.val.size());
    }

    public IntLive inheritIfthenelse1_2(IntConst c2) {
        return this.inheritIfthenelse1();
    }

    public IntLive inheritIfthenelse2_0(IntConst c0) {
        return c0.signum() == 0 ? this : IntLive.empty(this.val.size());
    }

    public IntLive inheritIfthenelse2_1(IntConst c1) {
        return this.inheritIfthenelse2();
    }

    public IntLive inheritIfthenelse0(int t, IntConst c1, IntConst c2) {
        return IntLive.allOrEmpty(c1.bxor(c2).band(this.val), t);
    }

    public IntLive inheritIfthenelse1(IntConst c0, IntConst c2) {
        return this.inheritIfthenelse1_0(c0);
    }

    public IntLive inheritIfthenelse2(IntConst c0, IntConst c1) {
        return this.inheritIfthenelse2_0(c0);
    }

    public IntConst intConstValue() {
        return this.val;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof IntLive && this.val.equals(((IntLive)o).val);
    }

    public int hashCode() {
        return this.val.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("{");
        IntConst one = IntConst.valueOf(this.val.size(), 1L);
        int j = -2;
        for (int i = 0; i < this.val.size(); ++i) {
            int s = this.val.rshu(i).band(one).signum();
            if (j < 0 && s > 0) {
                if (j == -1) {
                    sb.append(',');
                }
                sb.append(i);
                j = i;
            }
            if (j < 0 || s != 0) continue;
            if (i > j + 1) {
                sb.append("..").append(i - 1);
            }
            j = -1;
        }
        if (j >= 0 && j < this.val.size() - 1) {
            sb.append("..").append(this.val.size() - 1);
        }
        return sb.append("}:").append(this.val.size()).toString();
    }

    private static IntConst rightmostOne(IntConst c) {
        return c.neg().band(c);
    }

    private static IntConst propagateRight(IntConst c) {
        for (int i = 1; i >= 0 && i < c.size(); i <<= 1) {
            c = c.bor(c.rshu(i));
        }
        return c;
    }

    private static IntConst msbOnly(int t) {
        return IntConst.valueOf(t, 1L).lsh(t - 1);
    }

    private static IntLive allOrEmpty(IntConst c, int t) {
        return c.signum() == 0 ? IntLive.empty(t) : IntLive.valueOf(t);
    }

    private static abstract class Shift {
        private Shift() {
        }

        abstract IntConst eval(IntConst var1, int var2);
    }
}

