/*
 * Decompiled with CFR 0.152.
 */
package coins.util;

import coins.util.IntConst;

public final class IntBound {
    public final IntConst lower;
    public final IntConst upper;

    public IntBound(IntConst val) {
        this.lower = val;
        this.upper = val;
    }

    public IntBound(IntConst lower, IntConst upper) {
        if (lower.size() != upper.size()) {
            throw new IllegalArgumentException(lower + " " + upper);
        }
        this.lower = lower;
        this.upper = upper;
    }

    public int size() {
        return this.lower.size();
    }

    public boolean contains(IntConst c) {
        if (this.size() != c.size()) {
            throw new IllegalArgumentException(this + " " + c);
        }
        return c.sub(this.lower).compareTo(this.upper.sub(this.lower)) <= 0;
    }

    public IntBound union(IntBound b) {
        IntConst u1;
        if (this.size() != b.size()) {
            throw new IllegalArgumentException(this + " " + b);
        }
        IntConst u0 = this.upper.sub(this.lower);
        IntConst l1 = b.lower.sub(this.lower);
        if (l1.compareTo(u1 = b.upper.sub(this.lower)) <= 0) {
            if (u1.compareTo(u0) <= 0) {
                return this;
            }
            if (l1.compareTo(u0) <= 0) {
                return new IntBound(this.lower, b.upper);
            }
            if (u1.compareTo(u0.sub(l1)) <= 0) {
                return new IntBound(this.lower, b.upper);
            }
            return new IntBound(b.lower, this.upper);
        }
        if (u1.compareTo(u0) >= 0) {
            return b;
        }
        if (l1.compareTo(u0) > 0) {
            return new IntBound(b.lower, this.upper);
        }
        IntConst l = IntConst.valueOf(this.size(), 0L);
        return new IntBound(l, l.bnot());
    }

    public IntBound intersection(IntBound b) {
        IntConst u1;
        if (this.size() != b.size()) {
            throw new IllegalArgumentException(this + " " + b);
        }
        IntConst u0 = this.upper.sub(this.lower);
        IntConst l1 = b.lower.sub(this.lower);
        if (l1.compareTo(u1 = b.upper.sub(this.lower)) <= 0) {
            if (u1.compareTo(u0) <= 0) {
                return b;
            }
            if (l1.compareTo(u0) <= 0) {
                return new IntBound(b.lower, this.upper);
            }
            return null;
        }
        if (u1.compareTo(u0) >= 0) {
            return this;
        }
        if (l1.compareTo(u0) > 0) {
            return new IntBound(this.lower, b.upper);
        }
        if (u0.compareTo(u1.sub(l1)) <= 0) {
            return this;
        }
        return b;
    }

    public IntBound add(IntBound b) {
        IntConst u;
        IntConst l;
        IntConst r1;
        if (this.size() != b.size()) {
            throw new IllegalArgumentException(this + " " + b);
        }
        IntConst r0 = this.upper.sub(this.lower);
        if (r0.add(r1 = b.upper.sub(b.lower)).compareTo(r0) < 0) {
            l = IntConst.valueOf(this.size(), 0L);
            u = l.bnot();
        } else {
            l = this.lower.add(b.lower);
            u = this.upper.add(b.upper);
        }
        return new IntBound(l, u);
    }

    public IntBound sub(IntBound b) {
        IntConst u;
        IntConst l;
        IntConst r1;
        if (this.size() != b.size()) {
            throw new IllegalArgumentException(this + " " + b);
        }
        IntConst r0 = this.upper.sub(this.lower);
        if (r0.add(r1 = b.upper.sub(b.lower)).compareTo(r0) < 0) {
            l = IntConst.valueOf(this.size(), 0L);
            u = l.bnot();
        } else {
            l = this.lower.sub(b.upper);
            u = this.upper.sub(b.lower);
        }
        return new IntBound(l, u);
    }

    public IntBound mul(IntBound b) {
        IntBound b2;
        IntBound b1;
        if (this.size() != b.size()) {
            throw new IllegalArgumentException(this + " " + b);
        }
        IntConst zero = IntConst.valueOf(this.size(), 0L);
        IntConst msb = IntConst.valueOf(this.size(), 1L).lsh(this.size() - 1);
        IntBound plus = new IntBound(zero, msb.bnot());
        IntBound minus = new IntBound(msb, zero.bnot());
        IntBound result = null;
        IntBound b0 = this.intersection(plus);
        if (b0 != null) {
            b1 = b.intersection(plus);
            if (b1 != null) {
                result = IntBound.mul1(b0, b1);
            }
            if ((b1 = b.intersection(minus)) != null) {
                b2 = IntBound.mul1(b0, b1.neg()).neg();
                IntBound intBound = result = result == null ? b2 : result.union(b2);
            }
        }
        if ((b0 = this.intersection(minus)) != null) {
            b1 = b.intersection(plus);
            if (b1 != null) {
                b2 = IntBound.mul1(b0.neg(), b1).neg();
                IntBound intBound = result = result == null ? b2 : result.union(b2);
            }
            if ((b1 = b.intersection(minus)) != null) {
                b2 = IntBound.mul1(b0.neg(), b1.neg());
                result = result == null ? b2 : result.union(b2);
            }
        }
        return result;
    }

    private static IntBound mul1(IntBound b0, IntBound b1) {
        IntConst u;
        IntConst l;
        int s = b0.size();
        int s2 = s * 2;
        IntConst m = IntConst.valueOf(s2, 1L).lsh(s);
        if (b0.upper.convzx(s2).mul(b1.upper.convzx(s2)).sub(b0.lower.convzx(s2).mul(b1.lower.convzx(s2))).compareTo(m) >= 0) {
            l = IntConst.valueOf(s, 0L);
            u = l.bnot();
        } else {
            l = b0.lower.mul(b1.lower);
            u = b0.upper.mul(b1.upper);
        }
        return new IntBound(l, u);
    }

    public IntBound divu(IntBound b) {
        if (this.size() != b.size()) {
            throw new IllegalArgumentException(this + " " + b);
        }
        IntConst l0 = this.lower;
        IntConst u0 = this.upper;
        IntConst l1 = b.lower;
        IntConst u1 = b.upper;
        if (l0.compareTo(u0) > 0) {
            l0 = IntConst.valueOf(this.size(), 0L);
            u0 = l0.bnot();
        }
        if (l1.compareTo(u1) > 0) {
            l1 = IntConst.valueOf(this.size(), 0L);
            u1 = l1.bnot();
        }
        if (l1.signum() == 0) {
            l1 = IntConst.valueOf(this.size(), 1L);
        }
        return new IntBound(l0.divu(u1), u0.divu(l1));
    }

    public IntBound divs(IntBound b) {
        IntBound b2;
        IntBound b1;
        if (this.size() != b.size()) {
            throw new IllegalArgumentException(this + " " + b);
        }
        if (b.lower.signum() == 0 && b.upper.signum() == 0) {
            throw new ArithmeticException(this + " " + b);
        }
        IntConst zero = IntConst.valueOf(this.size(), 0L);
        IntConst msb = IntConst.valueOf(this.size(), 1L).lsh(this.size() - 1);
        IntBound plus = new IntBound(zero, msb.bnot());
        IntBound minus = new IntBound(msb, zero.bnot());
        IntBound result = null;
        IntBound b0 = this.intersection(plus);
        if (b0 != null) {
            b1 = b.intersection(plus);
            if (b1 != null) {
                result = b0.divu(b1);
            }
            if ((b1 = b.intersection(minus)) != null) {
                b2 = b0.divu(b1.neg()).neg();
                IntBound intBound = result = result == null ? b2 : result.union(b2);
            }
        }
        if ((b0 = this.intersection(minus)) != null) {
            b1 = b.intersection(plus);
            if (b1 != null) {
                b2 = b0.neg().divu(b1).neg();
                IntBound intBound = result = result == null ? b2 : result.union(b2);
            }
            if ((b1 = b.intersection(minus)) != null) {
                b2 = b0.neg().divu(b1.neg());
                result = result == null ? b2 : result.union(b2);
            }
        }
        return result;
    }

    public IntBound modu(IntBound b) {
        if (this.size() != b.size()) {
            throw new IllegalArgumentException(this + " " + b);
        }
        if (b.lower.equals(b.upper)) {
            if (b.lower.signum() == 0) {
                throw new ArithmeticException(this + " " + b);
            }
            if (this.lower.compareTo(this.upper) <= 0 && this.lower.divu(b.lower).equals(this.upper.divu(b.lower))) {
                return new IntBound(this.lower.modu(b.lower), this.upper.modu(b.lower));
            }
        }
        IntConst l = IntConst.valueOf(this.size(), 0L);
        IntConst u = b.lower.compareTo(b.upper) <= 0 ? b.upper.sub(IntConst.valueOf(this.size(), 1L)) : l.bnot();
        return new IntBound(l, u);
    }

    public IntBound mods(IntBound b) {
        IntBound b2;
        IntBound b1;
        if (this.size() != b.size()) {
            throw new IllegalArgumentException(this + " " + b);
        }
        if (b.lower.signum() == 0 && b.upper.signum() == 0) {
            throw new ArithmeticException(this + " " + b);
        }
        IntConst zero = IntConst.valueOf(this.size(), 0L);
        IntConst msb = IntConst.valueOf(this.size(), 1L).lsh(this.size() - 1);
        IntBound plus = new IntBound(zero, msb.bnot());
        IntBound minus = new IntBound(msb, zero.bnot());
        IntBound result = null;
        IntBound b0 = this.intersection(plus);
        if (b0 != null) {
            b1 = b.intersection(plus);
            if (b1 != null) {
                result = b0.modu(b1);
            }
            if ((b1 = b.intersection(minus)) != null) {
                b2 = b0.modu(b1.neg());
                IntBound intBound = result = result == null ? b2 : result.union(b2);
            }
        }
        if ((b0 = this.intersection(minus)) != null) {
            b1 = b.intersection(plus);
            if (b1 != null) {
                b2 = b0.neg().modu(b1).neg();
                IntBound intBound = result = result == null ? b2 : result.union(b2);
            }
            if ((b1 = b.intersection(minus)) != null) {
                b2 = b0.neg().modu(b1.neg()).neg();
                result = result == null ? b2 : result.union(b2);
            }
        }
        return result;
    }

    public IntBound band(IntBound b) {
        if (this.size() != b.size()) {
            throw new IllegalArgumentException(this + " " + b);
        }
        if (this.lower.compareTo(this.upper) <= 0) {
            if (b.lower.compareTo(b.upper) <= 0) {
                return IntBound.minMaxAnd(this.lower, this.upper, b.lower, b.upper);
            }
            IntConst c0 = IntConst.valueOf(this.size(), 0L);
            IntConst c1 = c0.bnot();
            return IntBound.minMaxAnd(this.lower, this.upper, c0, b.upper).union(IntBound.minMaxAnd(this.lower, this.upper, b.lower, c1));
        }
        if (b.lower.compareTo(b.upper) <= 0) {
            IntConst c0 = IntConst.valueOf(this.size(), 0L);
            IntConst c1 = c0.bnot();
            return IntBound.minMaxAnd(c0, this.upper, b.lower, b.upper).union(IntBound.minMaxAnd(this.lower, c1, b.lower, b.upper));
        }
        IntConst c0 = IntConst.valueOf(this.size(), 0L);
        IntConst c1 = c0.bnot();
        return IntBound.minMaxAnd(c0, this.upper, c0, b.upper).union(IntBound.minMaxAnd(c0, this.upper, b.lower, c1)).union(IntBound.minMaxAnd(this.lower, c1, c0, b.upper)).union(IntBound.minMaxAnd(this.lower, c1, b.lower, c1));
    }

    private static IntBound minMaxAnd(IntConst a, IntConst b, IntConst c, IntConst d) {
        return new IntBound(IntBound.minAnd(a, b, c, d), IntBound.maxAnd(a, b, c, d));
    }

    private static IntConst minAnd(IntConst a, IntConst b, IntConst c, IntConst d) {
        int size = a.size();
        IntConst m = IntConst.valueOf(size, 1L).lsh(size - 1);
        while (m.signum() != 0) {
            if (a.bor(c).bnot().band(m).signum() != 0) {
                IntConst t = a.bor(m).band(m.neg());
                if (t.compareTo(b) <= 0) {
                    a = t;
                    break;
                }
                t = c.bor(m).band(m.neg());
                if (t.compareTo(d) <= 0) {
                    c = t;
                    break;
                }
            }
            m = m.rshu(1);
        }
        return a.band(c);
    }

    private static IntConst maxAnd(IntConst a, IntConst b, IntConst c, IntConst d) {
        int size = a.size();
        IntConst m = IntConst.valueOf(size, 1L).lsh(size - 1);
        IntConst one = IntConst.valueOf(size, 1L);
        while (m.signum() != 0) {
            IntConst t;
            if (b.band(d.bnot()).band(m).signum() != 0) {
                t = b.band(m.bnot()).bor(m.sub(one));
                if (t.compareTo(a) >= 0) {
                    b = t;
                    break;
                }
            } else if (b.bnot().band(d).band(m).signum() != 0 && (t = d.band(m.bnot()).bor(m.sub(one))).compareTo(c) <= 0) {
                d = t;
                break;
            }
            m = m.rshu(1);
        }
        return b.band(d);
    }

    public IntBound bor(IntBound b) {
        return this.bnot().band(b.bnot()).bnot();
    }

    public IntBound bxor(IntBound b) {
        if (this.size() != b.size()) {
            throw new IllegalArgumentException(this + " " + b);
        }
        if (this.lower.compareTo(this.upper) <= 0) {
            if (b.lower.compareTo(b.upper) <= 0) {
                return IntBound.minMaxXor(this.lower, this.upper, b.lower, b.upper);
            }
            IntConst c0 = IntConst.valueOf(this.size(), 0L);
            IntConst c1 = c0.bnot();
            return IntBound.minMaxXor(this.lower, this.upper, c0, b.upper).union(IntBound.minMaxXor(this.lower, this.upper, b.lower, c1));
        }
        if (b.lower.compareTo(b.upper) <= 0) {
            IntConst c0 = IntConst.valueOf(this.size(), 0L);
            IntConst c1 = c0.bnot();
            return IntBound.minMaxXor(c0, this.upper, b.lower, b.upper).union(IntBound.minMaxXor(this.lower, c1, b.lower, b.upper));
        }
        IntConst c0 = IntConst.valueOf(this.size(), 0L);
        IntConst c1 = c0.bnot();
        return IntBound.minMaxXor(c0, this.upper, c0, b.upper).union(IntBound.minMaxXor(c0, this.upper, b.lower, c1)).union(IntBound.minMaxXor(this.upper, c1, c0, b.upper)).union(IntBound.minMaxXor(this.upper, c1, b.lower, c1));
    }

    private static IntBound minMaxXor(IntConst a, IntConst b, IntConst c, IntConst d) {
        return new IntBound(IntBound.minXor(a, b, c, d), IntBound.maxXor(a, b, c, d));
    }

    private static IntConst minXor(IntConst a, IntConst b, IntConst c, IntConst d) {
        return IntBound.minAnd(a, b, d.bnot(), c.bnot()).bor(IntBound.minAnd(b.bnot(), a.bnot(), c, d));
    }

    private static IntConst maxXor(IntConst a, IntConst b, IntConst c, IntConst d) {
        IntConst m = IntConst.valueOf(a.size(), 0L).bnot();
        return IntBound.minAnd(IntBound.maxAnd(a, b, d.bnot(), c.bnot()).bnot(), m, IntBound.maxAnd(b.bnot(), a.bnot(), c, d).bnot(), m).bnot();
    }

    public IntBound lsh(IntBound b) {
        b = IntBound.saturate(b, this.size());
        IntBound result = null;
        for (int i = 0; i <= this.size(); ++i) {
            if (!b.contains(IntConst.valueOf(b.size(), i))) continue;
            IntBound b1 = this.lsh(i);
            result = result == null ? b1 : result.union(b1);
        }
        return result;
    }

    public IntBound rshu(IntBound b) {
        b = IntBound.saturate(b, this.size());
        IntBound result = null;
        for (int i = 0; i <= this.size(); ++i) {
            if (!b.contains(IntConst.valueOf(b.size(), i))) continue;
            IntBound b1 = this.rshu(i);
            result = result == null ? b1 : result.union(b1);
        }
        return result;
    }

    public IntBound rshs(IntBound b) {
        b = IntBound.saturate(b, this.size());
        IntBound result = null;
        for (int i = 0; i <= this.size(); ++i) {
            if (!b.contains(IntConst.valueOf(b.size(), i))) continue;
            IntBound b1 = this.rshs(i);
            result = result == null ? b1 : result.union(b1);
        }
        return result;
    }

    private static IntBound saturate(IntBound b, int i) {
        IntConst i1 = IntConst.valueOf(b.size(), i);
        IntConst l = b.lower;
        IntConst u = b.upper;
        int cmp = l.compareTo(u);
        if (l.compareTo(i1) >= 0) {
            l = i1;
        }
        if (u.compareTo(i1) >= 0) {
            u = i1;
            if (cmp > 0) {
                l = IntConst.valueOf(b.size(), 0L);
            }
        }
        return new IntBound(l, u);
    }

    public IntBound lsh(int n) {
        IntConst u;
        IntConst l;
        if (n < 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (n == 0) {
            return this;
        }
        if (n >= this.size()) {
            return new IntBound(IntConst.valueOf(this.size(), 0L));
        }
        IntConst r = this.upper.sub(this.lower);
        if (r.compareTo(IntConst.valueOf(this.size(), 1L).lsh(this.size() - n)) >= 0) {
            l = IntConst.valueOf(this.size(), 0L);
            u = l.bnot();
        } else {
            l = this.lower.lsh(n);
            u = this.upper.lsh(n);
        }
        return new IntBound(l, u);
    }

    public IntBound rshu(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (n == 0) {
            return this;
        }
        IntConst l = this.lower;
        IntConst u = this.upper;
        if (l.compareTo(u) > 0) {
            l = IntConst.valueOf(this.size(), 0L);
            u = l.bnot();
        }
        return new IntBound(l.rshu(n), u.rshu(n));
    }

    public IntBound rshs(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (n == 0) {
            return this;
        }
        IntConst l = this.lower;
        IntConst u = this.upper;
        if (l.signedCompareTo(u) > 0) {
            l = IntConst.valueOf(this.size(), 1L).lsh(this.size() - 1);
            u = l.bnot();
        }
        return new IntBound(l.rshs(n), u.rshs(n));
    }

    public IntBound neg() {
        return new IntBound(this.upper.neg(), this.lower.neg());
    }

    public IntBound bnot() {
        return new IntBound(this.upper.bnot(), this.lower.bnot());
    }

    public IntBound tsteq(IntBound b, int s) {
        return IntBound.cmpeq(this, b, s, 1);
    }

    public IntBound tstne(IntBound b, int s) {
        return IntBound.cmpeq(this, b, s, 0);
    }

    public IntBound tstltu(IntBound b, int s) {
        return IntBound.cmpu(this, b, s, 1);
    }

    public IntBound tstgtu(IntBound b, int s) {
        return IntBound.cmpu(b, this, s, 1);
    }

    public IntBound tstleu(IntBound b, int s) {
        return IntBound.cmpu(b, this, s, 0);
    }

    public IntBound tstgeu(IntBound b, int s) {
        return IntBound.cmpu(this, b, s, 0);
    }

    public IntBound tstlts(IntBound b, int s) {
        return IntBound.cmps(this, b, s, 1);
    }

    public IntBound tstgts(IntBound b, int s) {
        return IntBound.cmps(b, this, s, 1);
    }

    public IntBound tstles(IntBound b, int s) {
        return IntBound.cmps(b, this, s, 0);
    }

    public IntBound tstges(IntBound b, int s) {
        return IntBound.cmps(this, b, s, 0);
    }

    private static IntBound cmpeq(IntBound b0, IntBound b1, int s, int eq) {
        if (b0.size() != b1.size()) {
            throw new IllegalArgumentException(b0 + " " + b1);
        }
        if (b0.lower.equals(b0.upper) && b1.lower.equals(b1.upper) && b0.lower.equals(b1.lower)) {
            return new IntBound(IntConst.valueOf(s, eq));
        }
        if (b0.intersection(b1) == null) {
            return new IntBound(IntConst.valueOf(s, 1 - eq));
        }
        return new IntBound(IntConst.valueOf(s, 0L), IntConst.valueOf(s, 1L));
    }

    private static IntBound cmpu(IntBound b0, IntBound b1, int s, int lt) {
        if (b0.size() != b1.size()) {
            throw new IllegalArgumentException(b0 + " " + b1);
        }
        if (b0.lower.compareTo(b0.upper) <= 0 && b1.lower.compareTo(b1.upper) <= 0) {
            if (b0.upper.compareTo(b1.lower) < 0) {
                return new IntBound(IntConst.valueOf(s, lt));
            }
            if (b0.lower.compareTo(b1.upper) >= 0) {
                return new IntBound(IntConst.valueOf(s, 1 - lt));
            }
        }
        return new IntBound(IntConst.valueOf(s, 0L), IntConst.valueOf(s, 1L));
    }

    private static IntBound cmps(IntBound b0, IntBound b1, int s, int lt) {
        if (b0.size() != b1.size()) {
            throw new IllegalArgumentException(b0 + " " + b1);
        }
        if (b0.lower.signedCompareTo(b0.upper) <= 0 && b1.lower.signedCompareTo(b1.upper) <= 0) {
            if (b0.upper.signedCompareTo(b1.lower) < 0) {
                return new IntBound(IntConst.valueOf(s, lt));
            }
            if (b0.lower.signedCompareTo(b1.upper) >= 0) {
                return new IntBound(IntConst.valueOf(s, 1 - lt));
            }
        }
        return new IntBound(IntConst.valueOf(s, 0L), IntConst.valueOf(s, 1L));
    }

    public IntBound convzx(int s) {
        if (s == this.size()) {
            return this;
        }
        if (s < this.size()) {
            throw new IllegalArgumentException(this + " " + s);
        }
        IntConst l = this.lower;
        IntConst u = this.upper;
        if (l.compareTo(u) > 0) {
            l = IntConst.valueOf(this.size(), 0L);
            u = l.bnot();
        }
        return new IntBound(l.convzx(s), u.convzx(s));
    }

    public IntBound convsx(int s) {
        if (s == this.size()) {
            return this;
        }
        if (s < this.size()) {
            throw new IllegalArgumentException(this + " " + s);
        }
        IntConst l = this.lower;
        IntConst u = this.upper;
        if (l.signedCompareTo(u) > 0) {
            l = IntConst.valueOf(this.size(), 1L).lsh(this.size() - 1);
            u = l.bnot();
        }
        return new IntBound(l.convsx(s), u.convsx(s));
    }

    public IntBound convit(int s) {
        IntConst u;
        IntConst l;
        if (s == this.size()) {
            return this;
        }
        if (s > this.size() || s <= 0) {
            throw new IllegalArgumentException(this + " " + s);
        }
        IntConst r = this.upper.sub(this.lower);
        if (r.compareTo(IntConst.valueOf(this.size(), 1L).lsh(s)) >= 0) {
            l = IntConst.valueOf(s, 0L);
            u = l.bnot();
        } else {
            l = this.lower.convit(s);
            u = this.upper.convit(s);
        }
        return new IntBound(l, u);
    }

    public IntBound ifthenelse(IntBound t, IntBound f) {
        if (t.size() != f.size()) {
            throw new IllegalArgumentException(this + " " + t + ' ' + f);
        }
        if (this.lower.signum() == 0 && this.lower.equals(this.upper)) {
            return t;
        }
        if (!this.contains(IntConst.valueOf(this.size(), 0L))) {
            return f;
        }
        return t.union(f);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof IntBound && this.lower.equals(((IntBound)o).lower) && this.upper.equals(((IntBound)o).upper);
    }

    public int hashCode() {
        return this.lower.hashCode() * 37 + this.upper.hashCode();
    }

    public String toString() {
        return "(" + this.lower.bigValue() + ".." + this.upper.bigValue() + "):" + this.size();
    }
}

