/*
 * Decompiled with CFR 0.152.
 */
package coins.sym;

import coins.IoRoot;
import coins.SourceLanguage;
import coins.SymRoot;
import coins.sym.BoolConstImpl;
import coins.sym.CharConstImpl;
import coins.sym.Elem;
import coins.sym.ElemImpl;
import coins.sym.ExpId;
import coins.sym.ExpIdImpl;
import coins.sym.FloatConstImpl;
import coins.sym.IntConstImpl;
import coins.sym.Label;
import coins.sym.LabelImpl;
import coins.sym.NamedConstImpl;
import coins.sym.Param;
import coins.sym.ParamImpl;
import coins.sym.StringConstImpl;
import coins.sym.Subp;
import coins.sym.SubpImpl;
import coins.sym.Sym;
import coins.sym.SymImpl;
import coins.sym.SymInf;
import coins.sym.SymIterator;
import coins.sym.SymIteratorImpl;
import coins.sym.SymNestIterator;
import coins.sym.SymNestIteratorImpl;
import coins.sym.SymTable;
import coins.sym.SymTableEntry;
import coins.sym.SymTableEntryImpl;
import coins.sym.SymTableIterator;
import coins.sym.SymTableIteratorImpl;
import coins.sym.Type;
import coins.sym.TypeImpl;
import coins.sym.Var;
import coins.sym.VarImpl;

public class SymTableImpl
implements SymTable {
    private static final int hashTableSize = 499;
    public final SymRoot symRoot;
    public final IoRoot ioRoot;
    public String fTableName = null;
    private SymTable tableParent = null;
    private SymTable tableBrother = null;
    private SymTable tableFirstChild = null;
    private SymTable tableLastChild = null;
    protected Sym firstSym = null;
    protected Sym lastSym = null;
    protected Sym ownerSym = null;
    private int count = 0;
    private int threshold;
    private SymTableEntry[] fEntries;
    protected final int fDbgLevel;

    public SymTableImpl(SymRoot pSymRoot) {
        this.symRoot = pSymRoot;
        this.ioRoot = pSymRoot.ioRoot;
        this.fEntries = new SymTableEntry[499];
        this.threshold = 374;
        this.fDbgLevel = this.ioRoot.dbgSym.getLevel();
    }

    public SymTable pushSymTable(Sym pOwner) {
        SymTableImpl lTableNew = new SymTableImpl(this.symRoot);
        lTableNew.tableParent = this;
        lTableNew.ownerSym = pOwner;
        if (this.tableLastChild == null) {
            this.tableFirstChild = lTableNew;
        } else {
            ((SymTableImpl)this.tableLastChild).tableBrother = lTableNew;
        }
        this.tableLastChild = lTableNew;
        if (pOwner instanceof Subp) {
            ((Subp)pOwner).setSymTable(lTableNew);
            this.symRoot.subpCurrent = (Subp)pOwner;
            this.symRoot.symTableCurrentSubp = lTableNew;
        }
        this.symRoot.symTableCurrent = lTableNew;
        if (this.fDbgLevel > 2) {
            this.ioRoot.dbgSym.print(3, "pushSymTable", this.symRoot.symTableCurrent.toString());
        }
        return lTableNew;
    }

    public SymTable popSymTable() {
        if (this.tableParent != null) {
            this.symRoot.symTableCurrent = this.tableParent;
        }
        if (this.symRoot.symTableCurrent == this.symRoot.symTableRoot) {
            this.symRoot.symTableCurrentSubp = null;
        } else if (this.symRoot.symTableCurrent == null) {
            this.symRoot.symTableCurrentSubp = null;
            return this.symRoot.symTableRoot;
        }
        if (this.symRoot.symTableCurrent.getOwner() instanceof Subp) {
            this.symRoot.subpCurrent = (Subp)this.symRoot.symTableCurrent.getOwner();
            this.symRoot.symTableCurrentSubp = this.symRoot.symTableCurrent;
        }
        if (this.fDbgLevel > 2) {
            this.ioRoot.dbgSym.print(3, "popSymTable", IoRoot.toStringObject(this.symRoot.symTableCurrent));
        }
        return this.symRoot.symTableCurrent;
    }

    public SymTable reopenSymTable(SymTable pPreviousSymTable) {
        if (pPreviousSymTable != null) {
            this.symRoot.symTableCurrent = pPreviousSymTable;
            if (this.fDbgLevel > 2) {
                this.ioRoot.dbgSym.print(3, "reopenSymTable", this.symRoot.symTableCurrent.toString());
            }
            return this.symRoot.symTableCurrent;
        }
        return this;
    }

    public SymTable getParent() {
        return this.tableParent;
    }

    public SymTable getFirstChild() {
        return this.tableFirstChild;
    }

    public SymTable getBrother() {
        return this.tableBrother;
    }

    public Sym defineUnique(String pInternedName, int pSymKind, Sym pDefinedIn) {
        Sym lSym = this.searchLocal(pInternedName, pSymKind, true);
        if (lSym == null || lSym.getSymKind() == 0) {
            return this.searchOrAdd(pInternedName, pSymKind, pDefinedIn, true, true);
        }
        if (this.ioRoot.dbgSym.getLevel() > 0) {
            this.ioRoot.msgRecovered.put(1010, "double definition of " + pInternedName);
        }
        return null;
    }

    public Sym define(String pInternedName, int pSymKind, Sym pDefinedIn) {
        return this.searchOrAdd(pInternedName, pSymKind, pDefinedIn, false, true);
    }

    public Sym search(String pInternedName) {
        SymTableEntry[] ent = this.fEntries;
        SymTableImpl lCurrent = this;
        while (lCurrent != null) {
            Sym lSym = lCurrent.searchLocal(pInternedName, 0, false);
            if (lSym != null) {
                return lSym;
            }
            SymTableImpl lParent = (SymTableImpl)lCurrent.tableParent;
            if (lParent != lCurrent) {
                lCurrent = lParent;
                continue;
            }
            lCurrent = null;
        }
        return null;
    }

    public Sym searchLocal(String pInternedName, int pSymKind, boolean pSpecifiedKind) {
        if (pInternedName == null) {
            return null;
        }
        SymTableEntry[] ent = this.fEntries;
        Sym currSym = null;
        int index = (System.identityHashCode(pInternedName) & Integer.MAX_VALUE) % ent.length;
        SymTableEntry lSearchEntry = ent[index];
        while (lSearchEntry != null) {
            if (((SymTableEntryImpl)lSearchEntry).key == pInternedName) {
                currSym = ((SymTableEntryImpl)lSearchEntry).value;
                if (currSym.isRemoved()) {
                    currSym = null;
                } else {
                    if (!pSpecifiedKind || ((SymTableEntryImpl)lSearchEntry).value.getSymKind() == pSymKind) break;
                    currSym = null;
                    break;
                }
            }
            lSearchEntry = ((SymTableEntryImpl)lSearchEntry).next;
        }
        return currSym;
    }

    public SymTableEntry searchLocalEntry(String pInternedName, int pSymKind, boolean pSpecifiedKind) {
        if (pInternedName == null) {
            return null;
        }
        SymTableEntry[] ent = this.fEntries;
        Sym currSym = null;
        SymTableEntry lEntry = null;
        int index = (System.identityHashCode(pInternedName) & Integer.MAX_VALUE) % ent.length;
        SymTableEntry lSearchEntry = ent[index];
        while (lSearchEntry != null) {
            lEntry = lSearchEntry;
            if (((SymTableEntryImpl)lSearchEntry).key == pInternedName) {
                currSym = ((SymTableEntryImpl)lSearchEntry).value;
                if (currSym.isRemoved()) {
                    lEntry = null;
                } else {
                    if (!pSpecifiedKind || ((SymTableEntryImpl)lSearchEntry).value.getSymKind() == pSymKind) break;
                    lEntry = null;
                    break;
                }
            }
            lSearchEntry = ((SymTableEntryImpl)lSearchEntry).next;
        }
        return lEntry;
    }

    public Sym searchOrAdd(String pInternedName, int pSymKind, Sym pDefinedIn, boolean pWithinThisTable, boolean pSpecifiedKind) {
        SymImpl newSym;
        if (pInternedName == null) {
            return null;
        }
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgSym.print(7, "searchOrAdd", pInternedName + " " + pSymKind + " " + pWithinThisTable + " " + pSpecifiedKind);
        }
        if (pSymKind >= 2 && pSymKind <= 7 && this != this.symRoot.symTableConst) {
            if (this.symRoot.symTableConst == null) {
                this.symRoot.symTableConst = new SymTableImpl(this.symRoot);
            }
            return ((SymTableImpl)this.symRoot.symTableConst).searchOrAdd(pInternedName, pSymKind, null, true, true);
        }
        if (pSymKind == 13 && this != this.symRoot.symTableRoot && this.symRoot.symTableCurrentSubp != null && this != this.symRoot.symTableCurrentSubp) {
            return ((SymTableImpl)this.symRoot.symTableCurrentSubp).searchOrAdd(pInternedName, pSymKind, pDefinedIn, pWithinThisTable, pSpecifiedKind);
        }
        SymTableEntry[] ent = this.fEntries;
        int hash = System.identityHashCode(pInternedName);
        int index = (hash & Integer.MAX_VALUE) % ent.length;
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgSym.print(7, "index " + index);
        }
        Sym currSym = null;
        SymTableEntry lSearchEntry = ent[index];
        while (lSearchEntry != null) {
            if (((SymTableEntryImpl)lSearchEntry).key == pInternedName) {
                currSym = ((SymTableEntryImpl)lSearchEntry).value;
                if (currSym.getSymKind() == 0) {
                    currSym = null;
                } else {
                    if (pSpecifiedKind && currSym.getSymKind() != pSymKind && currSym.getSymKind() != 1) {
                        if (SourceLanguage.REDEFINABLE[currSym.getSymKind()][pSymKind] == 0) {
                            this.ioRoot.msgRecovered.put(1010, "Symbol " + currSym.getName() + " of kind " + Sym.KIND_NAME[currSym.getSymKind()] + " can not be redefined as " + Sym.KIND_NAME[pSymKind]);
                        }
                        currSym = null;
                    }
                    if (currSym != null) break;
                }
            }
            lSearchEntry = ((SymTableEntryImpl)lSearchEntry).next;
        }
        if (currSym == null && !pWithinThisTable && this.tableParent != null) {
            if (this.fDbgLevel > 3) {
                this.ioRoot.dbgSym.print(7, "look parent");
            }
            SymTableImpl lTable = (SymTableImpl)this.tableParent;
            while (lTable != null && (currSym = lTable.searchLocal(pInternedName, pSymKind, pSpecifiedKind)) == null) {
                lTable = (SymTableImpl)lTable.tableParent;
            }
        }
        if (currSym != null) {
            if (this.fDbgLevel > 3) {
                this.ioRoot.dbgSym.print(7, " Found " + currSym.getSymKind());
            }
            return currSym;
        }
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgSym.print(7, " Not found " + pSymKind);
        }
        switch (pSymKind) {
            case 2: {
                newSym = new BoolConstImpl(this.symRoot, pInternedName);
                break;
            }
            case 3: {
                newSym = new CharConstImpl(this.symRoot, pInternedName, this.symRoot.typeChar);
                break;
            }
            case 4: {
                newSym = new IntConstImpl(this.symRoot, pInternedName, this.symRoot.typeInt);
                break;
            }
            case 5: {
                newSym = new FloatConstImpl(this.symRoot, pInternedName, this.symRoot.typeFloat);
                break;
            }
            case 6: {
                newSym = new StringConstImpl(this.symRoot, pInternedName);
                break;
            }
            case 7: {
                newSym = new NamedConstImpl(this.symRoot, pInternedName, 0);
                break;
            }
            case 8: {
                newSym = new VarImpl(this.symRoot, pInternedName);
                break;
            }
            case 9: {
                newSym = new ParamImpl(this.symRoot, pInternedName, pDefinedIn);
                break;
            }
            case 10: {
                newSym = new ElemImpl(this.symRoot, pInternedName, pDefinedIn);
                break;
            }
            case 12: {
                newSym = new SubpImpl(this.symRoot, pInternedName, null, pDefinedIn);
                break;
            }
            case 13: {
                newSym = new TypeImpl(this.symRoot);
                ((TypeImpl)newSym).fName = pInternedName;
                break;
            }
            case 14: {
                newSym = new LabelImpl(this.symRoot, pInternedName, pDefinedIn);
                break;
            }
            case 17: {
                newSym = new ExpIdImpl(this.symRoot, pInternedName, pDefinedIn);
                break;
            }
            case 1: {
                newSym = new SymImpl(this.symRoot, pInternedName);
                break;
            }
            case 15: {
                newSym = null;
                break;
            }
            case 16: {
                newSym = null;
                break;
            }
            default: {
                newSym = new SymImpl(this.symRoot, pInternedName);
                ((SymImpl)newSym).setSymKind(pSymKind);
            }
        }
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgSym.print(7, " newSym " + newSym.getName());
        }
        if (this.count >= this.threshold) {
            this.rehash();
            ent = this.fEntries;
            index = (hash & Integer.MAX_VALUE) % ent.length;
        }
        SymTableEntryImpl lEntry2 = new SymTableEntryImpl(pInternedName, newSym, ent[index]);
        ent[index] = lEntry2;
        ++this.count;
        this.linkSym(newSym);
        newSym.setDefinedIn(pDefinedIn);
        return newSym;
    }

    public SymTableEntry searchOrAddEntry(String pInternedName, int pSymKind, Sym pDefinedIn, boolean pWithinThisTable, boolean pSpecifiedKind) {
        Object lEntry = null;
        if (pInternedName == null) {
            return null;
        }
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgSym.print(6, "searchOrAddEntry", pInternedName + " " + pSymKind + " " + pWithinThisTable + " " + pSpecifiedKind);
        }
        if (pSymKind >= 2 && pSymKind <= 7 && this != this.symRoot.symTableConst) {
            if (this.symRoot.symTableConst == null) {
                this.symRoot.symTableConst = new SymTableImpl(this.symRoot);
            }
            return ((SymTableImpl)this.symRoot.symTableConst).searchOrAddEntry(pInternedName, pSymKind, null, true, true);
        }
        SymTableEntry[] ent = this.fEntries;
        int hash = System.identityHashCode(pInternedName);
        int index = (hash & Integer.MAX_VALUE) % ent.length;
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgSym.print(6, " index " + index);
        }
        Object currSym = null;
        SymTableEntry lEntry1 = ent[index];
        while (lEntry1 != null) {
            if (!(((SymTableEntryImpl)lEntry1).key != pInternedName || pSpecifiedKind && ((SymTableEntryImpl)lEntry1).value.getSymKind() != pSymKind)) {
                if (this.fDbgLevel > 3) {
                    this.ioRoot.dbgSym.print(6, " Found.  " + pSymKind);
                }
                return lEntry1;
            }
            lEntry1 = ((SymTableEntryImpl)lEntry1).next;
        }
        if (!pWithinThisTable) {
            if (this.fDbgLevel > 3) {
                this.ioRoot.dbgSym.print(6, " Look parent.");
            }
            SymTable lTable = this.tableParent;
            while (lTable != null) {
                SymTableEntry lEntry2 = ((SymTableImpl)lTable).searchLocalEntry(pInternedName, pSymKind, pSpecifiedKind);
                if (lEntry2 != null && ((SymTableEntryImpl)lEntry2).value.getSymKind() != 0) {
                    if (this.fDbgLevel > 3) {
                        this.ioRoot.dbgSym.print(6, " Found.  " + pSymKind);
                    }
                    return lEntry2;
                }
                lTable = ((SymTableImpl)lTable).tableParent;
            }
        }
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgSym.print(6, " Not found , and define " + pSymKind);
        }
        if (this.count >= this.threshold) {
            this.rehash();
            ent = this.fEntries;
            index = (hash & Integer.MAX_VALUE) % ent.length;
        }
        SymTableEntryImpl lEntry3 = new SymTableEntryImpl(pInternedName, null, ent[index]);
        ent[index] = lEntry3;
        ++this.count;
        return lEntry3;
    }

    public void linkSym(Sym pNewSym) {
        if (this.lastSym == null) {
            this.firstSym = pNewSym;
            this.lastSym = pNewSym;
        } else {
            ((SymImpl)this.lastSym).fNextSym = pNewSym;
            this.lastSym = pNewSym;
        }
        pNewSym.setRecordedIn(this);
    }

    public Sym searchSymOfThisKind(Sym pSym, int pSymKind) {
        SymTableEntry[] ent = this.fEntries;
        String lName = pSym.getName();
        int index = (System.identityHashCode(lName) & Integer.MAX_VALUE) % ent.length;
        SymTableImpl lCurrent = (SymTableImpl)this.symRoot.symTableCurrent;
        while (lCurrent != null) {
            Sym lSym = lCurrent.searchLocal(lName, pSymKind, true);
            if (lSym != null) {
                return lSym;
            }
            lCurrent = (SymTableImpl)lCurrent.tableParent;
        }
        return null;
    }

    public Sym redefine(Sym pSym, int pSymKind, Sym pDefinedIn) {
        String lName = pSym.getName();
        return this.searchOrAdd(lName, pSymKind, pDefinedIn, true, true);
    }

    private void rehash() {
        int oldSize = this.fEntries.length;
        int newSize = (oldSize << 1) + 1;
        SymTableEntry[] oldEnt = this.fEntries;
        SymTableEntry[] newEnt = new SymTableEntry[newSize];
        this.threshold = newSize * 3 >> 2;
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgSym.print(4, "rehash " + this.toString(), "oldSize " + oldSize + " newSize " + newSize + " threshold " + this.threshold);
        }
        this.fEntries = newEnt;
        int i = oldSize;
        while (i-- > 0) {
            SymTableEntry old = oldEnt[i];
            while (old != null) {
                SymTableEntry lEntry = old;
                old = ((SymTableEntryImpl)old).next;
                if (((SymTableEntryImpl)lEntry).value != null) {
                    if (((SymTableEntryImpl)lEntry).value.getSymKind() == 0) continue;
                    int index = (System.identityHashCode(((SymTableEntryImpl)lEntry).key) & Integer.MAX_VALUE) % newSize;
                    ((SymTableEntryImpl)lEntry).next = newEnt[index];
                    newEnt[index] = lEntry;
                    continue;
                }
                this.ioRoot.dbgSym.print(1, " NULL in rehash " + this.toString());
            }
        }
    }

    public SymTable subpSymTable() {
        SymTable lSymTable;
        for (lSymTable = this; lSymTable != null && lSymTable.getOwner() != null && lSymTable.getOwner().getSymKind() != 12; lSymTable = lSymTable.getParent()) {
        }
        if (lSymTable == null || lSymTable.getOwner() == null || lSymTable.getOwner().getSymKind() != 12) {
            lSymTable = this.symRoot.symTableRoot;
        }
        return lSymTable;
    }

    public Var generateVar(Type pType) {
        SymTable lSymTable = this.subpSymTable();
        if (lSymTable == null) {
            lSymTable = this.symRoot.symTableRoot;
        }
        return lSymTable.generateVar(pType, this.symRoot.subpCurrent);
    }

    public Var generateVar(Type pType, Sym pDefinedIn) {
        SymTable lSymTable = this.subpSymTable();
        while (this.symRoot.conflictingSpecialSyms.contains(("_var" + this.symRoot.incrementVarCount()).intern())) {
        }
        VarImpl varSym = (VarImpl)lSymTable.searchOrAdd(("_var" + this.symRoot.getVarCount()).intern(), 8, pDefinedIn, true, true);
        varSym.fType = pType;
        varSym.setFlag(2, true);
        this.symRoot.incrementVarCount();
        return varSym;
    }

    public Param generateParam(Type pType, Sym pDefinedIn) {
        SymTable lSymTable = this.subpSymTable();
        while (this.symRoot.conflictingSpecialSyms.contains(("_param" + this.symRoot.incrementParamCount()).intern())) {
        }
        ParamImpl lParamSym = (ParamImpl)lSymTable.searchOrAdd(("_param" + this.symRoot.getParamCount()).intern(), 9, pDefinedIn, true, true);
        lParamSym.fType = pType;
        lParamSym.setFlag(2, true);
        return lParamSym;
    }

    public Elem generateElem(Type pType, Sym pDefinedIn) {
        while (this.symRoot.conflictingSpecialSyms.contains(("_elem" + this.symRoot.incrementElemCount()).intern())) {
        }
        ElemImpl lElemSym = (ElemImpl)this.searchOrAdd(("_elem" + this.symRoot.getElemCount()).intern(), 10, pDefinedIn, true, true);
        lElemSym.fType = pType;
        lElemSym.setFlag(2, true);
        return lElemSym;
    }

    public Label generateLabel() {
        SymTable lSymTable = this.subpSymTable();
        while (this.symRoot.conflictingSpecialSyms.contains(("_lab" + this.symRoot.incrementLabelCount()).intern())) {
        }
        LabelImpl lLabelSym = (LabelImpl)lSymTable.searchOrAdd(("_lab" + this.symRoot.getLabelCount()).intern(), 14, null, true, true);
        lLabelSym.setFlag(2, true);
        return lLabelSym;
    }

    public Sym generateTag() {
        String lTagName;
        SymTable lSymTable = this.subpSymTable();
        while (this.symRoot.conflictingSpecialSyms.contains(lTagName = ("_tag" + this.symRoot.incrementSymCount()).intern())) {
        }
        Sym lTag = lSymTable.searchOrAdd(lTagName, 11, null, true, true);
        lTag.setFlag(2, true);
        return lTag;
    }

    public Sym generateTag(String pTagName) {
        SymTableImpl lSymTable = this;
        Sym lTag = lSymTable.searchOrAdd(pTagName, 11, null, true, true);
        lTag.setFlag(2, true);
        return lTag;
    }

    public Sym generateSym(Type pType, int pSymKind, String pPrefix, Sym pDefinedIn) {
        SymTable lSymTable = this.subpSymTable();
        String lPrefix = "_" + pPrefix;
        while (this.symRoot.conflictingSpecialSyms.contains((lPrefix + this.symRoot.incrementSymCount()).intern())) {
        }
        SymImpl lSym = (SymImpl)lSymTable.searchOrAdd((lPrefix + this.symRoot.getSymCount()).intern(), pSymKind, pDefinedIn, true, false);
        lSym.fType = pType;
        lSym.setFlag(2, true);
        return lSym;
    }

    public Sym generateDerivedSym(Sym pBaseSym) {
        SymInf lSymInf = pBaseSym.getOrAddInf();
        String lBaseName = "_" + pBaseSym.getName() + "_";
        while (this.symRoot.conflictingSpecialSyms.contains((lBaseName + lSymInf.incrementDerivedSymCount()).intern())) {
        }
        SymImpl lSym = (SymImpl)this.searchOrAdd((lBaseName + lSymInf.getDerivedSymCount()).intern(), pBaseSym.getSymKind(), null, true, false);
        lSym.fType = pBaseSym.getSymType();
        lSym.setFlag(1, true);
        lSym.setFlag(2, true);
        return lSym;
    }

    public String generateSymName(String pHeader) {
        String lSymName = "";
        for (int i = 0; i < 1000 && this.search(lSymName = (pHeader + "_" + i).intern()) != null; ++i) {
        }
        return lSymName;
    }

    public SymIterator getSymIterator() {
        return new SymIteratorImpl(this);
    }

    public SymNestIterator getSymNestIterator() {
        return new SymNestIteratorImpl(this);
    }

    public SymTableIterator getSymTableIterator() {
        return new SymTableIteratorImpl(this);
    }

    public Sym getFirstSym() {
        Sym lSym;
        for (lSym = this.firstSym; lSym != null && lSym.isRemoved(); lSym = lSym.getNextSym()) {
        }
        return lSym;
    }

    public boolean isInThisSymTable(Sym pSym) {
        if (pSym == null) {
            return false;
        }
        return this.searchLocal(pSym.getName().intern(), pSym.getSymKind(), true) != null;
    }

    public String toString() {
        String lString = "";
        if (this.fTableName != null && this.fTableName != "") {
            lString = this.fTableName;
        } else if (this.ownerSym != null) {
            lString = this.ownerSym.getName();
        } else if (this == this.symRoot.symTableConst) {
            lString = "Const";
        }
        return "SymTable " + lString;
    }

    public void printSymTableAll(SymTable pSymTable) {
        if (pSymTable == null) {
            return;
        }
        pSymTable.printSymTable();
        this.printSymTableAll(((SymTableImpl)pSymTable).tableFirstChild);
        this.printSymTableAll(((SymTableImpl)pSymTable).tableBrother);
    }

    public void printSymTableAllDetail() {
        this.symRoot.symTable.printSymTableAllDetail(this.symRoot.symTableRoot);
        this.symRoot.symTableConst.printSymTableDetail();
        if (this.fDbgLevel > 2) {
            SymTable lSymTable = this.symRoot.symTableUnique;
            this.ioRoot.printOut.print("\n\nsymTableUnique\n");
            Sym lSym = lSymTable.getFirstSym();
            while (lSym != null) {
                if (lSym.getOriginalSym() != lSym) {
                    String lDefinedInName = lSym.getOriginalSym().getDefinedInName();
                    lDefinedInName = lDefinedInName != null && lDefinedInName != "" ? " in " + lDefinedInName : "";
                    this.ioRoot.printOut.print("\n  " + lSym.toStringDetail() + " original " + lSym.getOriginalSym().getName() + lDefinedInName);
                }
                lSym = ((SymImpl)lSym).fNextSym;
            }
        }
    }

    public void printSymTableAllDetail(SymTable pSymTable) {
        if (pSymTable == null) {
            return;
        }
        pSymTable.printSymTableDetail();
        this.printSymTableAllDetail(((SymTableImpl)pSymTable).tableFirstChild);
        this.printSymTableAllDetail(((SymTableImpl)pSymTable).tableBrother);
    }

    public void printSymTable() {
        String lString = this.toString();
        if (this.tableParent != null) {
            lString = lString + " parent " + this.tableParent.toString();
        }
        this.ioRoot.printOut.print("\n" + lString + "\n");
        Sym lSym = this.firstSym;
        while (lSym != null) {
            if (!(lSym instanceof ExpId)) {
                this.ioRoot.printOut.print("\n  " + lSym.toString());
            }
            if (lSym.isRemoved()) {
                this.ioRoot.printOut.print(" REMOVED ");
            }
            lSym = ((SymImpl)lSym).fNextSym;
        }
        this.ioRoot.printOut.print("\n");
    }

    public void printSymTableDetail() {
        String lString = this.toString();
        if (this.tableParent != null) {
            lString = lString + " parent " + this.tableParent.toString();
        }
        if (this.getSubp() != null) {
            lString = lString + " subp " + this.getSubp().toString();
        }
        this.ioRoot.printOut.print("\n" + lString + "\n");
        Sym lSym = this.firstSym;
        while (lSym != null) {
            if (!(lSym instanceof ExpId) || this.ioRoot.dbgSym.getLevel() >= 2) {
                this.ioRoot.printOut.print("\n  " + lSym.toStringDetail());
                if (this.ioRoot.dbgSym.getLevel() > 6) {
                    if (lSym.getRecordedIn() != null) {
                        this.ioRoot.printOut.print(" owner " + lSym.getRecordedIn().getOwnerName());
                    } else {
                        this.ioRoot.printOut.print(" owner not given");
                    }
                }
            }
            if (lSym.isRemoved()) {
                this.ioRoot.printOut.print(" REMOVED ");
            }
            lSym = ((SymImpl)lSym).fNextSym;
        }
    }

    public Sym getOwner() {
        return this.ownerSym;
    }

    public String getOwnerName() {
        if (this.ownerSym != null) {
            return this.ownerSym.getName();
        }
        return "null";
    }

    public Subp getSubp() {
        for (SymTable lSymTable = this; lSymTable != null && lSymTable.getOwner() != null; lSymTable = lSymTable.getParent()) {
            if (lSymTable.getOwner().getSymKind() != 12) continue;
            return (Subp)lSymTable.getOwner();
        }
        return null;
    }

    public int getSymCount() {
        return this.count;
    }

    private int getHashIndex(String name) {
        return (System.identityHashCode(name) & Integer.MAX_VALUE) % this.fEntries.length;
    }

    private void newEntry(Sym s) {
        if (this.count++ >= this.threshold) {
            this.rehash();
        }
        String name = s.getName();
        int index = this.getHashIndex(name);
        SymTableEntryImpl e = new SymTableEntryImpl(name, s, this.fEntries[index]);
        this.fEntries[index] = e;
        this.linkSym(s);
    }

    public Sym searchOrAddSym(Sym s) {
        if (s == null) {
            return null;
        }
        Sym old = this.searchLocal(s.getName(), s.getSymKind());
        if (old != null) {
            if (this.fDbgLevel > 3) {
                this.ioRoot.dbgToHir.print(9, "old", "" + s);
            }
            return old;
        }
        this.newEntry(s);
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgToHir.print(9, "new", "" + s);
        }
        return s;
    }

    public Sym search(String pName, int symkind) {
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgSym.print(8, "search ", pName + " ");
        }
        for (SymTable t = this; t != null; t = t.getParent()) {
            Sym s = t.searchLocal(pName, symkind);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    public Sym searchLocal(String pName, int symkind) {
        if (this.fDbgLevel > 3) {
            this.ioRoot.dbgSym.print(8, "searchLocal ", pName + " ");
        }
        if (pName == null) {
            return null;
        }
        SymTableEntryImpl e = (SymTableEntryImpl)this.fEntries[this.getHashIndex(pName)];
        while (e != null) {
            if (e.key == pName && e.value.getSymKind() == symkind) {
                return e.value;
            }
            e = (SymTableEntryImpl)e.next;
        }
        return null;
    }

    public SymTable searchTableHaving(Sym s) {
        if (s == null) {
            return null;
        }
        String name = s.getName();
        int symkind = s.getSymKind();
        for (SymTable t = this; t != null; t = t.getParent()) {
            if (t.searchLocal(name, symkind) == null) continue;
            return t;
        }
        return this.symRoot.symTableRoot;
    }

    public String makeNewName(String pOldName, String lSubpName, int index) {
        String lNewName;
        if (lSubpName == "") {
            lNewName = pOldName;
        } else {
            lNewName = lSubpName.concat("_");
            lNewName = lNewName.concat(pOldName);
        }
        if (index == 0) {
            return lNewName.intern();
        }
        lNewName = lNewName.concat("_");
        String sindex = String.valueOf(index);
        lNewName = lNewName.concat(sindex);
        return lNewName.intern();
    }

    public String generateUniqueName(Sym pOldSym, Subp pSubp) {
        SymTableImpl lSymTable = this;
        String lOldName = pOldSym.getName();
        int lSymKind = pOldSym.getSymKind();
        int index = 0;
        String lSubpName = pSubp != null ? pSubp.getName() : "";
        String lNewName = this.makeNewName(lOldName, lSubpName, index);
        while (this.symRoot.symTableUnique.searchLocal(lNewName, lSymKind, false) != null) {
            lNewName = this.makeNewName(lOldName, lSubpName, ++index);
        }
        return lNewName.intern();
    }

    public String generateConstName(Sym pOldSym, int index) {
        String sindex = String.valueOf(index);
        String lNewName = "const_".concat(sindex);
        return lNewName.intern();
    }

    public void setUniqueNameToAllSym() {
        SymIterator lIterator;
        SymTable lSymTable = this;
        int index = 0;
        this.ioRoot.dbgSym.print(1, "setUniqueNameToAllSym", " ");
        if (this.ioRoot.dbgSym.getLevel() >= 5) {
            this.ioRoot.dbgSym.print(4, "SymTables", "before generation");
            this.symRoot.symTable.printSymTableAllDetail(this.symRoot.symTableRoot);
        }
        SymTableIterator lSymTableIterator = this.symRoot.symTableRoot.getSymTableIterator();
        while (lSymTableIterator.hasNext()) {
            lSymTable = lSymTableIterator.next();
            if (lSymTable == null) continue;
            Subp lSubp = lSymTable.getSubp();
            if (this.fDbgLevel > 3) {
                this.ioRoot.dbgSym.print(4, " ", IoRoot.toStringObject(lSymTable));
            }
            lIterator = lSymTable.getSymIterator();
            block4: while (lIterator.hasNext()) {
                Sym lSym = lIterator.next();
                if (((SymImpl)lSym).fUniqueNameSym != null || lSym.getSymKind() == 0) continue;
                int lSymKind = lSym.getSymKind();
                switch (lSymKind) {
                    case 8: 
                    case 9: 
                    case 12: 
                    case 14: {
                        String lUniqueName = this.generateUniqueName(lSym, lSubp);
                        if (lUniqueName == lSym.getName()) continue block4;
                        Sym lUniqueSym = this.symRoot.symTableUnique.searchOrAdd(lUniqueName, 1, null, false, false);
                        ((SymImpl)lSym).setUniqueNameSym(lUniqueSym);
                        continue block4;
                    }
                }
            }
        }
        lIterator = this.symRoot.symTableConst.getSymIterator();
        while (lIterator.hasNext()) {
            Sym lSym1 = lIterator.next();
            int lSymKindConst = 1;
            String lConstName = this.generateConstName(lSym1, ++index);
            while (this.symRoot.symTableUnique.searchLocal(lConstName, 1, false) != null) {
                lConstName = this.generateConstName(lSym1, ++index);
            }
            Sym lUniqueNameConst = this.symRoot.symTableUnique.searchOrAdd(lConstName, lSymKindConst, null, true, false);
            if (lConstName == lSym1.getName()) continue;
            ((SymImpl)lSym1).setUniqueNameSym(lUniqueNameConst);
        }
        if (this.ioRoot.dbgSym.getLevel() >= 2) {
            this.symRoot.symTable.printSymTableAllDetail(this.symRoot.symTableRoot);
            this.symRoot.symTable.printSymTableAllDetail(this.symRoot.symTableConst);
            if (this.ioRoot.dbgSym.getLevel() >= 5) {
                this.ioRoot.dbgSym.print(2, "Print", "SymTableUnique");
                this.symRoot.symTable.printSymTableAllDetail(this.symRoot.symTableUnique);
            }
        }
    }
}

