/*
 * Decompiled with CFR 0.152.
 */
package coins.sym;

import coins.SymRoot;
import coins.ir.IrList;
import coins.ir.hir.Exp;
import coins.sym.Elem;
import coins.sym.StructType;
import coins.sym.Sym;
import coins.sym.SymImpl;
import coins.sym.SymTable;
import coins.sym.Type;
import coins.sym.TypeImpl;
import java.util.ListIterator;

public class StructTypeImpl
extends TypeImpl
implements StructType {
    protected IrList fElemList = null;
    protected SymTable fLocalSymTable;
    protected Sym fTag;
    protected int fAlignment;

    public StructTypeImpl(SymRoot pSymRoot, String pTypeName, IrList pElemList) {
        super(pSymRoot);
        this.fKind = 13;
        this.fType = this;
        this.fTypeKind = 24;
        this.fAlignment = Type.KIND_ALIGNMENT[24];
        if (pElemList == null) {
            this.fElemList = this.symRoot.getHirRoot().hir.irList(null);
            this.setFlag(11, true);
            this.fCompleteType = null;
        } else {
            this.fElemList = pElemList;
        }
        this.fName = pTypeName;
        if (pElemList != null) {
            this.finishStructType(false);
        } else {
            this.setFlag(12, false);
        }
    }

    public SymTable getSymTable() {
        return this.fLocalSymTable;
    }

    public void setSymTable(SymTable pSymTable) {
        this.fLocalSymTable = pSymTable;
    }

    public IrList getElemList() {
        return this.fElemList;
    }

    public void addElem(Elem pElem) {
        if (this.fElemList == null) {
            this.fElemList = this.symRoot.getHirRoot().hir.irList();
        }
        this.fElemList.add(pElem);
    }

    public void finishStructType(boolean pSeparately) {
        boolean lDispIncrementValue = false;
        Type lElemType = null;
        String lName = this.symRoot.sym.makeStructUnionTypeName(true, this.fElemList);
        if (this.fDbgLevel > 3) {
            this.symRoot.ioRoot.dbgSym.print(4, "finishStructType", this.getName() + " packedFromLeft " + machineParam.isPackedFromLeft());
        }
        long lSize = 0L;
        long lDisplacement = 0L;
        int lAlignment = 0;
        int lElemAlignment = 1;
        boolean lIncomplete = false;
        boolean lUniformSize = true;
        boolean lSizeIsSet = true;
        if (this.fElemList.isEmpty()) {
            lIncomplete = true;
            lUniformSize = false;
        }
        boolean lBitFieldBegin = false;
        long lBitOffsetFromStructOrg = 0L;
        long lCumulativeSizeInBits = 0L;
        int lBitFieldSumWithinWord = 0;
        boolean lPackedFromRight = machineParam.isPackedFromRight();
        int lCharSize = machineParam.evaluateSize(7);
        int lShortSize = machineParam.evaluateSize(3);
        int lIntSize = machineParam.evaluateSize(4);
        int lLongSize = machineParam.evaluateSize(5);
        int lCharBit = lCharSize * 8;
        int lShortBit = lShortSize * 8;
        int lIntBit = lIntSize * 8;
        int lLongBit = lLongSize * 8;
        int lMinimumByteForBitFieldSequence = machineParam.minimumByteForBitFieldSequence();
        long lContainingObjectDisplacement = 0L;
        ListIterator lElemIterator = this.fElemList.iterator();
        while (lElemIterator.hasNext()) {
            Elem lElem = (Elem)lElemIterator.next();
            if (lElem == null) continue;
            lElemType = lElem.getSymType();
            long lElemSize = lElemType.getSizeValue();
            if (lElem.isBitField()) {
                int lNewBitfieldSumWithinWord;
                int lBitOffset;
                int lBitFieldSize = lElem.getBitSize();
                int lElemTypeBit = (int)lElemSize * 8;
                if (lElemAlignment <= (int)lElemType.getSizeValue()) {
                    Type lAlignmentType = lElemType;
                    lElemAlignment = (int)lAlignmentType.getSizeValue();
                }
                if (!lBitFieldBegin) {
                    int lBitOffsetOfDisplacement;
                    lBitFieldBegin = true;
                    lBitOffset = lBitOffsetOfDisplacement = (int)(lSize % lElemSize) * 8;
                    lCumulativeSizeInBits = lBitOffsetFromStructOrg = lSize * 8L;
                    lDisplacement = lContainingObjectDisplacement = lSize / lElemSize * lElemSize;
                }
                if ((lNewBitfieldSumWithinWord = (lBitFieldSumWithinWord = (int)(lCumulativeSizeInBits - lContainingObjectDisplacement * 8L)) + lBitFieldSize) > lElemTypeBit) {
                    lSize = lContainingObjectDisplacement + (long)((lBitFieldSumWithinWord + 7) / 8);
                    lContainingObjectDisplacement = lDisplacement = lSize + (long)lElemType.getAlignmentGap(lSize);
                    lSize = lDisplacement;
                    lBitFieldSumWithinWord = 0;
                }
                lBitOffset = lBitFieldSumWithinWord;
                lBitOffsetFromStructOrg = lContainingObjectDisplacement * 8L + (long)lBitOffset;
                lCumulativeSizeInBits = lContainingObjectDisplacement * 8L + (long)(lBitFieldSumWithinWord += lBitFieldSize);
                lElem.setBitFieldOffset(lBitOffset);
                lElem.setDisplacement(lContainingObjectDisplacement);
                if (this.fDbgLevel > 3) {
                    this.symRoot.ioRoot.dbgSym.print(4, "\n   bitSize " + lElem.getBitSize() + " bitOffset " + lElem.getBitOffset() + " disp " + lElem.evaluateDisp() + " size " + lSize + " bitfieldSum " + lBitFieldSumWithinWord + " offsetFromOrg " + lBitOffsetFromStructOrg + " cummulativeSize " + lCumulativeSizeInBits);
                }
            } else {
                if (lBitFieldBegin) {
                    lSize = lContainingObjectDisplacement + (long)((lBitFieldSumWithinWord + 7) / 8);
                    lBitFieldSumWithinWord = 0;
                }
                lBitFieldBegin = false;
                lDisplacement = this.symRoot.ioRoot.getCompileSpecification().getCoinsOptions().isSet("no-align") ? lSize : lSize + (long)lElemType.getAlignmentGap(lSize);
                lContainingObjectDisplacement = lDisplacement;
                lElem.setDisplacement(lDisplacement);
                lSize = lDisplacement + lElemSize;
                lElemAlignment = lElemType.getAlignment();
                if (lElemType.getFlag(11)) {
                    lIncomplete = true;
                    lUniformSize = false;
                }
                if (!lElemType.getFlag(12)) {
                    lUniformSize = false;
                }
                if (!lElemType.isSizeEvaluable()) {
                    lSizeIsSet = false;
                }
            }
            if (lElemType.isConst()) {
                this.fConst = true;
            }
            if (lElemType.isVolatile()) {
                this.fVolatile = true;
            }
            if (lElemAlignment > lAlignment) {
                lAlignment = lElemAlignment;
            }
            if (lElemType.getFlag(17)) {
                this.symRoot.ioRoot.msgWarning.put("Struct " + this.getName() + " has unfixed size element " + lElem.getName());
                this.setFlag(17, true);
            }
            if (this.fDbgLevel <= 3) continue;
            this.symRoot.ioRoot.dbgSym.print(4, " elem " + lElem.getName(), " size " + lSize + " disp " + lElem.evaluateDisp() + " incomp " + lElemType.getFlag(11));
        }
        if (lBitFieldBegin) {
            lSize = lContainingObjectDisplacement + (long)((lBitFieldSumWithinWord + 7) / 8);
        }
        int lAlignmentGap = 0;
        if (lElemType != null) {
            long lResidue = lSize % (long)lAlignment;
            if (lResidue != 0L) {
                lAlignmentGap = (int)((long)lAlignment - lResidue);
            }
            lSize += (long)lAlignmentGap;
        }
        if (this.fDbgLevel > 3) {
            this.symRoot.ioRoot.dbgSym.print(4, " total " + lSize + " align " + lAlignment);
        }
        this.setSizeValue(lSize);
        if (pSeparately) {
            if (this.fOrigin == null) {
                this.fOrigin = ((SymImpl)this.symRoot.sym).structType(lName, this.fElemList, null);
            }
        } else if (this.fOrigin == null) {
            this.fOrigin = this;
        }
        if (lIncomplete) {
            this.fCompleteType = null;
            lUniformSize = false;
        } else {
            this.fCompleteType = this.fOrigin != null ? this.fOrigin : this;
        }
        this.fAlignment = lAlignment;
        this.setFlag(11, lIncomplete);
        this.setFlag(12, lUniformSize);
    }

    Exp computeStructSizeExp(IrList pElemList) {
        Exp lSizeExp = null;
        ListIterator lElemIterator = pElemList.iterator();
        while (lElemIterator.hasNext()) {
            Elem lElem = (Elem)lElemIterator.next();
            if (lElem == null) continue;
            Exp lElemSizeExp = lElem.getSymType().getSizeExp();
            if (this.fDbgLevel > 3) {
                this.symRoot.ioRoot.dbgSym.printObject(5, lElem.toStringShort(), lElemSizeExp);
            }
            if (lSizeExp == null) {
                lSizeExp = lElemSizeExp;
                continue;
            }
            if (lElemSizeExp == null) continue;
            lSizeExp = this.symRoot.getHirRoot().hir.exp(38, lSizeExp, lElemSizeExp);
        }
        return lSizeExp;
    }

    Exp addStructSizeExp(Elem pElem) {
        Exp lSizeExp = this.getSizeExp();
        lSizeExp = lSizeExp == null ? pElem.getSymType().getSizeExp() : this.symRoot.getHirRoot().hir.exp(38, lSizeExp, pElem.getSymType().getSizeExp());
        return lSizeExp;
    }

    public int getAlignment() {
        return this.fAlignment;
    }

    public void setAlignment(int pAlignment) {
        this.fAlignment = pAlignment;
    }

    public Sym getTag() {
        return this.fTag;
    }

    public void setTag(Sym pTag) {
        this.fTag = pTag;
    }

    public boolean isCompatibleWith(Type pType) {
        if (pType == this) {
            return true;
        }
        if (pType == null || !(pType instanceof StructType)) {
            return false;
        }
        if (pType.isConst() == this.isConst() && pType.isVolatile() == this.isVolatile() && this.getOrigin() != null) {
            if (this.getOrigin() == this || ((StructType)pType).getOrigin() == this) {
                return true;
            }
            if (this.getFinalOrigin().isCompatibleWith(((StructType)pType).getFinalOrigin())) {
                return true;
            }
        }
        return false;
    }

    public Type getCompleteType() {
        if (this.getFlag(11)) {
            if (this.getOrigin() != null) {
                return this.getOrigin().getCompleteType();
            }
            return null;
        }
        return this;
    }

    public String toStringDetail() {
        String symString = super.toStringDetail();
        symString = this.fTag != null ? symString + " tag " + this.fTag.getName() : symString + " tag null";
        return symString;
    }
}

