/*
 * Decompiled with CFR 0.152.
 */
package coins.sym;

import coins.SymRoot;
import coins.sym.PointerType;
import coins.sym.Type;
import coins.sym.TypeImpl;

public class PointerTypeImpl
extends TypeImpl
implements PointerType {
    Type fPointedType;
    long fElemCount = 0L;
    long fLowerBound = 0L;

    public PointerTypeImpl(SymRoot pSymRoot, String pTypeName, Type pPointedType) {
        super(pSymRoot);
        this.fKind = 13;
        this.fType = this;
        this.fTypeKind = 22;
        this.fPointedType = pPointedType;
        if (pTypeName == null) {
            this.fName = "<PTR " + this.fPointedType.getName() + ">";
            this.fName = this.fName.intern();
        } else {
            this.fName = pTypeName;
        }
        this.setSizeValue(machineParam.evaluateSize(22));
        this.setFlag(12, false);
    }

    public PointerTypeImpl(SymRoot pSymRoot, Type pPointedType) {
        this(pSymRoot, null, pPointedType);
    }

    public PointerTypeImpl(SymRoot pSymRoot, Type pPointedType, long pElemCount, long pLowerBound) {
        super(pSymRoot);
        this.fKind = 13;
        this.fType = this;
        this.fTypeKind = 22;
        this.fPointedType = pPointedType;
        StringBuffer lBuffer = new StringBuffer();
        lBuffer.append("<PTR ");
        lBuffer.append(Long.toString(pElemCount, 10));
        lBuffer.append(" ");
        lBuffer.append(Long.toString(pLowerBound, 10));
        lBuffer.append(" ");
        lBuffer.append(pPointedType.getName());
        lBuffer.append(">");
        this.fName = lBuffer.toString().intern();
        this.fElemCount = pElemCount;
        this.fLowerBound = pLowerBound;
        this.setSizeValue(machineParam.evaluateSize(22));
        this.setFlag(12, false);
    }

    public Type getPointedType() {
        return this.fPointedType;
    }

    public boolean isCompatibleWith(Type pType) {
        if (pType == this) {
            return true;
        }
        if (pType == null) {
            return false;
        }
        return pType.getTypeKind() == 22 && pType.isConst() == this.isConst() && pType.isVolatile() == this.isVolatile() && this.getPointedType().isCompatibleWith(((PointerType)pType).getPointedType());
    }

    public boolean isDeclaredAsArray() {
        return this.fElemCount > 0L;
    }

    public long getElemCount() {
        return this.fElemCount;
    }

    public long getLowerBound() {
        return this.fLowerBound;
    }
}

