/*
 * Decompiled with CFR 0.152.
 */
package coins.sym;

import coins.SymRoot;
import coins.aflow.BBlock;
import coins.ir.IrList;
import coins.ir.IrListImpl;
import coins.ir.hir.HIR;
import coins.ir.hir.HirList;
import coins.ir.hir.LabelNode;
import coins.ir.hir.LabeledStmt;
import coins.sym.Label;
import coins.sym.Sym;
import coins.sym.SymImpl;
import java.util.ListIterator;

public class LabelImpl
extends SymImpl
implements Label {
    IrList fHirRefList = null;
    IrList fLirRefList = null;
    LabeledStmt fHIRpos = null;
    int fLabelKind = 0;
    HIR fOriginHir = null;
    BBlock fBBlock = null;

    public LabelImpl(SymRoot pSymRoot, String pLabelName, Sym pDefinedIn) {
        super(pSymRoot);
        this.fKind = 14;
        this.fName = pLabelName;
        this.fDefinedIn = pDefinedIn;
    }

    public LabeledStmt getHirPosition() {
        return this.fHIRpos;
    }

    public void setHirPosition(LabeledStmt pHirPosition) {
        this.fHIRpos = pHirPosition;
    }

    public IrList getHirRefList() {
        if (this.fHirRefList == null) {
            this.fHirRefList = new IrListImpl(this.symRoot.getHirRoot());
        }
        return this.fHirRefList;
    }

    public void resetHirRefList() {
        this.fHirRefList = null;
    }

    public void addToHirRefList(LabelNode pHirRefPosition) {
        if (this.fHirRefList == null) {
            this.fHirRefList = new IrListImpl(this.symRoot.getHirRoot());
        }
        this.fHirRefList.add(pHirRefPosition);
    }

    public boolean removeFromHirRefList(LabelNode labelnode) {
        if (this.fHirRefList != null) {
            return this.fHirRefList.remove(labelnode);
        }
        return false;
    }

    public int getHirRefCount() {
        if (this.fHirRefList != null) {
            return this.fHirRefList.size();
        }
        return 0;
    }

    public BBlock getBBlock() {
        return this.fBBlock;
    }

    public void setBBlock(BBlock pBBlock) {
        this.fBBlock = pBBlock;
    }

    public int getLabelKind() {
        return this.fLabelKind;
    }

    public void setLabelKind(int pLabelKind) {
        this.fLabelKind = pLabelKind;
    }

    public boolean endPointLabel() {
        return this.fLabelKind >= 20;
    }

    public HIR getOriginHir() {
        return this.fOriginHir;
    }

    public void setOriginHir(HIR pOriginHir) {
        this.fOriginHir = pOriginHir;
    }

    public void replaceHirLabel(Label pToLabel) {
        if (this.fDbgLevel > 0) {
            this.symRoot.ioRoot.dbgSym.print(3, "replaceHirLabel from " + this.getName(), "to " + pToLabel.getName());
        }
        if (this.fHirRefList != null && this != pToLabel) {
            LabelNode lLabelNode;
            IrListImpl lHirRefList = new IrListImpl(this.symRoot.getHirRoot());
            ListIterator lIterator = this.fHirRefList.iterator();
            while (lIterator.hasNext()) {
                lLabelNode = (LabelNode)lIterator.next();
                lHirRefList.add(lLabelNode);
            }
            lIterator = lHirRefList.iterator();
            while (lIterator.hasNext()) {
                lLabelNode = (LabelNode)lIterator.next();
                LabelNode lNewLabelNode = this.symRoot.getHirRoot().hir.labelNode(pToLabel);
                HIR lParent = (HIR)lLabelNode.getParent();
                if (lParent != null) {
                    if (lParent instanceof HirList) {
                        int lIndex = ((HirList)lParent).indexOf(lLabelNode);
                        if (lIndex >= 0) {
                            ((HirList)lParent).remove(lLabelNode);
                            ((HirList)lParent).add(lIndex, lNewLabelNode);
                        } else {
                            this.symRoot.ioRoot.msgRecovered.put(1025, "replaceHirLabel han no instance of " + lLabelNode.toString());
                        }
                    } else {
                        int lChildNumber = lLabelNode.getChildNumber();
                        lParent.replaceSource(lChildNumber, lNewLabelNode);
                    }
                } else {
                    this.symRoot.ioRoot.msgRecovered.put(1025, "replaceHirLabel han no no parent for " + lLabelNode.toString());
                }
                pToLabel.getHirRefList().add(lNewLabelNode);
                this.fHirRefList.remove(lLabelNode);
            }
        }
    }

    public String toString() {
        String lString = super.toString();
        lString = lString + " kind " + this.fLabelKind;
        if (this.fBBlock != null) {
            lString = lString + " BBlock " + this.fBBlock.getBBlockNumber();
        }
        return lString;
    }

    public String toStringDetail() {
        String lString = super.toStringDetail();
        if (this.fHirRefList != null) {
            lString = lString + " refered " + this.fHirRefList.toStringShort();
        } else if (this.fLirRefList != null) {
            lString = lString + " refered " + this.fLirRefList.toString();
        }
        return lString;
    }
}

