/*
 * Decompiled with CFR 0.152.
 */
package coins.ssa;

import coins.backend.Function;
import coins.backend.Type;
import coins.backend.cfg.FlowGraph;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.ImList;
import coins.ssa.SsaEnvironment;
import java.util.Hashtable;

class SsaSymTab {
    private SsaEnvironment env;
    private Hashtable symbols;
    private Function function;

    SsaSymTab(SsaEnvironment e, Function f) {
        this.env = e;
        FlowGraph g = f.flowGraph();
        this.symbols = new Hashtable();
        this.function = f;
        BiLink p = f.localSymtab.symbols().last();
        while (!p.atEnd()) {
            SsaSymbol ssym;
            Symbol s = (Symbol)p.elem();
            if (s.storage == 2 && (ssym = (SsaSymbol)this.symbols.get(s)) == null) {
                ssym = new SsaSymbol(s);
                this.symbols.put(s, ssym);
            }
            p = p.prev();
        }
    }

    int compare(Symbol s1, Symbol s2) {
        SsaSymbol ssym1 = (SsaSymbol)this.symbols.get(s1);
        int rank1 = -1;
        if (ssym1 != null) {
            rank1 = ssym1.rank(s1);
        }
        SsaSymbol ssym2 = (SsaSymbol)this.symbols.get(s2);
        int rank2 = -1;
        if (ssym2 != null) {
            rank2 = ssym2.rank(s2);
        }
        if (rank1 == rank2) {
            return 0;
        }
        if (rank1 > rank2) {
            return 1;
        }
        return -1;
    }

    Symbol orgSym(Symbol s) {
        SsaSymbol ssym = (SsaSymbol)this.symbols.get(s);
        if (ssym != null) {
            return ssym.original;
        }
        return s;
    }

    Symbol newAddressSymbol(Symbol s) {
        SsaSymbol ssym = (SsaSymbol)this.symbols.get(s);
        if (ssym != null) {
            return ssym.newSymbol();
        }
        ssym = new SsaSymbol(s);
        this.symbols.put(s, ssym);
        return ssym.newSymbol();
    }

    Symbol currentAddressSymbol(Symbol s) {
        SsaSymbol ssym = (SsaSymbol)this.symbols.get(s);
        if (ssym != null) {
            return ssym.latest;
        }
        ssym = new SsaSymbol(s);
        this.symbols.put(s, ssym);
        return ssym.newSymbol();
    }

    Symbol newSsaSymbol(Symbol s) {
        SsaSymbol ssym = (SsaSymbol)this.symbols.get(s);
        if (ssym != null) {
            return ssym.newSymbol();
        }
        return this.newSsaSymbol(s.name.intern(), s.type);
    }

    Symbol newSsaSymbol(String name, int type) {
        SsaSymbol ssym;
        if (Type.tag(type) != 2 && Type.tag(type) != 4) {
            return null;
        }
        String fullName = name + Type.toString(type);
        Symbol s = this.function.localSymtab.get(fullName.intern());
        if (s == null) {
            int boundary = 0;
            switch (Type.bits(type)) {
                case 8: {
                    boundary = 1;
                    break;
                }
                case 16: {
                    boundary = 2;
                    break;
                }
                case 32: {
                    boundary = 4;
                    break;
                }
                case 64: {
                    boundary = 8;
                    break;
                }
                case 128: {
                    boundary = 16;
                }
            }
            s = this.function.addSymbol(fullName, 2, type, boundary, 0, ImList.Empty);
        }
        if ((ssym = (SsaSymbol)this.symbols.get(s)) == null) {
            ssym = new SsaSymbol(s);
            this.symbols.put(s, ssym);
        }
        return ssym.newSymbol();
    }

    private class SsaSymbol {
        final Symbol original;
        Symbol latest;
        private int suffix;

        SsaSymbol(Symbol s) {
            this.original = s;
            this.suffix = 0;
            this.latest = null;
        }

        Symbol newSymbol() {
            String symName = this.original.name + "_" + this.suffix;
            symName = symName.intern();
            this.latest = SsaSymTab.this.function.addSymbol(symName, this.original.storage, this.original.type, this.original.boundary, 0, ImList.Empty);
            SsaSymTab.this.function.flowGraph().touch();
            ++this.suffix;
            SsaSymTab.this.symbols.put(this.latest, this);
            return this.latest;
        }

        int rank(Symbol s) {
            for (int i = 0; i < this.suffix; ++i) {
                String symName = this.original.name + "_" + i;
                if (!(symName = symName.intern()).equals(s.name.intern())) continue;
                return i;
            }
            return -1;
        }
    }
}

