/*
 * Decompiled with CFR 0.152.
 */
package coins.ssa;

import coins.IoRoot;
import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.Module;
import coins.backend.ana.LiveVariableAnalysis;
import coins.backend.ana.LiveVariableSlotwise;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirNode;
import coins.backend.opt.If2Jumpc;
import coins.backend.opt.JumpOpt;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.driver.CompileSpecification;
import coins.ssa.BackTranslateFromSsa;
import coins.ssa.BackTranslateFromSsaBriggs;
import coins.ssa.ChangeLoopStructure;
import coins.ssa.Coalescing;
import coins.ssa.CommonSubexpressionElimination;
import coins.ssa.ConcatBlks;
import coins.ssa.ConstantPropagation;
import coins.ssa.CopyPropagation;
import coins.ssa.DeadCodeElimination;
import coins.ssa.DivideExpression;
import coins.ssa.Dump;
import coins.ssa.EdgeSplit;
import coins.ssa.EmptyBlockElimination;
import coins.ssa.GlobalReassociation;
import coins.ssa.HoistingLoopInvariant;
import coins.ssa.LirToC;
import coins.ssa.PREQP;
import coins.ssa.RedundantPhiElimination;
import coins.ssa.SsaEnvironment;
import coins.ssa.SsaGraph;
import coins.ssa.SsaSymTab;
import coins.ssa.TranslateToSsa;
import coins.ssa.Util;
import java.io.File;

public class SsaDriver
implements LocalTransformer {
    private SsaSymTab sstab;
    private final SsaEnvironment env;
    public static final int THR = 100;
    private int suffix;
    private Function f;

    public boolean doIt(Data data, ImList args) {
        return true;
    }

    public String name() {
        return "SsaDriver";
    }

    public String subject() {
        return "SSA optimizations";
    }

    public SsaDriver(Module m, IoRoot io, CompileSpecification coinsSpec) {
        this.env = new SsaEnvironment(m, coinsSpec, io);
        m.apply(JumpOpt.trig);
    }

    public boolean doIt(Function function, ImList args) {
        if (!this.isNoParallelAndSubreg(function)) {
            return true;
        }
        this.env.println("Optimization on SSA form", 1);
        this.f = function;
        this.suffix = 1;
        long start = 0L;
        if (this.env.shouldDo(100)) {
            start = System.currentTimeMillis();
        }
        this.sstab = new SsaSymTab(this.env, this.f);
        this.f.apply(If2Jumpc.trig);
        BiList opt = this.decodeOptions();
        BiLink p = opt.first();
        while (!p.atEnd()) {
            long s = 0L;
            if (this.env.shouldDo(1000)) {
                s = System.currentTimeMillis();
            }
            this.f.apply((LocalTransformer)p.elem());
            if (this.env.shouldDo(1000)) {
                long e = System.currentTimeMillis();
                long t = e - s;
                this.env.println("-------  " + t + "[ms]\n", 1000);
            }
            p = p.next();
        }
        if (this.env.shouldDo(100)) {
            long end = System.currentTimeMillis();
            long t = end - start;
            this.env.println("[ Total Time of SSA : " + t + "ms ]", 100);
        }
        if (this.env.opt.isSet("ssa-debug")) {
            this.checkLir();
        }
        return true;
    }

    private void checkLir() {
        this.env.output.print("SSA DBG : checking live-in " + this.f.symbol.name + " ... ");
        LiveVariableAnalysis liveAna = (LiveVariableAnalysis)this.f.apply(LiveVariableSlotwise.analyzer);
        BiList liveIn = liveAna.liveIn(this.f.flowGraph().entryBlk());
        if (liveIn.length() > 0) {
            this.env.output.print("fail --> ");
            BiLink p = liveIn.first();
            while (!p.atEnd()) {
                this.env.output.print(p.elem() + " ");
                p = p.next();
            }
            this.env.output.println();
            this.env.output.println("SSA DBG : Some variables LiveIn at the entrance!");
        } else {
            this.env.output.println("ok");
        }
    }

    private BiList decodeOptions() {
        int delimiter = 47;
        BiList optionString = new BiList();
        int beginIndex = 0;
        String options = this.env.opt.getArg("ssa-opt");
        int length = options.length();
        for (int endIndex = 0; endIndex <= length; ++endIndex) {
            beginIndex = endIndex;
            if ((endIndex = options.indexOf(47, beginIndex)) == -1) {
                endIndex = length;
            }
            if (endIndex <= beginIndex) continue;
            String opt = options.substring(beginIndex, endIndex);
            opt = opt.trim();
            optionString.add(opt);
        }
        boolean isOk = this.syntaxCheck(optionString);
        if (!isOk) {
            System.err.println("WARNING : illegal syntax in the SSA option.");
            return new BiList();
        }
        this.env.println("------------", 100);
        this.env.println("agenda", 100);
        this.env.println("------------", 100);
        BiList optimizers = new BiList();
        if (!this.env.opt.isSet("ssa-no-change-loop")) {
            optimizers.add(new ChangeLoopStructure(this.env));
        }
        BiLink p = optionString.first();
        while (!p.atEnd()) {
            String name = (String)p.elem();
            LocalTransformer lt = this.lookUpOptimizer(name);
            if (lt != null) {
                if (name.equals("cseqp") || name.equals("preqp")) {
                    optimizers.add(new EdgeSplit(this.env));
                    optimizers.add(new DivideExpression(this.env, this.sstab));
                }
                optimizers.add(lt);
                if (!this.env.opt.isSet("ssa-no-redundant-phi-elimination") && (name.equals("mini") || name.equals("semi") || name.equals("prun"))) {
                    optimizers.add(new RedundantPhiElimination(this.env));
                }
            }
            p = p.next();
        }
        if (this.env.opt.isSet("ssa-with-chaitin-coalescing")) {
            optimizers.add(new Coalescing(this.env));
        }
        this.env.println("------------\n", 100);
        return optimizers;
    }

    private LocalTransformer lookUpOptimizer(String name) {
        LocalTransformer lt = null;
        if (name.equals("mini")) {
            boolean folding = !this.env.opt.isSet("ssa-no-copy-folding");
            lt = new TranslateToSsa(this.env, this.sstab, 0, folding);
        } else if (name.equals("semi")) {
            boolean folding = !this.env.opt.isSet("ssa-no-copy-folding");
            lt = new TranslateToSsa(this.env, this.sstab, 1, folding);
        } else if (name.equals("prun")) {
            boolean folding = !this.env.opt.isSet("ssa-no-copy-folding");
            lt = new TranslateToSsa(this.env, this.sstab, 2, folding);
        } else if (name.equals("srd1")) {
            boolean coalesce = !this.env.opt.isSet("ssa-no-sreedhar-coalescing");
            boolean aggregate = !this.env.opt.isSet("ssa-no-replace-by-exp");
            lt = new BackTranslateFromSsa(this.env, this.sstab, 1, coalesce, aggregate);
        } else if (name.equals("srd2")) {
            boolean coalesce = !this.env.opt.isSet("ssa-no-sreedhar-coalescing");
            boolean aggregate = !this.env.opt.isSet("ssa-no-replace-by-exp");
            lt = new BackTranslateFromSsa(this.env, this.sstab, 2, coalesce, aggregate);
        } else if (name.equals("srd3")) {
            boolean coalesce = !this.env.opt.isSet("ssa-no-sreedhar-coalescing");
            boolean aggregate = !this.env.opt.isSet("ssa-no-replace-by-exp");
            lt = new BackTranslateFromSsa(this.env, this.sstab, 3, coalesce, aggregate);
        } else if (name.equals("brig")) {
            boolean extend = false;
            lt = new BackTranslateFromSsaBriggs(this.env, this.sstab, extend);
        } else if (name.equals("cpyp")) {
            lt = new CopyPropagation(this.env);
        } else if (name.equals("cstp")) {
            lt = new ConstantPropagation(this.env);
        } else if (name.equals("dce")) {
            lt = new DeadCodeElimination(this.env);
        } else if (name.equals("cse")) {
            lt = new CommonSubexpressionElimination(this.env);
        } else if (name.equals("cseqp")) {
            lt = new PREQP(this.env, this.sstab, 7);
        } else if (name.equals("preqp")) {
            lt = new PREQP(this.env, this.sstab, 0);
        } else if (name.equals("rpe")) {
            lt = new RedundantPhiElimination(this.env);
        } else if (name.equals("esplt")) {
            lt = new EdgeSplit(this.env);
        } else if (name.equals("hli")) {
            lt = new HoistingLoopInvariant(this.env, this.sstab);
        } else if (name.equals("dump")) {
            lt = new Dump(this.env);
        } else if (name.equals("lir2c")) {
            lt = new LirToC(this.env, this.makeCName());
        } else if (name.equals("ebe")) {
            lt = new EmptyBlockElimination(this.env);
        } else if (name.equals("osr")) {
            lt = new SsaGraph(this.env, this.sstab, name);
        } else if (name.equals("ssag")) {
            lt = new SsaGraph(this.env, this.sstab, name);
        } else if (name.equals("divex")) {
            lt = new DivideExpression(this.env, this.sstab);
        } else if (name.equals("cbb")) {
            lt = new ConcatBlks(this.env);
        } else if (name.equals("gra")) {
            lt = new GlobalReassociation(this.env);
        } else {
            System.err.println("SsaDriver.java : unexpected optimizer name " + name);
        }
        return lt;
    }

    private String makeCName() {
        File source = this.env.ioRoot.getSourceFile();
        String sourcePath = source.getName();
        String root = sourcePath.substring(0, sourcePath.lastIndexOf(46));
        String dest = root.concat("-" + this.f.symbol.name + "-" + this.suffix + ".lir2c");
        ++this.suffix;
        return dest;
    }

    private boolean syntaxCheck(BiList optionString) {
        boolean isOK = true;
        boolean onSSA = false;
        BiLink p = optionString.first();
        while (!p.atEnd()) {
            String name = (String)p.elem();
            if (onSSA) {
                if (name.equals("srd1") || name.equals("srd2") || name.equals("srd3") || name.equals("brig")) {
                    onSSA = !onSSA;
                } else if (!(name.equals("esplt") || name.equals("cse") || name.equals("cseqp") || name.equals("preqp") || name.equals("gra") || name.equals("divex") || name.equals("cbb") || name.equals("ssag") || name.equals("osr") || name.equals("ebe") || name.equals("dump") || name.equals("lir2c") || name.equals("hli") || name.equals("rpe") || name.equals("dce") || name.equals("cpyp") || name.equals("cstp"))) {
                    System.err.println("SsaDriver.java : Option syntax error \"" + name + "\".");
                    isOK = false;
                }
            } else if (name.equals("mini") || name.equals("semi") || name.equals("prun")) {
                onSSA = !onSSA;
            } else if (!(name.equals("lir2c") || name.equals("divex") || name.equals("cbb") || name.equals("dump"))) {
                System.err.println("SsaDriver.java : Option syntax error \"" + name + "\".");
                isOK = false;
            }
            p = p.next();
        }
        if (onSSA) {
            System.err.println("SsaDriver.java : You must translate back into normal form.");
            isOK = false;
        }
        return isOK;
    }

    private boolean isNoParallelAndSubreg(Function func) {
        Util util = new Util(this.env, func);
        BiLink p = func.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                LirNode node = (LirNode)q.elem();
                BiList list = util.findTargetLir(node, 56, new BiList());
                if ((list = util.findTargetLir(node, 7, list)).length() > 0) {
                    return false;
                }
                q = q.next();
            }
            p = p.next();
        }
        return true;
    }
}

