/*
 * Decompiled with CFR 0.152.
 */
package coins.ssa;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.lir.LirFconst;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.ssa.SsaEnvironment;
import java.util.Hashtable;
import java.util.Stack;

class RedundantPhiElimination
implements LocalTransformer {
    public static final int THR = 2000;
    private SsaEnvironment env;
    private Hashtable copyMap;

    public boolean doIt(Data data, ImList args) {
        return true;
    }

    public String name() {
        return "RedundantPhiElimination";
    }

    public String subject() {
        return "Eliminate redundant phi-instructin.";
    }

    public RedundantPhiElimination(SsaEnvironment e) {
        this.env = e;
        this.env.println("  Redundant Phi Instruction Elimination", 100);
    }

    public boolean doIt(Function function, ImList args) {
        this.env.println("****************** doing RPE to " + function.symbol.name, 1000);
        FlowGraph g = function.flowGraph();
        this.copyMap = new Hashtable();
        boolean changed = true;
        while (changed) {
            changed = false;
            BiLink p = g.basicBlkList.first();
            while (!p.atEnd()) {
                BasicBlk blk = (BasicBlk)p.elem();
                BiList expList = new BiList();
                BiLink q = blk.instrList().first();
                while (!q.atEnd()) {
                    LirNode node = (LirNode)q.elem();
                    Stack<LirNode> stack = new Stack<LirNode>();
                    stack.push(node);
                    while (!stack.empty()) {
                        LirNode n = (LirNode)stack.pop();
                        for (int j = 0; j < n.nKids(); ++j) {
                            if (n.kid((int)j).opCode == 6) {
                                LirNode t = (LirNode)this.copyMap.get(((LirSymRef)n.kid((int)j)).symbol);
                                if (t == null) continue;
                                this.env.println("RPE : replace " + n.kid(j) + " to " + t + " of " + node + " in block " + blk.id, 2000);
                                n.setKid(j, t.makeCopy(this.env.lir));
                                continue;
                            }
                            stack.push(n.kid(j));
                        }
                    }
                    if (node.opCode == 59) {
                        Symbol dst = ((LirSymRef)node.kid((int)0)).symbol;
                        boolean isOk = true;
                        boolean isReg = true;
                        Symbol src = null;
                        Number value = null;
                        for (int i = 1; i < node.nKids(); ++i) {
                            LirNode srcNode = node.kid(i).kid(0);
                            if (!isOk) continue;
                            if (srcNode.opCode == 6) {
                                if (!isReg) {
                                    isOk = false;
                                    break;
                                }
                                isReg = true;
                                Symbol s = ((LirSymRef)srcNode).symbol;
                                if (src == null) {
                                    src = s;
                                    continue;
                                }
                                if (src.equals(s) || dst.equals(s)) continue;
                                isOk = false;
                                break;
                            }
                            if (isReg && src != null) {
                                isOk = false;
                                break;
                            }
                            isReg = false;
                            if (srcNode.opCode == 2) {
                                long v = ((LirIconst)srcNode).value;
                                if (value == null) {
                                    value = new Long(v);
                                    continue;
                                }
                                if (value.equals(new Long(v))) continue;
                                isOk = false;
                                break;
                            }
                            if (srcNode.opCode != 3) continue;
                            double v = ((LirFconst)srcNode).value;
                            if (value == null) {
                                value = new Double(v);
                                continue;
                            }
                            if (value.equals(new Double(v))) continue;
                            isOk = false;
                            break;
                        }
                        if (isOk) {
                            changed = true;
                            if (isReg) {
                                if (dst.equals(src)) {
                                    this.env.println("RPE : Just Remove " + node + " in block " + blk.id, 2000);
                                    q.unlink();
                                    g.touch();
                                } else {
                                    this.env.println("RPE : Remove and replace " + node + " in block " + blk.id, 2000);
                                    LirNode newReg = this.env.lir.symRef(6, src.type, src, ImList.Empty);
                                    this.copyMap.put(dst, newReg);
                                    q.unlink();
                                    g.touch();
                                }
                            } else {
                                LirNode cnst = null;
                                if (value instanceof Long) {
                                    cnst = this.env.lir.iconst(node.type, value.longValue(), ImList.Empty);
                                } else if (value instanceof Double) {
                                    cnst = this.env.lir.fconst(node.type, value.doubleValue(), ImList.Empty);
                                }
                                this.env.println("RPE : Remove and replace " + node + " in block " + blk.id, 2000);
                                this.copyMap.put(dst, cnst);
                                q.unlink();
                                g.touch();
                            }
                        }
                    }
                    q = q.next();
                }
                p = p.next();
            }
        }
        this.env.println("", 2000);
        return true;
    }
}

