/*
 * Decompiled with CFR 0.152.
 */
package coins.ssa;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirNode;
import coins.backend.util.BiLink;
import coins.backend.util.ImList;
import coins.ssa.SsaEnvironment;

class EmptyBlockElimination
implements LocalTransformer {
    private SsaEnvironment env;
    public static final int THR = 2000;
    private Function f;

    public boolean doIt(Data data, ImList args) {
        return true;
    }

    public String name() {
        return "EmptyBlockElimination";
    }

    public String subject() {
        return "Eliminate empty basic blocks on SSA form.";
    }

    public EmptyBlockElimination(SsaEnvironment e) {
        this.env = e;
        this.env.println("  Eliminate the enpty basic blocks", 100);
    }

    public boolean doIt(Function function, ImList args) {
        this.env.println("****************** doing EBE to " + function.symbol.name, 1000);
        this.f = function;
        BiLink p = function.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            if (blk.succList().length() == 1 && blk.predList().length() == 1) {
                BasicBlk pred = (BasicBlk)blk.predList().first().elem();
                BasicBlk succ = (BasicBlk)blk.succList().first().elem();
                if (pred.succList().length() == 1 && succ.predList().length() == 1 && blk.instrList().length() == 1) {
                    switch (((LirNode)blk.instrList().first().elem()).opCode) {
                        case 49: {
                            LirNode predLast = (LirNode)pred.instrList().last().elem();
                            if (predLast.opCode != 49) break;
                            predLast.setKid(0, this.env.lir.labelRefVariant(succ.label()));
                            pred.maintEdges();
                            blk.instrList().clear();
                            blk.maintEdges();
                            p.unlink();
                            this.env.println("EBE : Redundant blk " + blk.id, 2000);
                            break;
                        }
                    }
                }
            }
            p = p.next();
        }
        this.env.println("", 2000);
        return true;
    }
}

