/*
 * Decompiled with CFR 0.152.
 */
package coins.ssa;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirLabelRef;
import coins.backend.lir.LirNode;
import coins.backend.sym.Label;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.ssa.SsaEnvironment;

class ConcatBlks
implements LocalTransformer {
    public static final int THR = 2000;
    private SsaEnvironment env;
    private Function f;

    public boolean doIt(Data data, ImList args) {
        return true;
    }

    public String name() {
        return "ConcatBlks";
    }

    public String subject() {
        return "Concatenate some basic blocks.";
    }

    ConcatBlks(SsaEnvironment e) {
        this.env = e;
        this.env.println("  Concatenate Basic Blocks", 100);
    }

    public boolean doIt(Function func, ImList args) {
        this.f = func;
        this.env.println("****************** doing CBB to " + this.f.symbol.name, 1000);
        BiList removeList = new BiList();
        boolean changed = true;
        while (changed) {
            BasicBlk blk;
            changed = false;
            removeList.clear();
            BiLink p = this.f.flowGraph().basicBlkList.first();
            while (!p.atEnd()) {
                BasicBlk succ;
                blk = (BasicBlk)p.elem();
                if (!removeList.contains(blk) && blk.succList().length() == 1 && !(succ = (BasicBlk)blk.succList().first().elem()).equals(this.f.flowGraph().exitBlk()) && succ.predList().length() == 1) {
                    changed = true;
                    blk.instrList().last().unlink();
                    blk.instrList().last().addAllAfter(succ.instrList());
                    this.replaceLabelInPhi(succ.succList(), succ.label(), blk.label());
                    succ.clearEdges();
                    blk.maintEdges();
                    this.f.touch();
                    removeList.add(succ);
                }
                p = p.next();
            }
            p = removeList.first();
            while (!p.atEnd()) {
                blk = (BasicBlk)p.elem();
                this.f.flowGraph().basicBlkList.remove(blk);
                this.f.touch();
                this.env.println("CBB : remove blk[" + blk.id + "]", 2000);
                p = p.next();
            }
        }
        this.env.println("", 2000);
        return true;
    }

    private void replaceLabelInPhi(BiList list, Label org, Label rep) {
        BiLink p = list.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                LirNode node = (LirNode)q.elem();
                if (node.opCode != 59) break;
                for (int i = 1; i < node.nKids(); ++i) {
                    if (!((LirLabelRef)node.kid((int)i).kid((int)1)).label.equals(org)) continue;
                    node.kid(i).setKid(1, this.env.lir.labelRefVariant(rep));
                }
                q = q.next();
            }
            p = p.next();
        }
    }
}

