/*
 * Decompiled with CFR 0.152.
 */
package coins.ssa;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.ana.Dominators;
import coins.backend.cfg.BasicBlk;
import coins.backend.lir.LirLabelRef;
import coins.backend.lir.LirNode;
import coins.backend.opt.PreHeaders;
import coins.backend.sym.Label;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.ssa.SsaEnvironment;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;

class ChangeLoopStructure
implements LocalTransformer {
    private SsaEnvironment env;
    public static final int THR = 2000;
    private BiList loops;
    private Function f;

    public boolean doIt(Data data, ImList args) {
        return true;
    }

    public String name() {
        return "ChangeLoopStructure";
    }

    public String subject() {
        return "Change loop structure from while type to do-while type.";
    }

    public ChangeLoopStructure(SsaEnvironment e) {
        this.env = e;
        this.env.println("  Change Loop Structure", 100);
    }

    public boolean doIt(Function function, ImList args) {
        this.env.println("****************** doing CLS to " + function.symbol.name, 1000);
        this.f = function;
        this.loops = new BiList();
        boolean changed = true;
        while (changed) {
            changed = false;
            this.loops.clear();
            this.loopDetect();
            this.mergeLoops();
            changed = this.changeLoopStructure();
        }
        this.f.apply(PreHeaders.trig);
        BiLink p = this.loops.first();
        while (!p.atEnd()) {
            NaturalLoop l = (NaturalLoop)p.elem();
            if (l.header.predList().length() > 1) {
                BasicBlk preheader = this.f.flowGraph().insertNewBlkBefore(l.header);
                BiLink q = l.header.predList().first();
                while (!q.atEnd()) {
                    BasicBlk blk = (BasicBlk)q.elem();
                    if (blk != preheader) {
                        LirNode last = (LirNode)blk.instrList().last().elem();
                        last.replaceLabel(l.header.label(), preheader.label(), this.env.lir);
                        blk.maintEdges();
                    }
                    q = q.next();
                }
                preheader.maintEdges();
            }
            p = p.next();
        }
        this.env.println("", 2000);
        return true;
    }

    private boolean changeLoopStructure() {
        boolean changed = false;
        BiLink p = this.loops.first();
        while (!p.atEnd()) {
            NaturalLoop l = (NaturalLoop)p.elem();
            if (l.header != l.backEdgeBlk) {
                BiLink q;
                BiList body = new BiList();
                Stack<BasicBlk> stack = new Stack<BasicBlk>();
                body.add(l.header);
                if (!body.contains(l.backEdgeBlk)) {
                    body.add(l.backEdgeBlk);
                    stack.push(l.backEdgeBlk);
                }
                while (!stack.empty()) {
                    BasicBlk m = (BasicBlk)stack.pop();
                    q = m.predList().first();
                    while (!q.atEnd()) {
                        BasicBlk pred = (BasicBlk)q.elem();
                        if (!body.contains(pred)) {
                            body.add(pred);
                            stack.push(pred);
                        }
                        q = q.next();
                    }
                }
                boolean doNotChange = true;
                q = body.first();
                while (!q.atEnd()) {
                    BasicBlk loopBlk = (BasicBlk)q.elem();
                    LirNode lastNode = (LirNode)loopBlk.instrList().last().elem();
                    switch (lastNode.opCode) {
                        case 49: {
                            doNotChange = false;
                            break;
                        }
                        case 50: 
                        case 51: {
                            boolean toOutSide = false;
                            Label[] targets = lastNode.getTargets();
                            for (int i = 0; i < targets.length; ++i) {
                                if (body.contains(targets[i].basicBlk())) continue;
                                toOutSide = true;
                                break;
                            }
                            if (toOutSide) break;
                            doNotChange = false;
                        }
                    }
                    if (!doNotChange) break;
                    q = q.next();
                }
                if (!doNotChange) {
                    LirNode node = (LirNode)l.header.instrList().last().elem();
                    BasicBlk newBlk = null;
                    block4 : switch (node.opCode) {
                        case 50: {
                            for (int i = 1; i < node.nKids(); ++i) {
                                BasicBlk blk = ((LirLabelRef)node.kid((int)i)).label.basicBlk();
                                if (body.contains(blk)) continue;
                                this.env.println("CLS : find 'while' type " + l, 2000);
                                newBlk = this.f.flowGraph().insertNewBlkBefore(blk);
                                BiList newInstrList = newBlk.instrList();
                                newInstrList.clear();
                                BiLink q2 = l.header.instrList().first();
                                while (!q2.atEnd()) {
                                    LirNode instr = (LirNode)q2.elem();
                                    newInstrList.add(instr.makeCopy(this.env.lir));
                                    q2 = q2.next();
                                }
                                newBlk.maintEdges();
                                break block4;
                            }
                            break;
                        }
                        case 51: {
                            this.env.println("CLS : find 'while' type, but not changed " + l, 2000);
                        }
                    }
                    if (newBlk != null) {
                        this.f.flowGraph().touch();
                        changed = true;
                        LirNode bebJump = (LirNode)l.backEdgeBlk.instrList().last().elem();
                        switch (bebJump.opCode) {
                            case 49: {
                                bebJump.setKid(0, this.env.lir.labelRef(newBlk.label()));
                                break;
                            }
                            case 50: {
                                for (int i = 1; i < bebJump.nKids(); ++i) {
                                    if (l.header != ((LirLabelRef)bebJump.kid((int)i)).label.basicBlk()) continue;
                                    bebJump.setKid(i, this.env.lir.labelRef(newBlk.label()));
                                }
                                break;
                            }
                            case 51: {
                                if (l.header == ((LirLabelRef)bebJump.kid((int)2)).label.basicBlk()) {
                                    bebJump.setKid(2, this.env.lir.labelRef(newBlk.label()));
                                }
                                for (int i = 0; i < bebJump.kid(1).nKids(); ++i) {
                                    LirLabelRef lab = (LirLabelRef)bebJump.kid(1).kid(i).kid(1);
                                    if (l.header != lab.label.basicBlk()) continue;
                                    bebJump.kid(1).kid(i).setKid(1, this.env.lir.labelRef(newBlk.label()));
                                }
                                break;
                            }
                        }
                        l.backEdgeBlk.maintEdges();
                    }
                }
            }
            p = p.next();
        }
        return changed;
    }

    private void mergeLoops() {
        Hashtable<BasicBlk, BiList> table = new Hashtable<BasicBlk, BiList>();
        BiLink p = this.loops.first();
        while (!p.atEnd()) {
            NaturalLoop l = (NaturalLoop)p.elem();
            BasicBlk header = l.header;
            BiList list = (BiList)table.get(header);
            if (list == null) {
                list = new BiList();
                table.put(header, list);
            }
            list.add(l);
            p = p.next();
        }
        Enumeration keys = table.keys();
        while (keys.hasMoreElements()) {
            BasicBlk header = (BasicBlk)keys.nextElement();
            BiList list = (BiList)table.get(header);
            if (list.length() <= 1) continue;
            BasicBlk newBeb = this.f.flowGraph().insertNewBlkBefore(header);
            this.env.print("CLS : merge ", 2000);
            BiLink p2 = list.first();
            while (!p2.atEnd()) {
                NaturalLoop l = (NaturalLoop)p2.elem();
                this.loops.remove(l);
                this.env.print(l.toString(), 2000);
                BasicBlk beb = l.backEdgeBlk;
                LirNode jumpNode = (LirNode)beb.instrList().last().elem();
                switch (jumpNode.opCode) {
                    case 49: {
                        jumpNode.setKid(0, this.env.lir.labelRef(newBeb.label()));
                        break;
                    }
                    case 50: {
                        int i;
                        for (i = 1; i < 3; ++i) {
                            if (((LirLabelRef)jumpNode.kid((int)i)).label != header.label()) continue;
                            jumpNode.setKid(i, this.env.lir.labelRef(newBeb.label()));
                        }
                        break;
                    }
                    case 51: {
                        int i;
                        for (i = 0; i < jumpNode.kid(1).nKids(); ++i) {
                            LirLabelRef labRef = (LirLabelRef)jumpNode.kid(1).kid(i).kid(1);
                            if (labRef.label != header.label()) continue;
                            jumpNode.kid(1).kid(i).setKid(1, this.env.lir.labelRef(newBeb.label()));
                        }
                        if (((LirLabelRef)jumpNode.kid((int)2)).label != header.label()) break;
                        jumpNode.setKid(2, this.env.lir.labelRef(newBeb.label()));
                    }
                }
                beb.maintEdges();
                p2 = p2.next();
            }
            NaturalLoop newLoop = new NaturalLoop(header, newBeb);
            this.env.println(" to " + newLoop, 2000);
            this.loops.add(newLoop);
        }
    }

    private void loopDetect() {
        Dominators dom = (Dominators)this.f.require(Dominators.analyzer);
        BiLink p = this.f.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiLink q = blk.succList().first();
            while (!q.atEnd()) {
                BasicBlk succ = (BasicBlk)q.elem();
                if (dom.dominates(succ, blk)) {
                    NaturalLoop l = new NaturalLoop(succ, blk);
                    this.env.println("CLS : detect loop " + l, 2000);
                    this.loops.add(l);
                }
                q = q.next();
            }
            p = p.next();
        }
    }

    private class NaturalLoop {
        BasicBlk header;
        BasicBlk backEdgeBlk;

        NaturalLoop(BasicBlk h, BasicBlk beb) {
            this.header = h;
            this.backEdgeBlk = beb;
        }

        public String toString() {
            return "(H[" + this.header.id + "] , B[" + this.backEdgeBlk.id + "])";
        }
    }
}

