/*
 * Decompiled with CFR 0.152.
 */
package coins.ssa;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.ana.InterferenceGraph;
import coins.backend.ana.LiveVariableAnalysis;
import coins.backend.ana.LiveVariableSlotwise;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.lir.LirBinOp;
import coins.backend.lir.LirFconst;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirLabelRef;
import coins.backend.lir.LirNaryOp;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.ssa.AggregateInstructions;
import coins.ssa.SsaEnvironment;
import coins.ssa.SsaSymTab;
import coins.ssa.Util;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;

class BackTranslateFromSsa
implements LocalTransformer {
    public static final int THR = 1500;
    public static final int THR2 = 2000;
    public static final int THR3 = 10000;
    public static final String BACK_TMP = "_ssa";
    public static final int METHOD_I = 1;
    public static final int METHOD_II = 2;
    public static final int METHOD_III = 3;
    private final int type;
    private final boolean coalesce;
    private final boolean aggregate;
    private Function f;
    private SsaSymTab sstab;
    private Hashtable phiCongruenceClasses;
    private SsaEnvironment env;

    public boolean doIt(Data data, ImList args) {
        return true;
    }

    public String name() {
        return "BackTranslateFromSsa";
    }

    public String subject() {
        return "Back translation from SSA form using Sreedhar's method.";
    }

    BackTranslateFromSsa(SsaEnvironment e, SsaSymTab stab, int howToTranslate, boolean withCoalesce, boolean aggr) {
        this.sstab = stab;
        this.env = e;
        this.type = howToTranslate;
        this.coalesce = withCoalesce;
        this.aggregate = aggr;
        int msg = 100;
        this.env.print("  SSA back translation : ", msg);
        switch (this.type) {
            case 1: {
                this.env.print("METHOD I", msg);
                break;
            }
            case 2: {
                this.env.print("METHOD II", msg);
                break;
            }
            case 3: {
                this.env.print("METHOD III", msg);
            }
        }
        if (this.coalesce) {
            this.env.println(" with Coalescing.", msg);
        } else {
            this.env.println(" without Coalescing.", msg);
        }
    }

    public boolean doIt(Function function, ImList args) {
        this.env.println("****************** Back Translate from SSA form to " + function.symbol.name, 1000);
        this.f = function;
        if (this.aggregate) {
            AggregateInstructions aggre = new AggregateInstructions(this.env, this.f);
        }
        this.oustConstant();
        this.initPhiCongruenceClass(this.f.flowGraph());
        this.tssaToCssa(this.f.flowGraph());
        if (this.env.opt.isSet("ssa-debug")) {
            this.checkPcc();
        }
        if (this.coalesce) {
            this.coalescing(this.f.flowGraph());
        }
        this.leavingCssa(this.f.flowGraph());
        Util util = new Util(this.env, this.f);
        util.changeLabelRef(false);
        this.f.touch();
        this.env.println("", 1500);
        return true;
    }

    private void oustConstant() {
        BiLink p = this.f.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                LirNode node = (LirNode)q.elem();
                if (node.opCode == 59) {
                    for (int i = 1; i < node.nKids(); ++i) {
                        if (node.kid((int)i).kid((int)0).opCode == 6) continue;
                        LirNode src = node.kid(i).kid(0).makeCopy(this.env.lir);
                        LirNode dst = this.env.lir.symRef(this.sstab.newSsaSymbol(BACK_TMP, src.type));
                        LirNode copyAssign = this.env.lir.operator(48, src.type, dst, src, ImList.Empty);
                        BasicBlk b = ((LirLabelRef)node.kid((int)i).kid((int)1)).label.basicBlk();
                        b.instrList().last().addBefore(copyAssign);
                        node.kid(i).setKid(0, dst.makeCopy(this.env.lir));
                        this.f.touch();
                    }
                }
                q = q.next();
            }
            p = p.next();
        }
    }

    private void checkPcc() {
        this.env.output.print("SSA DBG : checking interfere " + this.f.symbol.name + " ... ");
        BiLink pp = this.f.flowGraph().basicBlkList.first();
        while (!pp.atEnd()) {
            BasicBlk blk = (BasicBlk)pp.elem();
            BiLink qq = blk.instrList().first();
            while (!qq.atEnd()) {
                LirNode node = (LirNode)qq.elem();
                if (node.opCode == 59) {
                    Symbol s = ((LirSymRef)node.kid((int)0)).symbol;
                    BiList pcc = (BiList)this.phiCongruenceClasses.get(s);
                    InterferenceGraph ig = (InterferenceGraph)this.f.require(InterferenceGraph.analyzer);
                    BiLink p = pcc.first();
                    while (!p.atEnd()) {
                        Symbol s1 = (Symbol)p.elem();
                        BiLink q = p.next();
                        while (!q.atEnd()) {
                            Symbol s2 = (Symbol)q.elem();
                            if (ig.interfere(s1, s2)) {
                                this.f.printIt(this.env.output);
                                this.env.output.println("\nSSA DBG : in " + pcc);
                                this.env.output.println("SSA DBG : " + s1 + " and " + s2 + " has interfere!!");
                                System.exit(1);
                            }
                            q = q.next();
                        }
                        p = p.next();
                    }
                }
                qq = qq.next();
            }
            pp = pp.next();
        }
        this.env.output.println("ok");
    }

    private void coalescing(FlowGraph g) {
        BiLink p = g.basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                LirNode node = (LirNode)q.elem();
                if (node.opCode == 48 && node.kid((int)0).opCode == 6 && node.kid((int)1).opCode == 6) {
                    Symbol x = ((LirSymRef)node.kid((int)0)).symbol;
                    Symbol y = ((LirSymRef)node.kid((int)1)).symbol;
                    BiList pccX = (BiList)this.phiCongruenceClasses.get(x);
                    BiList pccY = (BiList)this.phiCongruenceClasses.get(y);
                    if (pccX != null && pccY != null) {
                        Symbol s;
                        BiLink pp;
                        InterferenceGraph ig;
                        boolean interfered = false;
                        int pccXSize = pccX.length();
                        int pccYSize = pccY.length();
                        if (pccXSize == 0 && pccYSize == 0) {
                            this.env.println("SSA based coalescing : Case 1", 10000);
                        } else if (pccXSize == 0 && pccYSize > 0) {
                            this.env.println("SSA based coalescing : Case 2-1", 10000);
                            ig = (InterferenceGraph)this.f.require(InterferenceGraph.analyzer);
                            pp = pccY.first();
                            while (!pp.atEnd()) {
                                s = (Symbol)pp.elem();
                                if (!s.equals(y) && ig.interfere(x, s)) {
                                    this.env.println(x.name + " and " + s.name + " are interfered", 10000);
                                    interfered = true;
                                    break;
                                }
                                pp = pp.next();
                            }
                        } else if (pccXSize > 0 && pccYSize == 0) {
                            this.env.println("SSA based coalescing : Case 2-2", 10000);
                            ig = (InterferenceGraph)this.f.require(InterferenceGraph.analyzer);
                            pp = pccX.first();
                            while (!pp.atEnd()) {
                                s = (Symbol)pp.elem();
                                if (!s.equals(x) && ig.interfere(y, s)) {
                                    this.env.println(s.name + " and " + y.name + " are interfered", 10000);
                                    interfered = true;
                                    break;
                                }
                                pp = pp.next();
                            }
                        } else if (pccXSize > 0 && pccYSize > 0) {
                            ig = (InterferenceGraph)this.f.require(InterferenceGraph.analyzer);
                            if (pccX.equals(pccY)) {
                                this.env.println("SSA based coalescing : " + x.name + " and " + y.name + " have the same phiCongruenceClass", 10000);
                            } else {
                                Symbol ss;
                                BiLink qq;
                                this.env.println("SSA based coalescing : Case 3", 10000);
                                pp = pccX.first();
                                while (!pp.atEnd()) {
                                    s = (Symbol)pp.elem();
                                    if (!s.equals(x)) {
                                        qq = pccY.first();
                                        while (!qq.atEnd()) {
                                            ss = (Symbol)qq.elem();
                                            if (ig.interfere(s, ss)) {
                                                this.env.println(s.name + " and " + ss.name + " have interference", 10000);
                                                interfered = true;
                                                break;
                                            }
                                            qq = qq.next();
                                        }
                                        if (interfered) break;
                                    }
                                    pp = pp.next();
                                }
                                if (!interfered) {
                                    pp = pccY.first();
                                    while (!pp.atEnd()) {
                                        s = (Symbol)pp.elem();
                                        if (!s.equals(y)) {
                                            qq = pccX.first();
                                            while (!qq.atEnd()) {
                                                ss = (Symbol)qq.elem();
                                                if (ig.interfere(s, ss)) {
                                                    this.env.println(s.name + " and " + ss.name + " have interference", 10000);
                                                    interfered = true;
                                                    break;
                                                }
                                                qq = qq.next();
                                            }
                                            if (interfered) break;
                                        }
                                        pp = pp.next();
                                    }
                                }
                            }
                        }
                        if (!interfered) {
                            this.env.println("SSA based coalescing : remove " + node + " in block " + blk.id, 2000);
                            q.unlink();
                            this.f.flowGraph().touch();
                            BiList syms = new BiList();
                            syms.addNew(x);
                            syms.addNew(y);
                            pp = pccX.first();
                            while (!pp.atEnd()) {
                                syms.addNew(pp.elem());
                                pp = pp.next();
                            }
                            pp = pccY.first();
                            while (!pp.atEnd()) {
                                syms.addNew(pp.elem());
                                pp = pp.next();
                            }
                            BiList list = this.mergePhiCongruenceClass(syms);
                            list.addNew(x);
                            list.addNew(y);
                            BiLink pp2 = list.first();
                            while (!pp2.atEnd()) {
                                Symbol s2 = (Symbol)pp2.elem();
                                this.phiCongruenceClasses.remove(s2);
                                this.phiCongruenceClasses.put(s2, list);
                                pp2 = pp2.next();
                            }
                        }
                    }
                }
                q = q.next();
            }
            p = p.next();
        }
    }

    private void leavingCssa(FlowGraph g) {
        Hashtable<BiList, Symbol> representName = new Hashtable<BiList, Symbol>();
        BiLink p = g.basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                LirNode node = (LirNode)q.elem();
                if (node.opCode == 59) {
                    q.unlink();
                    g.touch();
                } else if (node.nKids() > 0) {
                    Stack<LirNode> stack = new Stack<LirNode>();
                    stack.push(node);
                    while (!stack.empty()) {
                        LirNode parent = (LirNode)stack.pop();
                        for (int i = 0; i < parent.nKids(); ++i) {
                            Symbol s;
                            BiList phiCongruenceClass;
                            LirNode child = parent.kid(i);
                            if (child.nKids() > 0) {
                                stack.push(child);
                                continue;
                            }
                            if (child.opCode != 6 || (phiCongruenceClass = (BiList)this.phiCongruenceClasses.get(s = ((LirSymRef)child).symbol)) == null) continue;
                            if (!representName.containsKey(phiCongruenceClass)) {
                                representName.put(phiCongruenceClass, s);
                            }
                            Symbol ss = (Symbol)representName.get(phiCongruenceClass);
                            LirSymRef newReg = (LirSymRef)this.env.lir.symRef(6, ss.type, ss, ImList.Empty);
                            parent.setKid(i, newReg);
                            g.touch();
                        }
                    }
                }
                q = q.next();
            }
            p = p.next();
        }
    }

    private void tssaToCssa(FlowGraph g) {
        BiList candidateResourceSet = null;
        BiLink p = g.basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                LirNode node = (LirNode)q.elem();
                if (node.opCode == 59) {
                    candidateResourceSet = this.type == 1 ? this.methodI((LirNaryOp)node) : (this.type == 2 ? this.methodII((LirNaryOp)node) : this.methodIII((LirNaryOp)node, blk));
                    this.insertCopy(candidateResourceSet, (LirNaryOp)node, blk);
                    this.mergePhiCongruenceClass((LirNaryOp)node);
                }
                q = q.next();
            }
            p = p.next();
        }
        Enumeration keys = this.phiCongruenceClasses.keys();
        while (keys.hasMoreElements()) {
            Symbol s = (Symbol)keys.nextElement();
            BiList phiCongruenceClass = (BiList)this.phiCongruenceClasses.get(s);
            if (phiCongruenceClass.length() != 1) continue;
            this.phiCongruenceClasses.remove(s);
            this.phiCongruenceClasses.put(s, new BiList());
        }
    }

    private void mergePhiCongruenceClass(LirNaryOp phiInst) {
        BiList symbols = new BiList();
        symbols.addNew(((LirSymRef)phiInst.kid((int)0)).symbol);
        for (int i = 1; i < phiInst.nKids(); ++i) {
            LirNode node = phiInst.kid(i).kid(0);
            if (!(node instanceof LirSymRef)) continue;
            symbols.addNew(((LirSymRef)phiInst.kid((int)i).kid((int)0)).symbol);
        }
        BiList merged = this.mergePhiCongruenceClass(symbols);
        BiLink pp = merged.first();
        while (!pp.atEnd()) {
            Symbol s = (Symbol)pp.elem();
            this.phiCongruenceClasses.remove(s);
            this.phiCongruenceClasses.put(s, merged);
            pp = pp.next();
        }
    }

    private BiList mergePhiCongruenceClass(BiList list) {
        Symbol s;
        Stack<Object> stack = new Stack<Object>();
        BiLink p = list.first();
        while (!p.atEnd()) {
            s = (Symbol)p.elem();
            stack.push(s);
            p = p.next();
        }
        BiList merged = new BiList();
        while (!stack.empty()) {
            s = (Symbol)stack.pop();
            if (merged.contains(s)) continue;
            merged.addNew(s);
            BiList pcc = (BiList)this.phiCongruenceClasses.get(s);
            if (pcc == null) continue;
            BiLink p2 = pcc.first();
            while (!p2.atEnd()) {
                stack.push(p2.elem());
                p2 = p2.next();
            }
        }
        return merged;
    }

    private BiList methodIII(LirNaryOp phi, BasicBlk blk) {
        BiList alreadyInserted = new BiList();
        BiList candidateResourceSet = new BiList();
        Hashtable<LirNode, BiList> unresolvedNeighborMap = new Hashtable<LirNode, BiList>();
        this.env.println("\n___ in " + phi, 10000);
        BiList unresolvedKeys = new BiList();
        for (int i = 0; i < phi.nKids() - 1; ++i) {
            m3Datas data = new m3Datas();
            if (i == 0) {
                data.setXi((LirSymRef)phi.kid(i), blk);
            } else {
                data.setXi((LirNaryOp)phi.kid(i));
            }
            for (int j = i + 1; j < phi.nKids(); ++j) {
                data.setXj((LirNaryOp)phi.kid(j));
                if (data.hasInterfere()) {
                    this.env.print("  Has interfere (" + data.nodeXi + "," + data.nodeXj + ")", 10000);
                    int whichCase = data.whichCase();
                    this.env.println("   --->  Case " + whichCase, 10000);
                    if (whichCase == 1 || whichCase == 3) {
                        candidateResourceSet.addNew(data.nodeXi);
                    }
                    if (whichCase == 2 || whichCase == 3) {
                        candidateResourceSet.addNew(data.nodeXj);
                    }
                    if (whichCase == 4) {
                        BiList unresolved = (BiList)unresolvedNeighborMap.get(data.nodeXi);
                        if (unresolved == null) {
                            unresolved = new BiList();
                            unresolvedNeighborMap.put(data.nodeXi, unresolved);
                        }
                        unresolved.addNew(data.nodeXj);
                        unresolvedKeys.addNew(data.nodeXi);
                        unresolved = (BiList)unresolvedNeighborMap.get(data.nodeXj);
                        if (unresolved == null) {
                            unresolved = new BiList();
                            unresolvedNeighborMap.put(data.nodeXj, unresolved);
                        }
                        unresolved.addNew(data.nodeXi);
                        unresolvedKeys.addNew(data.nodeXj);
                    }
                } else {
                    this.env.println("  No interfere (" + data.nodeXi + "," + data.nodeXj + ")", 10000);
                }
                data.unsetXj();
            }
        }
        BiList sorted = new BiList();
        BiLink p = unresolvedKeys.first();
        while (!p.atEnd()) {
            LirNode node1 = (LirNode)p.elem();
            BiList map1 = (BiList)unresolvedNeighborMap.get(node1);
            BiLink q = sorted.first();
            while (true) {
                if (q.atEnd()) {
                    sorted.add(node1);
                    break;
                }
                LirNode node2 = (LirNode)q.elem();
                BiList map2 = (BiList)unresolvedNeighborMap.get(node2);
                if (map2.length() < map1.length()) {
                    q.addBefore(node1);
                    break;
                }
                q = q.next();
            }
            p = p.next();
        }
        BiLink key = sorted.first();
        while (!key.atEnd()) {
            LirNode node = (LirNode)key.elem();
            if (!candidateResourceSet.contains(node)) {
                BiList uSyms = (BiList)unresolvedNeighborMap.get(node);
                boolean shouldAdd = false;
                BiLink p2 = uSyms.first();
                while (!p2.atEnd()) {
                    LirNode neighbor = (LirNode)p2.elem();
                    if (!candidateResourceSet.contains(neighbor)) {
                        shouldAdd = true;
                        break;
                    }
                    p2 = p2.next();
                }
                if (shouldAdd) {
                    candidateResourceSet.addNew(node);
                    this.env.println("  Added " + node + " By case 4.", 10000);
                }
            }
            key = key.next();
        }
        return candidateResourceSet;
    }

    private BiList methodII(LirNaryOp phi) {
        BiList alreadyInserted = new BiList();
        InterferenceGraph ig = (InterferenceGraph)this.f.require(InterferenceGraph.analyzer);
        BiList candidateResourceSet = new BiList();
        BiList syms = new BiList();
        syms.add(phi.kid(0));
        for (int i = 1; i < phi.nKids(); ++i) {
            syms.add(phi.kid(i));
        }
        BiLink p = syms.first();
        while (!p.atEnd()) {
            LirNode inode = (LirNode)p.elem();
            Symbol xi = null;
            if (inode.opCode == 61 && inode.kid(0) instanceof LirSymRef) {
                xi = ((LirSymRef)inode.kid((int)0)).symbol;
            } else if (inode.opCode == 6) {
                xi = ((LirSymRef)inode).symbol;
            }
            BiLink q = p.next();
            while (!q.atEnd()) {
                LirNode jnode = (LirNode)q.elem();
                Symbol xj = null;
                if (jnode.opCode == 61 && jnode.kid(0) instanceof LirSymRef) {
                    xj = ((LirSymRef)jnode.kid((int)0)).symbol;
                } else if (jnode.opCode == 6) {
                    xj = ((LirSymRef)jnode).symbol;
                }
                if (xi == null || xj == null) {
                    candidateResourceSet.addNew(inode);
                    candidateResourceSet.addNew(jnode);
                }
                if (xi != null && xj != null && xi != xj) {
                    BiList pccXj;
                    BiList pccXi = (BiList)this.phiCongruenceClasses.get(xi);
                    if (pccXi == (pccXj = (BiList)this.phiCongruenceClasses.get(xj))) break;
                    BiList xiList = new BiList();
                    BiList xjList = new BiList();
                    if (pccXi != null) {
                        xiList = pccXi.copy();
                    }
                    xiList.add(xi);
                    if (pccXj != null) {
                        xjList = pccXj.copy();
                    }
                    xjList.add(xj);
                    boolean exit = false;
                    BiLink pp = xiList.first();
                    while (!pp.atEnd()) {
                        Symbol si = (Symbol)pp.elem();
                        BiLink qq = xjList.first();
                        while (!qq.atEnd()) {
                            Symbol sj = (Symbol)qq.elem();
                            if (ig.interfere(si, sj)) {
                                candidateResourceSet.addNew(jnode);
                                candidateResourceSet.addNew(inode);
                                exit = true;
                                break;
                            }
                            qq = qq.next();
                        }
                        if (exit) break;
                        pp = pp.next();
                    }
                }
                q = q.next();
            }
            p = p.next();
        }
        return candidateResourceSet;
    }

    private BiList methodI(LirNaryOp phi) {
        BiList candidateResourceSet = new BiList();
        candidateResourceSet.addNew(phi.kid(0));
        for (int i = 1; i < phi.nKids(); ++i) {
            LirNode node = phi.kid(i).kid(0);
            candidateResourceSet.addNew(phi.kid(i));
        }
        return candidateResourceSet;
    }

    private void initPhiCongruenceClass(FlowGraph g) {
        this.phiCongruenceClasses = new Hashtable();
        BiLink p = g.basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                LirNode node = (LirNode)q.elem();
                if (node.opCode == 59) {
                    Util util = new Util(this.env, this.f);
                    BiList symList = util.findTargetLir(node, 6, new BiList());
                    BiLink r = symList.first();
                    while (!r.atEnd()) {
                        LirSymRef reg = (LirSymRef)r.elem();
                        if (this.phiCongruenceClasses.get(reg.symbol) == null) {
                            BiList phiCongruenceClass = new BiList();
                            phiCongruenceClass.addNew(reg.symbol);
                            this.phiCongruenceClasses.put(reg.symbol, phiCongruenceClass);
                        }
                        r = r.next();
                    }
                }
                q = q.next();
            }
            p = p.next();
        }
    }

    private void insertCopy(BiList candidateResourceSet, LirNaryOp phiInst, BasicBlk L0) {
        BiLink p = candidateResourceSet.first();
        while (!p.atEnd()) {
            Symbol xi;
            LirNode node = (LirNode)p.elem();
            if (node.opCode == 61) {
                xi = null;
                if (node.kid(0) instanceof LirSymRef) {
                    xi = ((LirSymRef)node.kid((int)0)).symbol;
                }
                BasicBlk Lk = ((LirLabelRef)node.kid((int)1)).label.basicBlk();
                Symbol xnew_i = null;
                xnew_i = node.kid(0) instanceof LirSymRef ? this.sstab.newSsaSymbol(xi) : this.sstab.newSsaSymbol(BACK_TMP, node.kid((int)0).type);
                LirSymRef dst = (LirSymRef)this.env.lir.symRef(6, xnew_i.type, xnew_i, ImList.Empty);
                LirNode src = null;
                src = node.kid(0) instanceof LirSymRef ? this.env.lir.symRef(6, xi.type, xi, ImList.Empty) : (node.kid(0) instanceof LirIconst ? this.env.lir.iconst(node.kid((int)0).type, ((LirIconst)node.kid((int)0)).value, ImList.Empty) : (node.kid(0) instanceof LirFconst ? this.env.lir.fconst(node.kid((int)0).type, ((LirFconst)node.kid((int)0)).value, ImList.Empty) : node.kid(0).makeCopy(this.env.lir)));
                LirBinOp copyOp = (LirBinOp)this.env.lir.operator(48, dst.type, dst, src, ImList.Empty);
                Lk.instrList().last().addBefore(copyOp);
                this.env.println("Insert Copy : " + copyOp + " in block " + Lk.id, 1500);
                this.f.flowGraph().touch();
                if (this.phiCongruenceClasses.get(xnew_i) == null) {
                    BiList phiCongruenceClass = new BiList();
                    phiCongruenceClass.addNew(xnew_i);
                    this.phiCongruenceClasses.put(xnew_i, phiCongruenceClass);
                }
                LirNode newReg = this.env.lir.symRef(6, xnew_i.type, xnew_i, ImList.Empty);
                node.setKid(0, newReg);
                this.f.require(InterferenceGraph.analyzer);
            } else if (node.opCode == 6) {
                xi = ((LirSymRef)node).symbol;
                Symbol xnew_0 = this.sstab.newSsaSymbol(xi);
                LirSymRef dst = (LirSymRef)this.env.lir.symRef(6, xi.type, xi, ImList.Empty);
                LirSymRef src = (LirSymRef)this.env.lir.symRef(6, xnew_0.type, xnew_0, ImList.Empty);
                LirBinOp copyOp = (LirBinOp)this.env.lir.operator(48, dst.type, dst, src, ImList.Empty);
                BiLink q = L0.instrList().first();
                while (!q.atEnd()) {
                    LirNode tempNode = (LirNode)q.elem();
                    if (tempNode.opCode != 59) {
                        q.addBefore(copyOp);
                        this.f.flowGraph().touch();
                        this.env.println("Insert Copy : " + copyOp + " in block " + L0.id, 1500);
                        break;
                    }
                    q = q.next();
                }
                if (this.phiCongruenceClasses.get(xnew_0) == null) {
                    BiList phiCongruenceClass = new BiList();
                    phiCongruenceClass.addNew(xnew_0);
                    this.phiCongruenceClasses.put(xnew_0, phiCongruenceClass);
                }
                LirNode newReg = this.env.lir.symRef(6, xnew_0.type, xnew_0, ImList.Empty);
                phiInst.setKid(0, newReg);
                this.f.require(InterferenceGraph.analyzer);
            } else {
                System.err.println("BackTranslateFromSsa.java : unexpected LIR " + node);
                System.exit(1);
            }
            p = p.next();
        }
    }

    private class m3Datas {
        LirNode nodeXi = null;
        LirNode nodeXj = null;
        Symbol xi = null;
        Symbol xj = null;
        BasicBlk Li = null;
        BasicBlk Lj = null;
        BiList liveXi = null;
        BiList liveXj = null;
        BiList pccXi = null;
        BiList pccXj = null;

        m3Datas() {
        }

        boolean hasIntersection(BiList pcc, BiList live) {
            if (pcc == null) {
                return true;
            }
            BiList mergedLive = BackTranslateFromSsa.this.mergePhiCongruenceClass(live);
            BiLink p = pcc.first();
            while (!p.atEnd()) {
                Symbol s = (Symbol)p.elem();
                if (mergedLive.contains(s)) {
                    return true;
                }
                p = p.next();
            }
            return false;
        }

        int whichCase() {
            boolean intersect1 = this.hasIntersection(this.pccXi, this.liveXj);
            boolean intersect2 = this.hasIntersection(this.pccXj, this.liveXi);
            if (intersect1 && !intersect2) {
                return 1;
            }
            if (!intersect1 && intersect2) {
                return 2;
            }
            if (intersect1 && intersect2) {
                return 3;
            }
            return 4;
        }

        void setXi(LirNaryOp node) {
            this.nodeXi = node;
            if (node.kid(0) instanceof LirSymRef) {
                this.xi = ((LirSymRef)node.kid((int)0)).symbol;
            }
            this.Li = ((LirLabelRef)node.kid((int)1)).label.basicBlk();
            LiveVariableAnalysis liveAna = (LiveVariableAnalysis)BackTranslateFromSsa.this.f.require(LiveVariableSlotwise.analyzer);
            this.liveXi = liveAna.liveOut(this.Li);
            if (node.kid(0) instanceof LirSymRef) {
                this.pccXi = (BiList)BackTranslateFromSsa.this.phiCongruenceClasses.get(this.xi);
            }
        }

        void setXi(LirSymRef node, BasicBlk blk) {
            this.nodeXi = node;
            this.xi = node.symbol;
            this.Li = blk;
            LiveVariableAnalysis liveAna = (LiveVariableAnalysis)BackTranslateFromSsa.this.f.require(LiveVariableSlotwise.analyzer);
            this.liveXi = liveAna.liveIn(this.Li);
            this.pccXi = (BiList)BackTranslateFromSsa.this.phiCongruenceClasses.get(this.xi);
        }

        void setXj(LirNaryOp node) {
            this.nodeXj = node;
            if (node.kid(0) instanceof LirSymRef) {
                this.xj = ((LirSymRef)node.kid((int)0)).symbol;
            }
            this.Lj = ((LirLabelRef)node.kid((int)1)).label.basicBlk();
            LiveVariableAnalysis liveAna = (LiveVariableAnalysis)BackTranslateFromSsa.this.f.require(LiveVariableSlotwise.analyzer);
            this.liveXj = liveAna.liveOut(this.Lj);
            if (node.kid(0) instanceof LirSymRef) {
                this.pccXj = (BiList)BackTranslateFromSsa.this.phiCongruenceClasses.get(this.xj);
            }
        }

        void unsetXj() {
            this.nodeXj = null;
            this.xj = null;
            this.Lj = null;
            this.liveXj = null;
            this.pccXj = null;
        }

        boolean hasInterfere() {
            if (this.pccXi == null || this.pccXj == null) {
                return true;
            }
            InterferenceGraph ig = (InterferenceGraph)BackTranslateFromSsa.this.f.require(InterferenceGraph.analyzer);
            BiLink p = this.pccXi.first();
            while (!p.atEnd()) {
                Symbol yi = (Symbol)p.elem();
                BiLink q = this.pccXj.first();
                while (!q.atEnd()) {
                    Symbol yj = (Symbol)q.elem();
                    if (!yi.equals(yj) && ig.interfere(yi, yj)) {
                        return true;
                    }
                    q = q.next();
                }
                p = p.next();
            }
            return false;
        }

        void print() {
            ((BackTranslateFromSsa)BackTranslateFromSsa.this).env.output.println("xi : " + this.xi.name);
            ((BackTranslateFromSsa)BackTranslateFromSsa.this).env.output.println("xj : " + this.xj.name);
        }
    }
}

